/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.auth.ecr;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.service.docker.auth.ecr.AwsSdkHelper;
import org.eclipse.jkube.kit.common.KitLogger;

public class AwsSdkAuthConfigFactory {
    private final KitLogger log;
    private AwsSdkHelper awsSdkHelper;

    public AwsSdkAuthConfigFactory(KitLogger log, AwsSdkHelper awsSdkHelper) {
        this.log = log;
        this.awsSdkHelper = awsSdkHelper;
    }

    public AuthConfig createAuthConfig() {
        try {
            Object credentials = this.awsSdkHelper.getCredentialsFromDefaultAWSCredentialsProviderChain();
            if (credentials == null) {
                return null;
            }
            return AuthConfig.builder().username(this.awsSdkHelper.getAWSAccessKeyIdFromCredentials(credentials)).password(this.awsSdkHelper.getAwsSecretKeyFromCredentials(credentials)).email("none").auth(this.awsSdkHelper.getSessionTokenFromCrendentials(credentials)).build();
        }
        catch (Exception t) {
            String issueTitle = null;
            try {
                issueTitle = URLEncoder.encode("Failed calling AWS SDK: " + t.getMessage(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.log.warn("Failed to fetch AWS credentials: %s", new Object[]{t.getMessage()});
            if (t.getCause() != null) {
                this.log.warn("Caused by: %s", new Object[]{t.getCause().getMessage()});
            }
            this.log.warn("Please report a bug at https://github.com/eclipse/jkube/issues/new?%s", new Object[]{issueTitle == null ? "" : "title=?" + issueTitle});
            this.log.warn("%s", new Object[]{t});
            return null;
        }
    }
}

