/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerConnectionDetector;
import org.eclipse.jkube.kit.build.service.docker.access.DockerMachine;
import org.eclipse.jkube.kit.build.service.docker.access.hc.DockerAccessWithHcClient;
import org.eclipse.jkube.kit.build.service.docker.config.DockerMachineConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;

public class DockerAccessFactory {
    public DockerAccess createDockerAccess(DockerAccessContext dockerAccessContext) {
        try {
            DockerConnectionDetector dockerConnectionDetector = this.createDockerConnectionDetector(dockerAccessContext, dockerAccessContext.getLog());
            DockerConnectionDetector.ConnectionParameter connectionParam = dockerConnectionDetector.detectConnectionParameter(dockerAccessContext.getDockerHost(), dockerAccessContext.getCertPath());
            DockerAccessWithHcClient access = new DockerAccessWithHcClient(connectionParam.getUrl(), connectionParam.getCertPath(), dockerAccessContext.getMaxConnections(), dockerAccessContext.getLog());
            access.start();
            this.setDockerHostAddressProperty(dockerAccessContext, connectionParam.getUrl());
            return access;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create docker access object ", e);
        }
    }

    private DockerConnectionDetector createDockerConnectionDetector(DockerAccessContext dockerAccessContext, KitLogger log) {
        return new DockerConnectionDetector(this.getDockerHostProviders(dockerAccessContext, log));
    }

    private List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders(DockerAccessContext dockerAccessContext, KitLogger log) {
        if (dockerAccessContext.getDockerHostProviders() != null) {
            return dockerAccessContext.getDockerHostProviders();
        }
        return this.getDefaultDockerHostProviders(dockerAccessContext, log);
    }

    private List<DockerConnectionDetector.DockerHostProvider> getDefaultDockerHostProviders(DockerAccessContext dockerAccessContext, KitLogger log) {
        Properties projectProps;
        DockerMachineConfiguration config = dockerAccessContext.getMachine();
        if (dockerAccessContext.isSkipMachine()) {
            config = null;
        } else if (config == null && (projectProps = dockerAccessContext.getProjectProperties()).containsKey("docker.machine.name")) {
            config = new DockerMachineConfiguration(projectProps.getProperty("docker.machine.name"), projectProps.getProperty("docker.machine.autoCreate"), projectProps.getProperty("docker.machine.regenerateCertsAfterStart"));
        }
        ArrayList<DockerConnectionDetector.DockerHostProvider> ret = new ArrayList<DockerConnectionDetector.DockerHostProvider>();
        ret.add(new DockerMachine(log, config));
        return ret;
    }

    private void setDockerHostAddressProperty(DockerAccessContext dockerAccessContext, String dockerUrl) {
        Properties props = dockerAccessContext.getProjectProperties();
        if (props.getProperty("docker.host.address") == null) {
            String host;
            try {
                URI uri = new URI(dockerUrl);
                host = uri.getHost() == null && (uri.getScheme().equals("unix") || uri.getScheme().equals("npipe")) ? "localhost" : uri.getHost();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Cannot parse " + dockerUrl + " as URI: " + e.getMessage(), e);
            }
            props.setProperty("docker.host.address", host == null ? "" : host);
        }
    }

    public static class DockerAccessContext
    implements Serializable {
        private static final long serialVersionUID = -4768689117574797600L;
        public static final int DEFAULT_MAX_CONNECTIONS = 100;
        private Properties projectProperties;
        private DockerMachineConfiguration machine;
        private List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders;
        private boolean skipMachine;
        private String dockerHost;
        private String certPath;
        private int maxConnections;
        private KitLogger log;

        public static DockerAccessContext getDefault(KitLogger kitLogger) {
            return DockerAccessContext.builder().projectProperties(System.getProperties()).skipMachine(false).maxConnections(100).log(kitLogger).build();
        }

        @Generated
        public static DockerAccessContextBuilder builder() {
            return new DockerAccessContextBuilder();
        }

        @Generated
        public DockerAccessContext(Properties projectProperties, DockerMachineConfiguration machine, List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders, boolean skipMachine, String dockerHost, String certPath, int maxConnections, KitLogger log) {
            this.projectProperties = projectProperties;
            this.machine = machine;
            this.dockerHostProviders = dockerHostProviders;
            this.skipMachine = skipMachine;
            this.dockerHost = dockerHost;
            this.certPath = certPath;
            this.maxConnections = maxConnections;
            this.log = log;
        }

        @Generated
        public DockerAccessContext() {
        }

        @Generated
        public Properties getProjectProperties() {
            return this.projectProperties;
        }

        @Generated
        public DockerMachineConfiguration getMachine() {
            return this.machine;
        }

        @Generated
        public List<DockerConnectionDetector.DockerHostProvider> getDockerHostProviders() {
            return this.dockerHostProviders;
        }

        @Generated
        public boolean isSkipMachine() {
            return this.skipMachine;
        }

        @Generated
        public String getDockerHost() {
            return this.dockerHost;
        }

        @Generated
        public String getCertPath() {
            return this.certPath;
        }

        @Generated
        public int getMaxConnections() {
            return this.maxConnections;
        }

        @Generated
        public KitLogger getLog() {
            return this.log;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DockerAccessContext)) {
                return false;
            }
            DockerAccessContext other = (DockerAccessContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSkipMachine() != other.isSkipMachine()) {
                return false;
            }
            if (this.getMaxConnections() != other.getMaxConnections()) {
                return false;
            }
            Properties this$projectProperties = this.getProjectProperties();
            Properties other$projectProperties = other.getProjectProperties();
            if (this$projectProperties == null ? other$projectProperties != null : !((Object)this$projectProperties).equals(other$projectProperties)) {
                return false;
            }
            DockerMachineConfiguration this$machine = this.getMachine();
            DockerMachineConfiguration other$machine = other.getMachine();
            if (this$machine == null ? other$machine != null : !this$machine.equals(other$machine)) {
                return false;
            }
            List<DockerConnectionDetector.DockerHostProvider> this$dockerHostProviders = this.getDockerHostProviders();
            List<DockerConnectionDetector.DockerHostProvider> other$dockerHostProviders = other.getDockerHostProviders();
            if (this$dockerHostProviders == null ? other$dockerHostProviders != null : !((Object)this$dockerHostProviders).equals(other$dockerHostProviders)) {
                return false;
            }
            String this$dockerHost = this.getDockerHost();
            String other$dockerHost = other.getDockerHost();
            if (this$dockerHost == null ? other$dockerHost != null : !this$dockerHost.equals(other$dockerHost)) {
                return false;
            }
            String this$certPath = this.getCertPath();
            String other$certPath = other.getCertPath();
            if (this$certPath == null ? other$certPath != null : !this$certPath.equals(other$certPath)) {
                return false;
            }
            KitLogger this$log = this.getLog();
            KitLogger other$log = other.getLog();
            return !(this$log == null ? other$log != null : !this$log.equals(other$log));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DockerAccessContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSkipMachine() ? 79 : 97);
            result = result * 59 + this.getMaxConnections();
            Properties $projectProperties = this.getProjectProperties();
            result = result * 59 + ($projectProperties == null ? 43 : ((Object)$projectProperties).hashCode());
            DockerMachineConfiguration $machine = this.getMachine();
            result = result * 59 + ($machine == null ? 43 : $machine.hashCode());
            List<DockerConnectionDetector.DockerHostProvider> $dockerHostProviders = this.getDockerHostProviders();
            result = result * 59 + ($dockerHostProviders == null ? 43 : ((Object)$dockerHostProviders).hashCode());
            String $dockerHost = this.getDockerHost();
            result = result * 59 + ($dockerHost == null ? 43 : $dockerHost.hashCode());
            String $certPath = this.getCertPath();
            result = result * 59 + ($certPath == null ? 43 : $certPath.hashCode());
            KitLogger $log = this.getLog();
            result = result * 59 + ($log == null ? 43 : $log.hashCode());
            return result;
        }

        @Generated
        public static class DockerAccessContextBuilder {
            @Generated
            private Properties projectProperties;
            @Generated
            private DockerMachineConfiguration machine;
            @Generated
            private List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders;
            @Generated
            private boolean skipMachine;
            @Generated
            private String dockerHost;
            @Generated
            private String certPath;
            @Generated
            private int maxConnections;
            @Generated
            private KitLogger log;

            @Generated
            DockerAccessContextBuilder() {
            }

            @Generated
            public DockerAccessContextBuilder projectProperties(Properties projectProperties) {
                this.projectProperties = projectProperties;
                return this;
            }

            @Generated
            public DockerAccessContextBuilder machine(DockerMachineConfiguration machine) {
                this.machine = machine;
                return this;
            }

            @Generated
            public DockerAccessContextBuilder dockerHostProviders(List<DockerConnectionDetector.DockerHostProvider> dockerHostProviders) {
                this.dockerHostProviders = dockerHostProviders;
                return this;
            }

            @Generated
            public DockerAccessContextBuilder skipMachine(boolean skipMachine) {
                this.skipMachine = skipMachine;
                return this;
            }

            @Generated
            public DockerAccessContextBuilder dockerHost(String dockerHost) {
                this.dockerHost = dockerHost;
                return this;
            }

            @Generated
            public DockerAccessContextBuilder certPath(String certPath) {
                this.certPath = certPath;
                return this;
            }

            @Generated
            public DockerAccessContextBuilder maxConnections(int maxConnections) {
                this.maxConnections = maxConnections;
                return this;
            }

            @Generated
            public DockerAccessContextBuilder log(KitLogger log) {
                this.log = log;
                return this;
            }

            @Generated
            public DockerAccessContext build() {
                return new DockerAccessContext(this.projectProperties, this.machine, this.dockerHostProviders, this.skipMachine, this.dockerHost, this.certPath, this.maxConnections, this.log);
            }

            @Generated
            public String toString() {
                return "DockerAccessFactory.DockerAccessContext.DockerAccessContextBuilder(projectProperties=" + this.projectProperties + ", machine=" + this.machine + ", dockerHostProviders=" + this.dockerHostProviders + ", skipMachine=" + this.skipMachine + ", dockerHost=" + this.dockerHost + ", certPath=" + this.certPath + ", maxConnections=" + this.maxConnections + ", log=" + this.log + ")";
            }
        }
    }
}

