/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access;

import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class KeyStoreUtil {
    public static KeyStore createDockerKeyStore(String certPath) throws IOException, GeneralSecurityException {
        PrivateKey privKey = KeyStoreUtil.loadPrivateKey(certPath + "/key.pem");
        Certificate[] certs = KeyStoreUtil.loadCertificates(certPath + "/cert.pem");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        keyStore.setKeyEntry("docker", privKey, "docker".toCharArray(), certs);
        KeyStoreUtil.addCA(keyStore, certPath + "/ca.pem");
        return keyStore;
    }

    static PrivateKey loadPrivateKey(String keyPath) throws IOException, GeneralSecurityException {
        block36: {
            try (FileReader reader = new FileReader(keyPath);){
                PrivateKey privateKey;
                try (PEMParser parser = new PEMParser((Reader)reader);){
                    Object readObject;
                    do {
                        if ((readObject = parser.readObject()) == null) break block36;
                        if (!(readObject instanceof PEMKeyPair)) continue;
                        PEMKeyPair keyPair = (PEMKeyPair)readObject;
                        PrivateKey privateKey2 = KeyStoreUtil.generatePrivateKey(keyPair.getPrivateKeyInfo());
                        return privateKey2;
                    } while (!(readObject instanceof PrivateKeyInfo));
                    privateKey = KeyStoreUtil.generatePrivateKey((PrivateKeyInfo)readObject);
                }
                return privateKey;
            }
        }
        throw new GeneralSecurityException("Cannot generate private key from file: " + keyPath);
    }

    private static PrivateKey generatePrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        return new JcaPEMKeyConverter().getPrivateKey(keyInfo);
    }

    private static void addCA(KeyStore keyStore, String caPath) throws IOException, KeyStoreException, CertificateException {
        for (Certificate cert : KeyStoreUtil.loadCertificates(caPath)) {
            X509Certificate crt = (X509Certificate)cert;
            String alias = crt.getSubjectX500Principal().getName();
            keyStore.setCertificateEntry(alias, crt);
        }
    }

    private static Certificate[] loadCertificates(String certPath) throws IOException, CertificateException {
        try (FileInputStream is = new FileInputStream(certPath);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            Collection<? extends Certificate> certs = certificateFactory.generateCertificates(is);
            Certificate[] certificateArray = certs.toArray(new Certificate[certs.size()]);
            return certificateArray;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

