/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jkube.kit.common.ExternalCommand;
import org.eclipse.jkube.kit.common.KitLogger;

public abstract class EnvCommand
extends ExternalCommand {
    private final Map<String, String> env = new HashMap<String, String>();
    private final String prefix;
    private final Pattern ENV_VAR_PATTERN = Pattern.compile("^\\s*(?<key>[^=]+)=\"?(?<value>.*?)\"?\\s*$");

    public EnvCommand(KitLogger log, String prefix) {
        super(log);
        this.prefix = prefix;
    }

    protected void processLine(String line) {
        if (this.log.isDebugEnabled()) {
            this.log.verbose("%s", new Object[]{line});
        }
        if (line.startsWith(this.prefix)) {
            this.setEnvironmentVariable(line.substring(this.prefix.length()));
        }
    }

    private void setEnvironmentVariable(String line) {
        Matcher matcher = this.ENV_VAR_PATTERN.matcher(line);
        if (matcher.matches()) {
            String key = matcher.group("key");
            String value = matcher.group("value");
            this.log.debug("Env: %s=%s", new Object[]{key, value});
            this.env.put(key, value);
        }
    }

    public Map<String, String> getEnvironment() throws IOException {
        this.execute();
        return this.env;
    }
}

