/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import org.eclipse.jkube.kit.build.api.assembly.AssemblyManager;
import org.eclipse.jkube.kit.build.service.docker.ContainerTracker;
import org.eclipse.jkube.kit.build.service.docker.DockerAccessFactory;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpecFactory;
import org.eclipse.jkube.kit.common.KitLogger;

public class ServiceHubFactory {
    private static final LogOutputSpecFactory DEFAULT_LOG_OUTPUT_SPEC_FACTORY = new LogOutputSpecFactory(true, true);
    private final ContainerTracker containerTracker = new ContainerTracker();
    private LogOutputSpecFactory logOutputSpecFactory;

    public ServiceHub createServiceHub(KitLogger kitLogger) {
        return this.createServiceHub(new DockerAccessFactory().createDockerAccess(DockerAccessFactory.DockerAccessContext.getDefault(kitLogger)), kitLogger, DEFAULT_LOG_OUTPUT_SPEC_FACTORY);
    }

    public ServiceHub createServiceHub(DockerAccess access, KitLogger kitLogger, LogOutputSpecFactory logSpecFactory) {
        this.logOutputSpecFactory = logSpecFactory;
        return new ServiceHub(access, this.containerTracker, AssemblyManager.getInstance(), kitLogger, logSpecFactory);
    }

    public LogOutputSpecFactory getLogOutputSpecFactory() {
        return this.logOutputSpecFactory;
    }
}

