/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class RegistryAuthConfig {
    private final Map<String, Map<String, String>> handlerConfig;
    private final Map<Kind, Map<String, String>> kindConfig;
    private final Map<String, String> defaultConfig;
    private boolean skipExtendedAuthentication = false;
    private String propertyPrefix;

    public RegistryAuthConfig(Map<String, Map<String, String>> handlerConfig, Map<Kind, Map<String, String>> kindConfig, Map<String, String> defaultConfig, boolean skipExtendedAuthentication, String propertyPrefix) {
        this.handlerConfig = Optional.ofNullable(handlerConfig).orElse(new HashMap());
        this.kindConfig = Optional.ofNullable(kindConfig).orElse(new HashMap());
        this.defaultConfig = Optional.ofNullable(defaultConfig).orElse(new HashMap());
        this.skipExtendedAuthentication = skipExtendedAuthentication;
        this.propertyPrefix = propertyPrefix;
    }

    public String getConfigForHandler(String handlerName, String key) {
        return Optional.ofNullable(this.handlerConfig.get(handlerName)).map(m -> (String)m.get(key)).orElse(null);
    }

    public String getUsername(Kind kind) {
        return this.getValueWithFallback(kind, "username");
    }

    public String getPassword(Kind kind) {
        return this.getValueWithFallback(kind, "password");
    }

    public String getEmail(Kind kind) {
        return this.getValueWithFallback(kind, "email");
    }

    public String getAuth(Kind kind) {
        return this.getValueWithFallback(kind, "authToken");
    }

    private String getValueWithFallback(Kind kind, String key) {
        return Optional.ofNullable(this.kindConfig.get((Object)kind)).map(m -> (String)m.get(key)).orElse(this.defaultConfig.get(key));
    }

    public boolean skipExtendedAuthentication() {
        return this.skipExtendedAuthentication;
    }

    public String extractFromProperties(Properties properties, Kind kind, String key) {
        String value = properties.getProperty(this.propertyPrefix + "." + kind.name().toLowerCase() + "." + key);
        if (value != null) {
            return value;
        }
        return properties.getProperty(this.propertyPrefix + "." + key);
    }

    public static RegistryAuthConfigBuilder builder() {
        return new RegistryAuthConfigBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryAuthConfig)) {
            return false;
        }
        RegistryAuthConfig other = (RegistryAuthConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.skipExtendedAuthentication != other.skipExtendedAuthentication) {
            return false;
        }
        Map<String, Map<String, String>> this$handlerConfig = this.handlerConfig;
        Map<String, Map<String, String>> other$handlerConfig = other.handlerConfig;
        if (this$handlerConfig == null ? other$handlerConfig != null : !((Object)this$handlerConfig).equals(other$handlerConfig)) {
            return false;
        }
        Map<Kind, Map<String, String>> this$kindConfig = this.kindConfig;
        Map<Kind, Map<String, String>> other$kindConfig = other.kindConfig;
        if (this$kindConfig == null ? other$kindConfig != null : !((Object)this$kindConfig).equals(other$kindConfig)) {
            return false;
        }
        Map<String, String> this$defaultConfig = this.defaultConfig;
        Map<String, String> other$defaultConfig = other.defaultConfig;
        if (this$defaultConfig == null ? other$defaultConfig != null : !((Object)this$defaultConfig).equals(other$defaultConfig)) {
            return false;
        }
        String this$propertyPrefix = this.propertyPrefix;
        String other$propertyPrefix = other.propertyPrefix;
        return !(this$propertyPrefix == null ? other$propertyPrefix != null : !this$propertyPrefix.equals(other$propertyPrefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryAuthConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.skipExtendedAuthentication ? 79 : 97);
        Map<String, Map<String, String>> $handlerConfig = this.handlerConfig;
        result = result * 59 + ($handlerConfig == null ? 43 : ((Object)$handlerConfig).hashCode());
        Map<Kind, Map<String, String>> $kindConfig = this.kindConfig;
        result = result * 59 + ($kindConfig == null ? 43 : ((Object)$kindConfig).hashCode());
        Map<String, String> $defaultConfig = this.defaultConfig;
        result = result * 59 + ($defaultConfig == null ? 43 : ((Object)$defaultConfig).hashCode());
        String $propertyPrefix = this.propertyPrefix;
        result = result * 59 + ($propertyPrefix == null ? 43 : $propertyPrefix.hashCode());
        return result;
    }

    public static class RegistryAuthConfigBuilder {
        private Map<String, Map<String, String>> handlerConfig;
        private Map<Kind, Map<String, String>> kindConfig;
        private ArrayList<String> defaultConfig$key;
        private ArrayList<String> defaultConfig$value;
        private boolean skipExtendedAuthentication;
        private String propertyPrefix;

        public RegistryAuthConfigBuilder addKindConfig(Kind kind, String key, String value) {
            if (this.kindConfig == null) {
                this.kindConfig = new HashMap<Kind, Map<String, String>>();
            }
            this.kindConfig.computeIfAbsent(kind, k -> new HashMap()).put(key, value);
            return this;
        }

        public RegistryAuthConfigBuilder addHandlerConfig(String id, String key, String value) {
            if (this.handlerConfig == null) {
                this.handlerConfig = new HashMap<String, Map<String, String>>();
            }
            if (value != null) {
                this.handlerConfig.computeIfAbsent(id, i -> new HashMap()).put(key, value);
            }
            return this;
        }

        RegistryAuthConfigBuilder() {
        }

        public RegistryAuthConfigBuilder handlerConfig(Map<String, Map<String, String>> handlerConfig) {
            this.handlerConfig = handlerConfig;
            return this;
        }

        public RegistryAuthConfigBuilder kindConfig(Map<Kind, Map<String, String>> kindConfig) {
            this.kindConfig = kindConfig;
            return this;
        }

        public RegistryAuthConfigBuilder putDefaultConfig(String putDefaultConfigKey, String putDefaultConfigValue) {
            if (this.defaultConfig$key == null) {
                this.defaultConfig$key = new ArrayList();
                this.defaultConfig$value = new ArrayList();
            }
            this.defaultConfig$key.add(putDefaultConfigKey);
            this.defaultConfig$value.add(putDefaultConfigValue);
            return this;
        }

        public RegistryAuthConfigBuilder defaultConfig(Map<? extends String, ? extends String> defaultConfig) {
            if (defaultConfig == null) {
                throw new NullPointerException("defaultConfig cannot be null");
            }
            if (this.defaultConfig$key == null) {
                this.defaultConfig$key = new ArrayList();
                this.defaultConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : defaultConfig.entrySet()) {
                this.defaultConfig$key.add($lombokEntry.getKey());
                this.defaultConfig$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RegistryAuthConfigBuilder clearDefaultConfig() {
            if (this.defaultConfig$key != null) {
                this.defaultConfig$key.clear();
                this.defaultConfig$value.clear();
            }
            return this;
        }

        public RegistryAuthConfigBuilder skipExtendedAuthentication(boolean skipExtendedAuthentication) {
            this.skipExtendedAuthentication = skipExtendedAuthentication;
            return this;
        }

        public RegistryAuthConfigBuilder propertyPrefix(String propertyPrefix) {
            this.propertyPrefix = propertyPrefix;
            return this;
        }

        public RegistryAuthConfig build() {
            Map<String, String> defaultConfig;
            switch (this.defaultConfig$key == null ? 0 : this.defaultConfig$key.size()) {
                case 0: {
                    defaultConfig = Collections.emptyMap();
                    break;
                }
                case 1: {
                    defaultConfig = Collections.singletonMap(this.defaultConfig$key.get(0), this.defaultConfig$value.get(0));
                    break;
                }
                default: {
                    defaultConfig = new LinkedHashMap(this.defaultConfig$key.size() < 0x40000000 ? 1 + this.defaultConfig$key.size() + (this.defaultConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.defaultConfig$key.size(); ++$i) {
                        defaultConfig.put(this.defaultConfig$key.get($i), this.defaultConfig$value.get($i));
                    }
                    defaultConfig = Collections.unmodifiableMap(defaultConfig);
                }
            }
            return new RegistryAuthConfig(this.handlerConfig, this.kindConfig, defaultConfig, this.skipExtendedAuthentication, this.propertyPrefix);
        }

        public String toString() {
            return "RegistryAuthConfig.RegistryAuthConfigBuilder(handlerConfig=" + this.handlerConfig + ", kindConfig=" + this.kindConfig + ", defaultConfig$key=" + this.defaultConfig$key + ", defaultConfig$value=" + this.defaultConfig$value + ", skipExtendedAuthentication=" + this.skipExtendedAuthentication + ", propertyPrefix=" + this.propertyPrefix + ")";
        }
    }

    public static enum Kind {
        PUSH,
        PULL;

    }
}

