/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.assembly;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.assembly.ArchiverCustomizer;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyConfigurationSource;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyConfigurationUtils;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyFiles;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.build.api.assembly.JKubeBuildTarArchiver;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFile;
import org.eclipse.jkube.kit.common.AssemblyFileEntry;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.AssemblyMode;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.archive.AssemblyFileSetUtils;
import org.eclipse.jkube.kit.common.archive.AssemblyFileUtils;
import org.eclipse.jkube.kit.common.archive.JKubeTarArchiver;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.DockerFileBuilder;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;

public class AssemblyManager {
    private static AssemblyManager dockerAssemblyManager = null;
    public static final String DEFAULT_DATA_BASE_IMAGE = "busybox:latest";
    public static final String SCRATCH_IMAGE = "scratch";
    private static final String DOCKER_IGNORE = ".jkube-dockerignore";
    private static final String DOCKER_EXCLUDE = ".jkube-dockerexclude";
    private static final String DOCKER_INCLUDE = ".jkube-dockerinclude";
    private static final String DOCKERFILE_NAME = "Dockerfile";

    private AssemblyManager() {
    }

    public static AssemblyManager getInstance() {
        if (dockerAssemblyManager == null) {
            dockerAssemblyManager = new AssemblyManager();
        }
        return dockerAssemblyManager;
    }

    public File createDockerTarArchive(String imageName, JKubeConfiguration configuration, BuildConfiguration buildConfig, KitLogger log, ArchiverCustomizer finalCustomizer) throws IOException {
        BuildDirs buildDirs = AssemblyManager.createBuildDirs(imageName, configuration);
        ArrayList<ArchiverCustomizer> archiveCustomizers = new ArrayList<ArchiverCustomizer>();
        AssemblyConfiguration assemblyConfig = AssemblyManager.getAssemblyConfiguration(buildConfig, configuration);
        List<AssemblyFileEntry> assemblyFileEntries = this.copyFilesToFinalTarballDirectory(configuration.getProject(), buildDirs, assemblyConfig);
        try {
            if (buildConfig.isDockerFileMode()) {
                this.createDockerTarArchiveForDockerFile(buildConfig, assemblyConfig, configuration, buildDirs, log, archiveCustomizers);
            } else {
                this.createAssemblyArchive(assemblyConfig, configuration, buildDirs, buildConfig.getCompression(), assemblyFileEntries);
                this.createDockerTarArchiveForGeneratorMode(buildConfig, buildDirs, archiveCustomizers, assemblyConfig);
            }
            archiveCustomizers.addAll(AssemblyManager.getDefaultCustomizers(configuration, assemblyConfig, finalCustomizer, assemblyFileEntries));
            return this.createBuildTarBall(configuration, buildDirs, archiveCustomizers, assemblyConfig, buildConfig.getCompression());
        }
        catch (IOException e) {
            throw new IOException(String.format("Cannot create %s in %s", DOCKERFILE_NAME, buildDirs.getOutputDirectory()), e);
        }
    }

    @Nonnull
    public static AssemblyConfiguration getAssemblyConfiguration(@Nonnull BuildConfiguration buildConfiguration, @Nonnull JKubeConfiguration configuration) throws IOException {
        if (buildConfiguration.isDockerFileMode()) {
            return AssemblyManager.getAssemblyConfigurationForDockerfileMode(buildConfiguration, configuration);
        }
        return AssemblyConfigurationUtils.getAssemblyConfigurationOrCreateDefault(buildConfiguration);
    }

    private void interpolateDockerfile(File dockerFile, BuildDirs params, Properties properties, String filter) throws IOException {
        File targetDockerfile = new File(params.getOutputDirectory(), dockerFile.getName());
        String dockerFileInterpolated = DockerFileUtil.interpolate(dockerFile, properties, filter);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetDockerfile));){
            writer.write(dockerFileInterpolated);
        }
    }

    void verifyGivenDockerfile(File dockerFile, BuildConfiguration buildConfig, Properties properties, KitLogger log) throws IOException {
        AssemblyConfiguration assemblyConfig = buildConfig.getAssembly();
        if (assemblyConfig == null) {
            return;
        }
        String name = assemblyConfig.getName();
        for (String keyword : new String[]{"ADD", "COPY"}) {
            List<String[]> lines = DockerFileUtil.extractLines(dockerFile, keyword, properties, buildConfig.getFilter());
            for (String[] line : lines) {
                String component;
                int i;
                if (line[0].startsWith("#")) continue;
                for (i = 1; i < line.length && (component = line[i]).startsWith("--"); ++i) {
                }
                if (i >= line.length || !line[i].contains(name)) continue;
                return;
            }
        }
        log.warn("Dockerfile %s does not contain an ADD or COPY directive to include assembly created at %s. Ignoring assembly.", new Object[]{dockerFile.getPath(), name});
    }

    public AssemblyFiles getAssemblyFiles(ImageConfiguration imageConfiguration, JKubeConfiguration jKubeConfiguration) throws IOException {
        BuildDirs buildDirs = AssemblyManager.createBuildDirs(imageConfiguration.getName(), jKubeConfiguration);
        AssemblyConfiguration assemblyConfig = imageConfiguration.getBuildConfiguration().getAssembly();
        AssemblyFiles assemblyFiles = new AssemblyFiles(buildDirs.getOutputDirectory());
        this.copyFilesToFinalTarballDirectory(jKubeConfiguration.getProject(), buildDirs, assemblyConfig).forEach(assemblyFiles::addEntry);
        return assemblyFiles;
    }

    public File createChangedFilesArchive(List<AssemblyFileEntry> entries, File assemblyDirectory, String imageName, JKubeConfiguration jKubeConfiguration) throws IOException {
        BuildDirs dirs = AssemblyManager.createBuildDirs(imageName, jKubeConfiguration);
        try {
            File archive = new File(dirs.getTemporaryRootDirectory(), "changed-files.tar");
            File archiveDir = this.createArchiveDir(dirs);
            for (AssemblyFileEntry entry : entries) {
                File dest = this.prepareChangedFilesArchivePath(archiveDir, entry.getDest(), assemblyDirectory);
                Files.createDirectories(dest.getParentFile().toPath(), new FileAttribute[0]);
                Files.copy(Paths.get(entry.getSource().getAbsolutePath(), new String[0]), Paths.get(dest.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            return JKubeTarArchiver.createTarBallOfDirectory((File)archive, (File)archiveDir, (ArchiveCompression)ArchiveCompression.none);
        }
        catch (IOException exp) {
            throw new IOException("Error while creating " + dirs.getTemporaryRootDirectory() + "/changed-files.tar: " + exp);
        }
    }

    private File prepareChangedFilesArchivePath(File archiveDir, File destFile, File assemblyDir) throws IOException {
        String relativePath = FileUtil.getRelativeFilePath((String)assemblyDir.getCanonicalPath(), (String)destFile.getCanonicalPath());
        return new File(archiveDir, relativePath);
    }

    private File createBuildTarBall(JKubeConfiguration params, BuildDirs buildDirs, List<ArchiverCustomizer> archiverCustomizers, AssemblyConfiguration assemblyConfig, ArchiveCompression compression) throws IOException {
        AssemblyConfigurationSource source = new AssemblyConfigurationSource(params, buildDirs, assemblyConfig);
        JKubeBuildTarArchiver jkubeTarArchiver = new JKubeBuildTarArchiver();
        for (ArchiverCustomizer customizer : archiverCustomizers) {
            if (customizer == null) continue;
            jkubeTarArchiver = customizer.customize(jkubeTarArchiver);
        }
        return jkubeTarArchiver.createArchive(source.getOutputDirectory(), buildDirs, compression);
    }

    private File createArchiveDir(BuildDirs dirs) throws IOException {
        File archiveDir = new File(dirs.getTemporaryRootDirectory(), "changed-files");
        if (archiveDir.exists()) {
            FileUtil.cleanDirectory((File)archiveDir);
        } else if (!archiveDir.mkdir()) {
            throw new IOException("Cannot create " + archiveDir);
        }
        return archiveDir;
    }

    DockerFileBuilder createDockerFileBuilder(BuildConfiguration buildConfig, AssemblyConfiguration assemblyConfig) {
        DockerFileBuilder builder = new DockerFileBuilder().env(buildConfig.getEnv()).labels(buildConfig.getLabels()).expose(buildConfig.getPorts()).run(buildConfig.getRunCmds()).volumes(buildConfig.getVolumes()).user(buildConfig.getUser());
        if (buildConfig.getMaintainer() != null) {
            builder.maintainer(buildConfig.getMaintainer());
        }
        if (buildConfig.getWorkdir() != null) {
            builder.workdir(buildConfig.getWorkdir());
        }
        if (assemblyConfig != null) {
            builder.add(assemblyConfig.getTargetDir(), "").basedir(assemblyConfig.getTargetDir()).assemblyUser(assemblyConfig.getUser()).exportTargetDir(assemblyConfig.getExportTargetDir());
        } else {
            builder.exportTargetDir(Boolean.valueOf(false));
        }
        builder.baseImage(buildConfig.getFrom());
        if (buildConfig.getHealthCheck() != null) {
            builder.healthCheck(buildConfig.getHealthCheck());
        }
        if (buildConfig.getCmd() != null) {
            builder.cmd(buildConfig.getCmd());
        }
        if (buildConfig.getEntryPoint() != null) {
            builder.entryPoint(buildConfig.getEntryPoint());
        }
        if (buildConfig.optimise()) {
            builder.optimise();
        }
        return builder;
    }

    private void createAssemblyArchive(AssemblyConfiguration assemblyConfig, JKubeConfiguration params, BuildDirs buildDirs, ArchiveCompression compression, List<AssemblyFileEntry> assemblyFileEntries) throws IOException {
        if (!AssemblyManager.hasAssemblyConfiguration(assemblyConfig)) {
            return;
        }
        AssemblyConfigurationSource source = new AssemblyConfigurationSource(params, buildDirs, assemblyConfig);
        JKubeBuildTarArchiver jkubeTarArchiver = new JKubeBuildTarArchiver();
        AssemblyMode buildMode = assemblyConfig.getMode();
        try {
            assemblyFileEntries.stream().filter(afe -> StringUtils.isNotBlank((CharSequence)afe.getFileMode())).forEach(jkubeTarArchiver::setFileMode);
            jkubeTarArchiver.createArchive(source.getOutputDirectory(), buildDirs, compression);
        }
        catch (IOException e) {
            String error = "Failed to create assembly for docker image  (with mode '" + buildMode + "'): " + e.getMessage() + ".";
            if (params.getProject().getArtifact() == null) {
                error = error + " If you include the build artifact please ensure that you have built the artifact before with 'mvn package' (should be available in the target/ dir). Please see the documentation (section \"Assembly\") for more information.";
            }
            throw new IOException(error, e);
        }
    }

    File ensureThatArtifactFileIsSet(JavaProject project) throws IOException {
        File oldFile = project.getArtifact();
        if (oldFile != null) {
            return oldFile;
        }
        File artifactFile = JKubeProjectUtil.getFinalOutputArtifact((JavaProject)project);
        if (artifactFile != null && artifactFile.exists() && artifactFile.isFile()) {
            this.setArtifactFile(project, artifactFile);
            return artifactFile;
        }
        return null;
    }

    private void setArtifactFile(JavaProject project, File artifactFile) throws IOException {
        if (artifactFile != null) {
            File artifact = new File(project.getBuildDirectory(), artifactFile.getName());
            Files.copy(Paths.get(artifactFile.getAbsolutePath(), new String[0]), Paths.get(artifact.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public List<AssemblyFileEntry> copyFilesToFinalTarballDirectory(JavaProject project, BuildDirs buildDirs, AssemblyConfiguration assemblyConfiguration) throws IOException {
        ArrayList<AssemblyFileEntry> files = new ArrayList<AssemblyFileEntry>();
        FileUtil.createDirectory((File)new File(buildDirs.getOutputDirectory(), assemblyConfiguration.getTargetDir()));
        for (AssemblyFileSet fileSet : AssemblyConfigurationUtils.getJKubeAssemblyFileSets(assemblyConfiguration)) {
            files.addAll(AssemblyFileSetUtils.processAssemblyFileSet((File)project.getBaseDirectory(), (File)buildDirs.getOutputDirectory(), (AssemblyFileSet)fileSet, (AssemblyConfiguration)assemblyConfiguration));
        }
        for (AssemblyFile file : AssemblyConfigurationUtils.getJKubeAssemblyFiles(assemblyConfiguration)) {
            files.add(this.processJKubeProjectAssemblyFile(project, file, buildDirs, assemblyConfiguration));
        }
        return files;
    }

    private AssemblyFileEntry processJKubeProjectAssemblyFile(JavaProject project, AssemblyFile assemblyFile, BuildDirs buildDirs, AssemblyConfiguration assemblyConfiguration) throws IOException {
        File sourceFile = AssemblyFileUtils.resolveSourceFile((File)project.getBaseDirectory(), (AssemblyFile)assemblyFile);
        File outputDirectory = AssemblyFileUtils.getAssemblyFileOutputDirectory((AssemblyFile)assemblyFile, (File)buildDirs.getOutputDirectory(), (AssemblyConfiguration)assemblyConfiguration);
        FileUtil.createDirectory((File)outputDirectory);
        String destinationFilename = Optional.ofNullable(assemblyFile.getDestName()).orElse(sourceFile.getName());
        File destinationFile = new File(outputDirectory, destinationFilename);
        FileUtil.copy((File)sourceFile, (File)destinationFile);
        return new AssemblyFileEntry(sourceFile, destinationFile, assemblyFile.getFileMode());
    }

    private static BuildDirs createBuildDirs(String imageName, JKubeConfiguration params) {
        BuildDirs buildDirs = new BuildDirs(imageName, params);
        buildDirs.createDirs();
        return buildDirs;
    }

    private static boolean hasAssemblyConfiguration(AssemblyConfiguration assemblyConfig) {
        return assemblyConfig != null && assemblyConfig.getInline() != null;
    }

    private static boolean isArchive(AssemblyConfiguration assemblyConfig) {
        return AssemblyManager.hasAssemblyConfiguration(assemblyConfig) && assemblyConfig.getMode() != null && assemblyConfig.getMode().isArchive();
    }

    private void createDockerTarArchiveForDockerFile(BuildConfiguration buildConfig, AssemblyConfiguration assemblyConfig, JKubeConfiguration params, BuildDirs buildDirs, KitLogger log, List<ArchiverCustomizer> archiveCustomizers) throws IOException {
        File dockerFile = buildConfig.getAbsoluteDockerFilePath(params.getSourceDirectory(), params.getProject().getBaseDirectory().toString());
        if (!dockerFile.exists()) {
            throw new IOException("Configured Dockerfile \"" + buildConfig.getDockerFile() + "\" (resolved to \"" + dockerFile + "\") doesn't exist");
        }
        this.verifyGivenDockerfile(dockerFile, buildConfig, params.getProperties(), log);
        this.interpolateDockerfile(dockerFile, buildDirs, params.getProperties(), buildConfig.getFilter());
        archiveCustomizers.add(archiver -> {
            if (AssemblyManager.isArchive(assemblyConfig)) {
                String name = dockerFile.getName();
                archiver.includeFile(new File(buildDirs.getOutputDirectory(), name), name);
            }
            return archiver;
        });
    }

    private void createDockerTarArchiveForGeneratorMode(BuildConfiguration buildConfig, BuildDirs buildDirs, List<ArchiverCustomizer> archiveCustomizers, AssemblyConfiguration assemblyConfig) throws IOException {
        DockerFileBuilder builder = this.createDockerFileBuilder(buildConfig, assemblyConfig);
        builder.write(buildDirs.getOutputDirectory());
        File dockerFile = new File(buildDirs.getOutputDirectory(), DOCKERFILE_NAME);
        archiveCustomizers.add(archiver -> {
            archiver.includeFile(dockerFile, DOCKERFILE_NAME);
            return archiver;
        });
    }

    @Nonnull
    private static List<ArchiverCustomizer> getDefaultCustomizers(JKubeConfiguration configuration, AssemblyConfiguration assemblyConfiguration, ArchiverCustomizer finalCustomizer, List<AssemblyFileEntry> fileEntries) {
        ArrayList<ArchiverCustomizer> archiverCustomizers = new ArrayList<ArchiverCustomizer>();
        if (!assemblyConfiguration.isExcludeFinalOutputArtifact()) {
            archiverCustomizers.add(AssemblyManager.finalOutputArtifactCustomizer(configuration, assemblyConfiguration));
        }
        if (finalCustomizer != null) {
            archiverCustomizers.add(finalCustomizer);
        }
        archiverCustomizers.add(AssemblyManager.fileModeCustomizer(fileEntries));
        return archiverCustomizers;
    }

    @Nonnull
    private static AssemblyConfiguration getAssemblyConfigurationForDockerfileMode(BuildConfiguration buildConfiguration, JKubeConfiguration params) throws IOException {
        AssemblyConfiguration assemblyConfig = AssemblyConfigurationUtils.getAssemblyConfigurationOrCreateDefault(buildConfiguration);
        AssemblyConfiguration.AssemblyConfigurationBuilder builder = assemblyConfig.toBuilder();
        Assembly.AssemblyBuilder inlineBuilder = assemblyConfig.getInline() == null ? Assembly.builder() : assemblyConfig.getInline().toBuilder();
        File contextDir = buildConfiguration.getAbsoluteContextDirPath(params.getSourceDirectory(), params.getBasedir().getAbsolutePath());
        AssemblyFileSet assemblyFileSet = AssemblyFileSet.builder().directory(contextDir).outputDirectory(new File(".")).directoryMode("0775").excludes(AssemblyManager.createDockerExcludesList(contextDir, params.getOutputDirectory())).includes(AssemblyManager.createDockerIncludesList(contextDir)).build();
        builder.inline(inlineBuilder.fileSet(assemblyFileSet).build());
        return builder.build();
    }

    @Nonnull
    private static ArchiverCustomizer finalOutputArtifactCustomizer(@Nonnull JKubeConfiguration configuration, @Nonnull AssemblyConfiguration assemblyConfiguration) {
        return a -> {
            File finalArtifactFile = JKubeProjectUtil.getFinalOutputArtifact((JavaProject)configuration.getProject());
            if (finalArtifactFile != null) {
                a.includeFile(finalArtifactFile, assemblyConfiguration.getTargetDir() + File.separator + finalArtifactFile.getName());
            }
            return a;
        };
    }

    @Nonnull
    private static ArchiverCustomizer fileModeCustomizer(@Nonnull List<AssemblyFileEntry> fileEntries) {
        return a -> {
            fileEntries.stream().filter(afe -> StringUtils.isNotBlank((CharSequence)afe.getFileMode())).forEach(a::setFileMode);
            return a;
        };
    }

    private static List<String> createDockerExcludesList(File directory, String outputDirectory) throws IOException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add(String.format("%s{/**,}", outputDirectory));
        for (String dockerConfigFile : new String[]{DOCKER_EXCLUDE, DOCKER_IGNORE}) {
            File dockerIgnore = new File(directory, dockerConfigFile);
            if (!dockerIgnore.exists()) continue;
            excludes.addAll(Files.readAllLines(dockerIgnore.toPath()));
            excludes.add(dockerConfigFile);
        }
        return excludes;
    }

    private static List<String> createDockerIncludesList(File directory) throws IOException {
        File dockerInclude = new File(directory, DOCKER_INCLUDE);
        ArrayList<String> includes = new ArrayList<String>();
        if (dockerInclude.exists()) {
            includes.addAll(Files.readAllLines(dockerInclude.toPath()));
        }
        return includes;
    }
}

