/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.assembly;

import java.io.File;
import java.util.List;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;

public class AssemblyConfigurationSource {
    private final AssemblyConfiguration assemblyConfig;
    private final JKubeConfiguration context;
    private final BuildDirs buildDirs;

    public AssemblyConfigurationSource(JKubeConfiguration context, BuildDirs buildDirs, AssemblyConfiguration assemblyConfig) {
        this.context = context;
        this.assemblyConfig = assemblyConfig;
        this.buildDirs = buildDirs;
    }

    public File getOutputDirectory() {
        return this.buildDirs.getOutputDirectory();
    }

    public File getWorkingDirectory() {
        return this.buildDirs.getWorkingDirectory();
    }

    public File getTemporaryRootDirectory() {
        return this.buildDirs.getTemporaryRootDirectory();
    }

    public List<JavaProject> getReactorProjects() {
        return this.context.getReactorProjects();
    }

    public String getEncoding() {
        return this.context.getProject().getProperties().getProperty("project.build.sourceEncoding");
    }

    public JavaProject getProject() {
        return this.context.getProject();
    }

    public File getBasedir() {
        return this.context.getProject().getBaseDirectory();
    }

    public boolean isIgnorePermissions() {
        return this.assemblyConfig != null && this.assemblyConfig.getPermissions() != null && this.assemblyConfig.getPermissions() == AssemblyConfiguration.PermissionMode.ignore;
    }
}

