/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jkube.kit.common.util.Serialization;

public class RegistryAuth {
    public static final RegistryAuth EMPTY_REGISTRY_AUTH = RegistryAuth.builder().username("").password("").email("").auth("").build();
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String EMAIL = "email";
    public static final String AUTH = "authToken";
    private final String username;
    private final String password;
    private final String email;
    private final String auth;
    private final String authEncoded;

    public RegistryAuth(String username, String password, String email, String auth) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.auth = auth;
        this.authEncoded = this.createAuthEncoded();
    }

    public String toHeaderValue() {
        return this.authEncoded;
    }

    public static RegistryAuth fromCredentialsEncoded(String credentialsEncoded, String email) {
        String credentials = new String(Base64.decodeBase64((String)credentialsEncoded));
        String[] parsedCredentials = credentials.split(":", 2);
        return RegistryAuth.builder().username(parsedCredentials[0]).password(parsedCredentials[1]).email(email).build();
    }

    private String createAuthEncoded() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        this.putNonNull(ret, USERNAME, this.username);
        this.putNonNull(ret, PASSWORD, this.password);
        this.putNonNull(ret, EMAIL, this.email);
        this.putNonNull(ret, AUTH, this.auth);
        try {
            byte[] bytes = Serialization.jsonWriter().without(SerializationFeature.INDENT_OUTPUT).writeValueAsBytes(ret);
            return this.encodeBase64ChunkedURLSafeString(bytes);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot encode auth config", e);
        }
    }

    private String encodeBase64ChunkedURLSafeString(byte[] binaryData) {
        return java.util.Base64.getEncoder().encodeToString(binaryData).replace('+', '-').replace('/', '_');
    }

    private void putNonNull(Map<String, String> ret, String key, String value) {
        if (value != null) {
            ret.put(key, value);
        }
    }

    public static RegistryAuthBuilder builder() {
        return new RegistryAuthBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAuth() {
        return this.auth;
    }

    public String getAuthEncoded() {
        return this.authEncoded;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryAuth)) {
            return false;
        }
        RegistryAuth other = (RegistryAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$authEncoded = this.getAuthEncoded();
        String other$authEncoded = other.getAuthEncoded();
        return !(this$authEncoded == null ? other$authEncoded != null : !this$authEncoded.equals(other$authEncoded));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryAuth;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $authEncoded = this.getAuthEncoded();
        result = result * 59 + ($authEncoded == null ? 43 : $authEncoded.hashCode());
        return result;
    }

    public static class RegistryAuthBuilder {
        private String username;
        private String password;
        private String email;
        private String auth;

        RegistryAuthBuilder() {
        }

        public RegistryAuthBuilder username(String username) {
            this.username = username;
            return this;
        }

        public RegistryAuthBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RegistryAuthBuilder email(String email) {
            this.email = email;
            return this;
        }

        public RegistryAuthBuilder auth(String auth) {
            this.auth = auth;
            return this;
        }

        public RegistryAuth build() {
            return new RegistryAuth(this.username, this.password, this.email, this.auth);
        }

        public String toString() {
            return "RegistryAuth.RegistryAuthBuilder(username=" + this.username + ", password=" + this.password + ", email=" + this.email + ", auth=" + this.auth + ")";
        }
    }
}

