/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth.handler;

import java.util.Optional;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthHandler;
import org.eclipse.jkube.kit.build.api.helper.KubernetesConfigAuthUtil;
import org.eclipse.jkube.kit.common.KitLogger;

public class OpenShiftRegistryAuthHandler
implements RegistryAuthHandler {
    public static final String AUTH_USE_OPENSHIFT_AUTH = "useOpenShiftAuth";
    private final RegistryAuthConfig registryAuthConfig;
    private final KitLogger log;

    public OpenShiftRegistryAuthHandler(RegistryAuthConfig registryAuthConfig, KitLogger log) {
        this.registryAuthConfig = registryAuthConfig;
        this.log = log;
    }

    @Override
    public String getId() {
        return "openshift";
    }

    @Override
    public AuthConfig create(RegistryAuthConfig.Kind kind, String user, String registry, UnaryOperator<String> decryptor) {
        Properties props = System.getProperties();
        String useOpenAuthMode = this.registryAuthConfig.extractFromProperties(props, kind, AUTH_USE_OPENSHIFT_AUTH);
        if (useOpenAuthMode != null) {
            boolean useOpenShift = Boolean.parseBoolean(useOpenAuthMode);
            if (!useOpenShift) {
                return null;
            }
            this.log.debug("AuthConfig: OpenShift credentials", new Object[0]);
            return this.validateMandatoryOpenShiftLogin(KubernetesConfigAuthUtil.readKubeConfigAuth());
        }
        boolean useOpenShiftAuth = Optional.ofNullable(this.registryAuthConfig.getConfigForHandler(this.getId(), AUTH_USE_OPENSHIFT_AUTH)).map(Boolean::parseBoolean).orElse(false);
        if (useOpenShiftAuth) {
            this.log.debug("AuthConfig: OpenShift credentials", new Object[0]);
            return this.validateMandatoryOpenShiftLogin(KubernetesConfigAuthUtil.readKubeConfigAuth());
        }
        return null;
    }

    private AuthConfig validateMandatoryOpenShiftLogin(AuthConfig openShiftRegistryAuth) {
        if (openShiftRegistryAuth != null) {
            return openShiftRegistryAuth;
        }
        String kubeConfigEnv = System.getenv("KUBECONFIG");
        throw new IllegalArgumentException(String.format("OpenShift auth check enabled, but not active user and/or token found in %s. Please use 'oc login' for connecting to OpenShift.", kubeConfigEnv != null ? kubeConfigEnv : "~/.kube/config"));
    }
}

