/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.assembly;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.common.AssemblyFileEntry;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.archive.JKubeTarArchiver;
import org.eclipse.jkube.kit.common.util.FileUtil;

public class JKubeBuildTarArchiver {
    public static final String ARCHIVE_FILE_NAME = "docker-build.";
    private final Map<File, String> filesToIncludeNameMap = new HashMap<File, String>();
    private final Map<File, String> fileModeMap = new HashMap<File, String>();
    private final List<String> filesNamesToExclude = new ArrayList<String>();

    public void includeFile(File inputFile, String destinationFileName) {
        this.filesToIncludeNameMap.put(inputFile, destinationFileName);
    }

    public void setFileMode(AssemblyFileEntry assemblyFileEntry) {
        this.fileModeMap.put(assemblyFileEntry.getDest(), assemblyFileEntry.getFileMode());
    }

    public void excludeFile(String inputFilePath) {
        this.filesNamesToExclude.add(inputFilePath);
    }

    public File createArchive(File inputDirectory, BuildDirs buildDirs, ArchiveCompression compression) throws IOException {
        File outputFile = new File(buildDirs.getTemporaryRootDirectory(), ARCHIVE_FILE_NAME + (compression.equals((Object)ArchiveCompression.none) ? "tar" : compression.getFileSuffix()));
        List files = FileUtil.listFilesAndDirsRecursivelyInDirectory((File)inputDirectory);
        if (!this.filesToIncludeNameMap.isEmpty()) {
            for (Map.Entry<File, String> entry : this.filesToIncludeNameMap.entrySet()) {
                File targetFile;
                File srcFile = entry.getKey();
                String targetFileName = entry.getValue();
                File parentDirectory = new File(targetFileName).getParentFile();
                if (parentDirectory != null) {
                    FileUtil.createDirectory((File)new File(inputDirectory, parentDirectory.getPath()));
                }
                if (srcFile.equals(targetFile = new File(inputDirectory, targetFileName))) continue;
                FileUtil.copy((File)srcFile, (File)targetFile);
                files.add(targetFile);
            }
        }
        ArrayList<File> fileListToAddInTarball = new ArrayList<File>();
        for (File currentFile : files) {
            if (this.filesNamesToExclude.contains(currentFile.getName())) continue;
            fileListToAddInTarball.add(currentFile);
        }
        return JKubeTarArchiver.createTarBall((File)outputFile, (File)inputDirectory, fileListToAddInTarball, this.fileModeMap, (ArchiveCompression)compression);
    }
}

