/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public abstract class AbstractVersionMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}")
    protected File basedir;
    @Parameter(property="version.text.file", defaultValue="${project.basedir}/VERSION.txt")
    protected File versionTextInputFile;
    @Parameter(property="version.text.output.classifier", defaultValue="version")
    protected String classifier = "version";
    @Parameter(property="version.text.output.type", defaultValue="txt")
    protected String type = "txt";
    @Parameter(property="version.text.filename.excludes")
    protected String[] filenameExcludes;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="version.github.repoName", defaultValue="eclipse/jetty.project")
    protected String repoName;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(required=true, property="version.text.key", defaultValue="jetty-VERSION")
    protected String versionTextKey;
    @Parameter(required=true, property="version.tag.key", defaultValue="jetty-VERSION")
    protected String versionTagKey;

    protected void ensureDirectoryExists(File dir) throws MojoFailureException {
        if (Files.exists(dir.toPath(), new LinkOption[0]) && Files.isDirectory(dir.toPath(), new LinkOption[0])) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new MojoFailureException("Unable to create directory: " + dir.getAbsolutePath());
        }
    }

    protected boolean hasVersionTextFile(String goal) {
        if (this.versionTextInputFile == null) {
            this.getLog().debug((CharSequence)("Skipping :" + goal + " - the <versionTextInputFile> was not specified."));
            return false;
        }
        if (!this.versionTextInputFile.exists()) {
            this.getLog().debug((CharSequence)("Skipping :" + goal + " - file not found: " + this.versionTextInputFile.getAbsolutePath()));
            return false;
        }
        return true;
    }

    protected boolean hasCredentialsFile(String goal) {
        Path homeDir = Paths.get(System.getProperty("user.home"), new String[0]);
        Path propertyFile = homeDir.resolve(".github");
        if (!Files.exists(propertyFile, new LinkOption[0])) {
            this.getLog().warn((CharSequence)("Skipping :" + goal + " - the ${user.home}/.github (property) file not found."));
            this.getLog().warn((CharSequence)"See https://github-api.kohsuke.org/ for details on how to configure this Property File.");
            return false;
        }
        return true;
    }
}

