/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jetty.toolchain.test.PathMatchers;
import org.hamcrest.MatcherAssert;

public final class IO {
    public static final int BUFFER_SIZE = 65536;

    private IO() {
    }

    public static void copy(Reader in, Writer out) throws IOException {
        char[] buffer = new char[65536];
        int len = 65536;
        while ((len = in.read(buffer, 0, 65536)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[65536];
        int len = 65536;
        while ((len = in.read(buffer, 0, 65536)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(Path src, Path dest) throws IOException {
        MatcherAssert.assertThat((Object)src, PathMatchers.exists());
        if (Files.isDirectory(src, new LinkOption[0])) {
            if (!Files.exists(dest, new LinkOption[0])) {
                Files.createDirectory(dest, new FileAttribute[0]);
            }
            IO.copyDir(src, dest);
        } else {
            IO.copyFile(src, dest);
        }
    }

    public static void copyDir(Path srcDir, Path destDir) throws IOException {
        Objects.requireNonNull(srcDir);
        Objects.requireNonNull(destDir);
        MatcherAssert.assertThat((String)"Source Dir", (Object)srcDir, PathMatchers.isDirectory());
        MatcherAssert.assertThat((String)"Destination Dir", (Object)destDir, PathMatchers.isDirectory());
        MatcherAssert.assertThat((String)"Destination Dir", (Object)destDir, PathMatchers.isEmptyDirectory());
        try (Stream<Path> sourceStream = Files.walk(srcDir, 20, new FileVisitOption[0]);){
            Iterator iterFiles = sourceStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).iterator();
            while (iterFiles.hasNext()) {
                Path sourceFile = (Path)iterFiles.next();
                Path destFile = destDir.resolve(srcDir.relativize(sourceFile));
                if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                }
                Files.copy(sourceFile, destFile, new CopyOption[0]);
            }
        }
    }

    public static void copyFile(Path srcFile, Path destFile) throws IOException {
        MatcherAssert.assertThat((String)"Source File", (Object)srcFile, PathMatchers.isRegularFile());
        Files.copy(srcFile, destFile, new CopyOption[0]);
    }

    @Deprecated(forRemoval=true, since="6.0")
    public static String readToString(Path path) throws IOException {
        return Files.readString(path, StandardCharsets.UTF_8);
    }

    @Deprecated(forRemoval=true, since="6.0")
    public static String readToString(File file) throws IOException {
        return Files.readString(file.toPath(), StandardCharsets.UTF_8);
    }

    @Deprecated(forRemoval=true, since="6.0")
    public static void copy(File src, File dest) throws IOException {
        Objects.requireNonNull(src, "Source Path");
        Objects.requireNonNull(dest, "Destination Path");
        IO.copy(src.toPath(), dest.toPath());
    }

    @Deprecated(forRemoval=true, since="6.0")
    public static void copyDir(File srcDir, File destDir) throws IOException {
        Objects.requireNonNull(srcDir, "Source Dir");
        Objects.requireNonNull(destDir, "Destination Dir");
        IO.copyDir(srcDir.toPath(), destDir.toPath());
    }

    @Deprecated
    public static void copyFile(File srcFile, File destFile) throws IOException {
        Objects.requireNonNull(srcFile, "Source File");
        Objects.requireNonNull(destFile, "Destination File");
        Files.copy(srcFile.toPath(), destFile.toPath(), new CopyOption[0]);
    }

    @Deprecated(forRemoval=true, since="6.0")
    public static class SafeFileFilter
    implements FileFilter {
        public static final SafeFileFilter INSTANCE = new SafeFileFilter();

        @Override
        public boolean accept(File path) {
            String name = path.getName();
            if (".".equals(name) || "..".equals(name)) {
                return false;
            }
            return path.isFile() || path.isDirectory();
        }
    }
}

