/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LibExtClassLoaderHelper {
    public static Set<IFilesInJettyHomeResourcesProcessor> registeredFilesInJettyHomeResourcesProcessors = new HashSet<IFilesInJettyHomeResourcesProcessor>();

    public static ClassLoader createLibEtcClassLoader(File jettyHome, ClassLoader parentClassLoader) throws MalformedURLException {
        File libExt;
        if (jettyHome == null) {
            return parentClassLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        File jettyResources = new File(jettyHome, "resources");
        if (jettyResources.exists()) {
            HashMap<String, File> jettyResFiles = new HashMap<String, File>();
            for (File f : jettyResources.listFiles()) {
                jettyResFiles.put(f.getName(), f);
                if (f.getName().toLowerCase(Locale.ENGLISH).startsWith("readme") || !urls.isEmpty()) continue;
                urls.add(jettyResources.toURI().toURL());
            }
            LibExtClassLoaderHelper.processFilesInResourcesFolder(jettyHome, jettyResFiles);
        }
        if ((libExt = new File(jettyHome, "lib/ext")).exists()) {
            for (File f : libExt.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                URL url = f.toURI().toURL();
                if (f.isFile()) {
                    url = new URL("jar:" + url.toString() + "!/");
                }
                urls.add(url);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parentClassLoader);
    }

    public static ClassLoader createLibExtClassLoader(List<File> jarsContainerOrJars, List<URL> otherJarsOrFolder, ClassLoader parentClassLoader) throws MalformedURLException {
        if (jarsContainerOrJars == null && otherJarsOrFolder == null) {
            return parentClassLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (otherJarsOrFolder != null) {
            urls.addAll(otherJarsOrFolder);
        }
        if (jarsContainerOrJars != null) {
            for (File libExt : jarsContainerOrJars) {
                if (!libExt.isDirectory()) continue;
                for (File f : libExt.listFiles()) {
                    if (!f.getName().endsWith(".jar")) continue;
                    URL url = f.toURI().toURL();
                    if (f.isFile()) {
                        url = new URL("jar:" + url.toString() + "!/");
                    }
                    urls.add(url);
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parentClassLoader);
    }

    protected static void processFilesInResourcesFolder(File jettyHome, Map<String, File> childrenFiles) {
        for (IFilesInJettyHomeResourcesProcessor processor : registeredFilesInJettyHomeResourcesProcessors) {
            processor.processFilesInResourcesFolder(jettyHome, childrenFiles);
        }
    }

    public static interface IFilesInJettyHomeResourcesProcessor {
        public void processFilesInResourcesFolder(File var1, Map<String, File> var2);
    }
}

