/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public class ArrayTernaryTrie<V>
implements Trie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private static final int ROW_SIZE = 4;
    private final char[] _tree;
    private final String[] _key;
    private final Object[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    public ArrayTernaryTrie(int capacityInNodes) {
        this._value = new Object[capacityInNodes];
        this._tree = new char[capacityInNodes * 4];
        this._key = new String[capacityInNodes];
    }

    @Override
    public boolean put(String s, V v) {
        int last = EQ;
        int t = this._tree[last];
        int limit = s.length();
        int node = 0;
        block0: for (int k = 0; k < limit; ++k) {
            char c = s.charAt(k);
            if (c < '\u0080') {
                c = StringUtil.lowercases[c & 0x7F];
            }
            while (true) {
                int row;
                if (t == 0) {
                    t = this._rows = (int)(this._rows + '\u0001');
                    node = this._rows;
                    if (this._rows >= this._key.length) {
                        this._rows = (char)(this._rows - '\u0001');
                        return false;
                    }
                    row = 4 * t;
                    this._tree[row] = c;
                    this._tree[last] = (char)t;
                    last = row + EQ;
                    t = 0;
                    continue block0;
                }
                row = 4 * t;
                char n = this._tree[row];
                int diff = n - c;
                if (diff == 0) {
                    node = t;
                    last = row + EQ;
                    t = this._tree[last];
                    continue block0;
                }
                if (diff < 0) {
                    last = row + LO;
                    t = this._tree[last];
                    continue;
                }
                last = row + HI;
                t = this._tree[last];
            }
        }
        this._key[node] = v == null ? null : s;
        this._value[node] = v;
        return true;
    }

    @Override
    public boolean put(V v) {
        return this.put(v.toString(), v);
    }

    @Override
    public V remove(String s) {
        V o = this.get(s);
        this.put(s, null);
        return o;
    }

    @Override
    public V get(String s) {
        int t = this._tree[EQ];
        int len = s.length();
        int node = 0;
        block0: for (int i = 0; t != 0 && i < len; ++i) {
            char c = StringUtil.lowercases[s.charAt(i) & 0x7F];
            while (t != 0) {
                int row = 4 * t;
                char n = this._tree[row];
                int diff = n - c;
                if (diff == 0) {
                    node = t;
                    t = this._tree[row + EQ];
                    continue block0;
                }
                if (diff < 0) {
                    t = this._tree[row + LO];
                    continue;
                }
                t = this._tree[row + HI];
            }
        }
        return (V)this._value[node];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        int t = this._tree[EQ];
        int node = 0;
        block0: for (int i = 0; t != 0 && i < len; ++i) {
            char c = StringUtil.lowercases[b.get(offset + i) & 0x7F];
            while (t != 0) {
                int row = 4 * t;
                char n = this._tree[row];
                int diff = n - c;
                if (diff == 0) {
                    node = t;
                    t = this._tree[row + EQ];
                    continue block0;
                }
                if (diff < 0) {
                    t = this._tree[row + LO];
                    continue;
                }
                t = this._tree[row + HI];
            }
        }
        return (V)this._value[node];
    }

    @Override
    public V getBest(byte[] b, int offset, int len) {
        return this.getBest((int)this._tree[EQ], b, offset, len);
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest((int)this._tree[EQ], b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest((int)this._tree[EQ], b, offset, len);
    }

    private V getBest(int t, byte[] b, int offset, int len) {
        int node = 0;
        block0: for (int i = 0; t != 0 && i < len; ++i) {
            char c = StringUtil.lowercases[b[offset + i] & 0x7F];
            while (t != 0) {
                int row = 4 * t;
                char n = this._tree[row];
                int diff = n - c;
                if (diff == 0) {
                    node = t;
                    t = this._tree[row + EQ];
                    if (this._key[node] == null) continue block0;
                    V best = this.getBest(t, b, offset + i + 1, len - i - 1);
                    if (best != null) {
                        return best;
                    }
                    return (V)this._value[node];
                }
                if (diff < 0) {
                    t = this._tree[row + LO];
                    continue;
                }
                t = this._tree[row + HI];
            }
        }
        return null;
    }

    private V getBest(int t, ByteBuffer b, int offset, int len) {
        int pos = b.position() + offset;
        int node = 0;
        block0: for (int i = 0; t != 0 && i < len; ++i) {
            char c = StringUtil.lowercases[b.get(pos++) & 0x7F];
            while (t != 0) {
                int row = 4 * t;
                char n = this._tree[row];
                int diff = n - c;
                if (diff == 0) {
                    node = t;
                    t = this._tree[row + EQ];
                    if (this._key[node] == null) continue block0;
                    V best = this.getBest(t, b, offset + i + 1, len - i - 1);
                    if (best != null) {
                        return best;
                    }
                    return (V)this._value[node];
                }
                if (diff < 0) {
                    t = this._tree[row + LO];
                    continue;
                }
                t = this._tree[row + HI];
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int r = 1; r <= this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            buf.append(',');
            buf.append(this._key[r]);
            buf.append('=');
            buf.append(this._value[r].toString());
        }
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (int r = 1; r <= this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            keys.add(this._key[r]);
        }
        return keys;
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' == this._key.length;
    }
}

