/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServletContextHandlerTest {
    private Server _server;
    private LocalConnector _connector;
    private static final AtomicInteger __testServlets = new AtomicInteger();

    @Before
    public void createServer() {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        __testServlets.set(0);
    }

    @After
    public void destroyServer() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testFindContainer() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        SessionHandler session = root.getSessionHandler();
        ServletHandler servlet = root.getServletHandler();
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        root.setSecurityHandler((SecurityHandler)security);
        this._server.start();
        Assert.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)session));
        Assert.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)security));
        Assert.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)servlet));
    }

    @Test
    public void testInitOrder() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder holder0 = context.addServlet(TestServlet.class, "/test0");
        ServletHolder holder1 = context.addServlet(TestServlet.class, "/test1");
        ServletHolder holder2 = context.addServlet(TestServlet.class, "/test2");
        holder1.setInitOrder(1);
        holder2.setInitOrder(2);
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        Assert.assertEquals((long)2L, (long)__testServlets.get());
        String response = this._connector.getResponse("GET /test1 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((long)2L, (long)__testServlets.get());
        response = this._connector.getResponse("GET /test2 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((long)2L, (long)__testServlets.get());
        Assert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.nullValue());
        response = this._connector.getResponse("GET /test0 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assert.assertEquals((long)3L, (long)__testServlets.get());
        Assert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assert.assertEquals((long)0L, (long)__testServlets.get());
        holder0.setInitOrder(0);
        this._server.start();
        Assert.assertEquals((long)3L, (long)__testServlets.get());
        Assert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assert.assertEquals((long)0L, (long)__testServlets.get());
    }

    @Test
    public void testAddServletAfterStart() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        this.assertResponseContains("Test", response);
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        this.assertResponseContains("Hello World", response);
    }

    @Test
    public void testHandlerBeforeServletHandler() throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        HandlerWrapper extra = new HandlerWrapper();
        context.getSessionHandler().insertHandler(extra);
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        this.assertResponseContains("Test", response);
        Assert.assertEquals((Object)extra, (Object)context.getSessionHandler().getHandler());
    }

    @Test
    public void testGzipHandlerOption() throws Exception {
        ServletContextHandler context = new ServletContextHandler(5);
        GzipHandler gzip = context.getGzipHandler();
        this._server.start();
        Assert.assertEquals((Object)context.getSessionHandler(), (Object)context.getHandler());
        Assert.assertEquals((Object)gzip, (Object)context.getSessionHandler().getHandler());
        Assert.assertEquals((Object)context.getServletHandler(), (Object)gzip.getHandler());
    }

    @Test
    public void testGzipHandlerSet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setSessionHandler(new SessionHandler());
        context.setGzipHandler(new GzipHandler());
        GzipHandler gzip = context.getGzipHandler();
        this._server.start();
        Assert.assertEquals((Object)context.getSessionHandler(), (Object)context.getHandler());
        Assert.assertEquals((Object)gzip, (Object)context.getSessionHandler().getHandler());
        Assert.assertEquals((Object)context.getServletHandler(), (Object)gzip.getHandler());
    }

    @Test
    public void testReplaceServletHandlerWithServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        this.assertResponseContains("Test", response);
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        srvHnd.addServletWithMapping(HelloServlet.class, "/hello");
        context.setServletHandler(srvHnd);
        context.start();
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        this.assertResponseContains("Hello World", response);
    }

    @Test
    public void testReplaceServletHandlerWithoutServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        this.assertResponseContains("Test", response);
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        context.setServletHandler(srvHnd);
        context.start();
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        this.assertResponseContains("Hello World", response);
    }

    @Test
    public void testReplaceHandler() throws Exception {
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        ServletHolder sh = new ServletHolder((Servlet)new TestServlet());
        servletContextHandler.addServlet(sh, "/foo");
        final AtomicBoolean contextInit = new AtomicBoolean(false);
        final AtomicBoolean contextDestroy = new AtomicBoolean(false);
        servletContextHandler.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextInit.set(true);
                }
            }

            public void contextDestroyed(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextDestroy.set(true);
                }
            }
        });
        ServletHandler shandler = servletContextHandler.getServletHandler();
        ResourceHandler rh = new ResourceHandler();
        servletContextHandler.insertHandler((HandlerWrapper)rh);
        Assert.assertEquals((Object)shandler, (Object)servletContextHandler.getServletHandler());
        Assert.assertEquals((Object)rh, (Object)servletContextHandler.getHandler());
        Assert.assertEquals((Object)rh.getHandler(), (Object)shandler);
        this._server.setHandler((Handler)servletContextHandler);
        this._server.start();
        Assert.assertTrue((boolean)contextInit.get());
        this._server.stop();
        Assert.assertTrue((boolean)contextDestroy.get());
    }

    @Test
    public void testFallThrough() throws Exception {
        HandlerList list = new HandlerList();
        this._server.setHandler((Handler)list);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)list, "/", 1);
        ServletHandler servlet = root.getServletHandler();
        servlet.setEnsureDefaultServlet(false);
        servlet.addServletWithMapping(HelloServlet.class, "/hello/*");
        list.addHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.sendError(404, "Fell Through");
            }
        });
        this._server.start();
        String response = this._connector.getResponse("GET /hello HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        response = this._connector.getResponse("GET /other HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"404 Fell Through"));
    }

    @Test
    public void testLegacyDecorator() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addDecorator((ServletContextHandler.Decorator)new DummyLegacyDecorator());
        this._server.setHandler((Handler)context);
        context.addServlet(DecoratedObjectFactoryServlet.class, "/objfactory/*");
        this._server.start();
        String response = this._connector.getResponse("GET /objfactory/ HTTP/1.0\r\n\r\n");
        Assert.assertThat((String)"Response status code", (Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        String expected = String.format("Attribute[%s] = %s", DecoratedObjectFactory.ATTR, DecoratedObjectFactory.class.getName());
        Assert.assertThat((String)"Has context attribute", (Object)response, (Matcher)Matchers.containsString((String)expected));
        Assert.assertThat((String)"Decorators size", (Object)response, (Matcher)Matchers.containsString((String)"Decorators.size = [2]"));
        expected = String.format("decorator[] = %s", DummyLegacyDecorator.class.getName());
        Assert.assertThat((String)"Specific Legacy Decorator", (Object)response, (Matcher)Matchers.containsString((String)expected));
    }

    @Test
    public void testUtilDecorator() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.getObjectFactory().addDecorator((Decorator)new DummyUtilDecorator());
        this._server.setHandler((Handler)context);
        context.addServlet(DecoratedObjectFactoryServlet.class, "/objfactory/*");
        this._server.start();
        String response = this._connector.getResponse("GET /objfactory/ HTTP/1.0\r\n\r\n");
        Assert.assertThat((String)"Response status code", (Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        String expected = String.format("Attribute[%s] = %s", DecoratedObjectFactory.ATTR, DecoratedObjectFactory.class.getName());
        Assert.assertThat((String)"Has context attribute", (Object)response, (Matcher)Matchers.containsString((String)expected));
        Assert.assertThat((String)"Decorators size", (Object)response, (Matcher)Matchers.containsString((String)"Decorators.size = [2]"));
        expected = String.format("decorator[] = %s", DummyUtilDecorator.class.getName());
        Assert.assertThat((String)"Specific Legacy Decorator", (Object)response, (Matcher)Matchers.containsString((String)expected));
    }

    private int assertResponseContains(String expected, String response) {
        int idx = response.indexOf(expected);
        if (idx == -1) {
            StringBuffer err = new StringBuffer();
            err.append("Response does not contain expected string \"").append(expected).append("\"");
            err.append("\n").append(response);
            System.err.println(err);
            Assert.fail((String)err.toString());
        }
        return idx;
    }

    public static class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void destroy() {
            super.destroy();
            __testServlets.decrementAndGet();
        }

        public void init() throws ServletException {
            __testServlets.incrementAndGet();
            super.init();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Test");
        }
    }

    public static class DecoratedObjectFactoryServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            resp.setStatus(200);
            PrintWriter out = resp.getWriter();
            Object obj = req.getServletContext().getAttribute(DecoratedObjectFactory.ATTR);
            out.printf("Attribute[%s] = %s%n", DecoratedObjectFactory.ATTR, obj.getClass().getName());
            if (obj instanceof DecoratedObjectFactory) {
                out.printf("Object is a DecoratedObjectFactory%n", new Object[0]);
                DecoratedObjectFactory objFactory = (DecoratedObjectFactory)obj;
                List decorators = objFactory.getDecorators();
                out.printf("Decorators.size = [%d]%n", decorators.size());
                for (Decorator decorator : decorators) {
                    out.printf(" decorator[] = %s%n", decorator.getClass().getName());
                }
            } else {
                out.printf("Object is NOT a DecoratedObjectFactory%n", new Object[0]);
            }
        }
    }

    public static class DummyLegacyDecorator
    implements ServletContextHandler.Decorator {
        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class DummyUtilDecorator
    implements Decorator {
        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class HelloServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Hello World");
        }
    }
}

