/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.client.util.OutputStreamContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MultiPartServletTest {
    private Server server;
    private ServerConnector connector;
    private HttpClient client;
    private Path tmpDir;
    private ServletContextHandler contextHandler;
    private static final int MAX_FILE_SIZE = 524288;
    private static final int MAX_REQUEST_SIZE = 0x800000;
    private static final int LARGE_MESSAGE_SIZE = 0x100000;

    public static Stream<Arguments> complianceModes() {
        return Stream.of(Arguments.of((Object[])new Object[]{MultiPartFormDataCompliance.RFC7578}), Arguments.of((Object[])new Object[]{MultiPartFormDataCompliance.LEGACY}));
    }

    @BeforeEach
    public void start() throws Exception {
        this.tmpDir = Files.createTempDirectory(MultiPartServletTest.class.getSimpleName(), new FileAttribute[0]);
        Assertions.assertNotNull((Object)this.tmpDir);
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        MultipartConfigElement config = new MultipartConfigElement(this.tmpDir.toAbsolutePath().toString(), 524288L, -1L, 1);
        MultipartConfigElement requestSizedConfig = new MultipartConfigElement(this.tmpDir.toAbsolutePath().toString(), -1L, 0x800000L, 1);
        MultipartConfigElement defaultConfig = new MultipartConfigElement(this.tmpDir.toAbsolutePath().toString(), -1L, -1L, 1);
        this.contextHandler = new ServletContextHandler(1);
        this.contextHandler.setContextPath("/");
        ServletHolder servletHolder = this.contextHandler.addServlet(MultiPartServlet.class, "/");
        servletHolder.getRegistration().setMultipartConfig(config);
        servletHolder = this.contextHandler.addServlet(RequestParameterServlet.class, "/defaultConfig");
        servletHolder.getRegistration().setMultipartConfig(defaultConfig);
        servletHolder = this.contextHandler.addServlet(RequestParameterServlet.class, "/requestSizeLimit");
        servletHolder.getRegistration().setMultipartConfig(requestSizedConfig);
        servletHolder = this.contextHandler.addServlet(MultiPartEchoServlet.class, "/echo");
        servletHolder.getRegistration().setMultipartConfig(config);
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.addIncludedMethods(new String[]{HttpMethod.POST.asString()});
        gzipHandler.addIncludedMimeTypes(new String[]{"multipart/form-data"});
        gzipHandler.setMinGzipSize(32);
        gzipHandler.setHandler((Handler)this.contextHandler);
        this.server.setHandler((Handler)gzipHandler);
        this.server.start();
        this.client = new HttpClient();
        this.client.start();
        this.client.getContentDecoderFactories().clear();
    }

    @AfterEach
    public void stop() throws Exception {
        this.client.stop();
        this.server.stop();
        IO.delete((File)this.tmpDir.toFile());
    }

    @ParameterizedTest
    @MethodSource(value={"complianceModes"})
    public void testLargePart(MultiPartFormDataCompliance compliance) throws Exception {
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(compliance);
        OutputStreamContentProvider content = new OutputStreamContentProvider();
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        multiPart.addFieldPart("param", (ContentProvider)content, null);
        multiPart.close();
        InputStreamResponseListener listener = new InputStreamResponseListener();
        this.client.newRequest("localhost", this.connector.getLocalPort()).path("/defaultConfig").scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).content((ContentProvider)multiPart).send((Response.CompleteListener)listener);
        byte[] byteArray = new byte[0x100000];
        Arrays.fill(byteArray, (byte)1);
        for (int i = 0; i < 2048; ++i) {
            content.getOutputStream().write(byteArray);
        }
        content.close();
        Response response = listener.get(2L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)400));
        String responseContent = IO.toString((InputStream)listener.getInputStream());
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Unable to parse form content"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Form is larger than max length"));
    }

    @ParameterizedTest
    @MethodSource(value={"complianceModes"})
    public void testManyParts(MultiPartFormDataCompliance compliance) throws Exception {
        int maxParts = 1000;
        this.contextHandler.setMaxFormKeys(maxParts);
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(compliance);
        byte[] byteArray = new byte[10];
        Arrays.fill(byteArray, (byte)1);
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        for (int i = 0; i < maxParts; ++i) {
            BytesContentProvider content = new BytesContentProvider((byte[][])new byte[][]{byteArray});
            multiPart.addFieldPart("part" + i, (ContentProvider)content, null);
        }
        multiPart.close();
        InputStreamResponseListener listener = new InputStreamResponseListener();
        this.client.newRequest("localhost", this.connector.getLocalPort()).path("/defaultConfig").scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).content((ContentProvider)multiPart).send((Response.CompleteListener)listener);
        Response response = listener.get(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        String responseContent = IO.toString((InputStream)listener.getInputStream());
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"success"));
    }

    @ParameterizedTest
    @MethodSource(value={"complianceModes"})
    public void testTooManyParts(MultiPartFormDataCompliance compliance) throws Exception {
        int maxParts = 1000;
        this.contextHandler.setMaxFormKeys(maxParts);
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(compliance);
        byte[] byteArray = new byte[5];
        Arrays.fill(byteArray, (byte)1);
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        for (int i = 0; i < 0x100000; ++i) {
            BytesContentProvider content = new BytesContentProvider((byte[][])new byte[][]{byteArray});
            multiPart.addFieldPart("part" + i, (ContentProvider)content, null);
        }
        multiPart.close();
        InputStreamResponseListener listener = new InputStreamResponseListener();
        this.client.newRequest("localhost", this.connector.getLocalPort()).path("/defaultConfig").scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).content((ContentProvider)multiPart).send((Response.CompleteListener)listener);
        Response response = listener.get(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)400));
        String responseContent = IO.toString((InputStream)listener.getInputStream());
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Unable to parse form content"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Form with too many parts"));
    }

    @ParameterizedTest
    @MethodSource(value={"complianceModes"})
    public void testMaxRequestSize(MultiPartFormDataCompliance compliance) throws Exception {
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(compliance);
        OutputStreamContentProvider content = new OutputStreamContentProvider();
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        multiPart.addFieldPart("param", (ContentProvider)content, null);
        multiPart.close();
        InputStreamResponseListener listener = new InputStreamResponseListener();
        this.client.newRequest("localhost", this.connector.getLocalPort()).path("/requestSizeLimit").scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).content((ContentProvider)multiPart).send((Response.CompleteListener)listener);
        Exception writeError = null;
        try {
            byte[] byteArray = new byte[0x100000];
            Arrays.fill(byteArray, (byte)1);
            for (int i = 0; i < 512; ++i) {
                content.getOutputStream().write(byteArray);
            }
        }
        catch (Exception e) {
            writeError = e;
        }
        if (writeError != null) {
            MatcherAssert.assertThat((Object)writeError, (Matcher)Matchers.instanceOf(EofException.class));
        }
        Response response = listener.get(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)400));
    }

    @ParameterizedTest
    @MethodSource(value={"complianceModes"})
    public void testTempFilesDeletedOnError(MultiPartFormDataCompliance compliance) throws Exception {
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(compliance);
        byte[] byteArray = new byte[0x100000];
        Arrays.fill(byteArray, (byte)1);
        BytesContentProvider contentProvider = new BytesContentProvider((byte[][])new byte[][]{byteArray});
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        multiPart.addFieldPart("largePart", (ContentProvider)contentProvider, null);
        multiPart.close();
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{HttpChannel.class, MultiPartFormInputStream.class});){
            ContentResponse response = this.client.newRequest("localhost", this.connector.getLocalPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).content((ContentProvider)multiPart).send();
            Assertions.assertEquals((int)500, (int)response.getStatus());
            MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"Multipart Mime part largePart exceeds max filesize"));
        }
        String[] fileList = this.tmpDir.toFile().list();
        Assertions.assertNotNull((Object)fileList);
        MatcherAssert.assertThat((Object)fileList.length, (Matcher)Matchers.is((Object)0));
    }

    @ParameterizedTest
    @MethodSource(value={"complianceModes"})
    public void testMultiPartGzip(MultiPartFormDataCompliance compliance) throws Exception {
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(compliance);
        String contentString = "the quick brown fox jumps over the lazy dog, the quick brown fox jumps over the lazy dog";
        StringContentProvider content = new StringContentProvider(contentString);
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        multiPart.addFieldPart("largePart", (ContentProvider)content, null);
        multiPart.close();
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{HttpChannel.class, MultiPartFormInputStream.class});){
            InputStreamResponseListener responseStream = new InputStreamResponseListener();
            this.client.newRequest("localhost", this.connector.getLocalPort()).path("/echo").scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).header(HttpHeader.ACCEPT_ENCODING, "gzip").content((ContentProvider)multiPart).send((Response.CompleteListener)responseStream);
            Response response = responseStream.get(5L, TimeUnit.SECONDS);
            HttpFields headers = response.getHeaders();
            MatcherAssert.assertThat((Object)headers.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.startsWith((String)"multipart/form-data"));
            MatcherAssert.assertThat((Object)headers.get(HttpHeader.CONTENT_ENCODING), (Matcher)Matchers.is((Object)"gzip"));
            GZIPInputStream inputStream = new GZIPInputStream(responseStream.getInputStream());
            String contentType = headers.get(HttpHeader.CONTENT_TYPE);
            MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)inputStream, contentType, null, null);
            ArrayList parts = new ArrayList(mpis.getParts());
            MatcherAssert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)IO.toString((InputStream)((Part)parts.get(0)).getInputStream()), (Matcher)Matchers.is((Object)contentString));
        }
    }

    public static class MultiPartServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (!req.getContentType().contains(MimeTypes.Type.MULTIPART_FORM_DATA.asString())) {
                resp.setContentType("text/plain");
                resp.getWriter().println("not content type " + MimeTypes.Type.MULTIPART_FORM_DATA);
                resp.getWriter().println("contentType: " + req.getContentType());
                return;
            }
            resp.setContentType("text/plain");
            for (Part part : req.getParts()) {
                resp.getWriter().println("Part: name=" + part.getName() + ", size=" + part.getSize());
            }
        }
    }

    public static class RequestParameterServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            req.getParameterMap();
            req.getParts();
            resp.setStatus(200);
            resp.getWriter().print("success");
            resp.getWriter().close();
        }
    }

    public static class MultiPartEchoServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (!req.getContentType().contains(MimeTypes.Type.MULTIPART_FORM_DATA.asString())) {
                resp.sendError(400);
                return;
            }
            resp.setContentType(req.getContentType());
            IO.copy((InputStream)req.getInputStream(), (OutputStream)resp.getOutputStream());
        }
    }
}

