/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MultiPartServletTest {
    private static final Logger LOG = Log.getLogger(MultiPartServletTest.class);
    private Server server;
    private ServerConnector connector;
    private HttpClient client;
    private Path tmpDir;
    private static final int MAX_FILE_SIZE = 524288;
    private static final int LARGE_MESSAGE_SIZE = 0x100000;

    public static Stream<Arguments> data() {
        return Arrays.asList(MultiPartFormDataCompliance.values()).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @BeforeEach
    public void start() throws Exception {
        this.tmpDir = Files.createTempDirectory(MultiPartServletTest.class.getSimpleName(), new FileAttribute[0]);
        Assertions.assertNotNull((Object)this.tmpDir);
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        MultipartConfigElement config = new MultipartConfigElement(this.tmpDir.toAbsolutePath().toString(), 524288L, -1L, 1);
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        contextHandler.setContextPath("/");
        ServletHolder servletHolder = contextHandler.addServlet(MultiPartServlet.class, "/");
        servletHolder.getRegistration().setMultipartConfig(config);
        servletHolder = contextHandler.addServlet(MultiPartEchoServlet.class, "/echo");
        servletHolder.getRegistration().setMultipartConfig(config);
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.addIncludedMethods(new String[]{HttpMethod.POST.asString()});
        gzipHandler.addIncludedMimeTypes(new String[]{"multipart/form-data"});
        gzipHandler.setMinGzipSize(32);
        gzipHandler.setHandler((Handler)contextHandler);
        this.server.setHandler((Handler)gzipHandler);
        this.server.start();
        this.client = new HttpClient();
        this.client.start();
        this.client.getContentDecoderFactories().clear();
    }

    @AfterEach
    public void stop() throws Exception {
        this.client.stop();
        this.server.stop();
        IO.delete((File)this.tmpDir.toFile());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testTempFilesDeletedOnError(MultiPartFormDataCompliance compliance) throws Exception {
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(compliance);
        byte[] byteArray = new byte[0x100000];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = 1;
        }
        BytesContentProvider contentProvider = new BytesContentProvider((byte[][])new byte[][]{byteArray});
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        multiPart.addFieldPart("largePart", (ContentProvider)contentProvider, null);
        multiPart.close();
        try (StacklessLogging stacklessLogging = new StacklessLogging(new Class[]{HttpChannel.class, MultiPartFormInputStream.class});){
            ContentResponse response = this.client.newRequest("localhost", this.connector.getLocalPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).content((ContentProvider)multiPart).send();
            Assertions.assertEquals((int)500, (int)response.getStatus());
            MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"Multipart Mime part largePart exceeds max filesize"));
        }
        String[] fileList = this.tmpDir.toFile().list();
        Assertions.assertNotNull((Object)fileList);
        MatcherAssert.assertThat((Object)fileList.length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testMultiPartGzip() throws Exception {
        String contentString = "the quick brown fox jumps over the lazy dog, the quick brown fox jumps over the lazy dog";
        StringContentProvider content = new StringContentProvider(contentString);
        MultiPartContentProvider multiPart = new MultiPartContentProvider();
        multiPart.addFieldPart("largePart", (ContentProvider)content, null);
        multiPart.close();
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{HttpChannel.class, MultiPartFormInputStream.class});){
            InputStreamResponseListener responseStream = new InputStreamResponseListener();
            this.client.newRequest("localhost", this.connector.getLocalPort()).path("/echo").scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).header(HttpHeader.ACCEPT_ENCODING, "gzip").content((ContentProvider)multiPart).send((Response.CompleteListener)responseStream);
            Response response = responseStream.get(5L, TimeUnit.SECONDS);
            HttpFields headers = response.getHeaders();
            MatcherAssert.assertThat((Object)headers.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.startsWith((String)"multipart/form-data"));
            MatcherAssert.assertThat((Object)headers.get(HttpHeader.CONTENT_ENCODING), (Matcher)Matchers.is((Object)"gzip"));
            GZIPInputStream inputStream = new GZIPInputStream(responseStream.getInputStream());
            String contentType = headers.get(HttpHeader.CONTENT_TYPE);
            MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)inputStream, contentType, null, null);
            ArrayList parts = new ArrayList(mpis.getParts());
            MatcherAssert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)IO.toString((InputStream)((Part)parts.get(0)).getInputStream()), (Matcher)Matchers.is((Object)contentString));
        }
    }

    public static class MultiPartEchoServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (!req.getContentType().contains(MimeTypes.Type.MULTIPART_FORM_DATA.asString())) {
                resp.sendError(400);
                return;
            }
            resp.setContentType(req.getContentType());
            IO.copy((InputStream)req.getInputStream(), (OutputStream)resp.getOutputStream());
        }
    }

    public static class MultiPartServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (!req.getContentType().contains(MimeTypes.Type.MULTIPART_FORM_DATA.asString())) {
                resp.setContentType("text/plain");
                resp.getWriter().println("not content type " + MimeTypes.Type.MULTIPART_FORM_DATA);
                resp.getWriter().println("contentType: " + req.getContentType());
                return;
            }
            resp.setContentType("text/plain");
            for (Part part : req.getParts()) {
                resp.getWriter().println("Part: name=" + part.getName() + ", size=" + part.getSize());
            }
        }
    }
}

