/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterHolderTest {
    @Test
    public void testInitialize() throws Exception {
        ServletHandler handler = new ServletHandler();
        final AtomicInteger counter = new AtomicInteger(0);
        Filter filter = new Filter(){

            public void init(FilterConfig filterConfig) {
                counter.incrementAndGet();
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
            }

            public void destroy() {
            }
        };
        FilterHolder fh = new FilterHolder();
        fh.setServletHandler(handler);
        fh.setName("xx");
        fh.setFilter(filter);
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{FilterHolder.class});){
            Assertions.assertThrows(IllegalStateException.class, () -> ((FilterHolder)fh).initialize());
        }
        fh.start();
        fh.initialize();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.initialize();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.stop();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.start();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.initialize();
        Assertions.assertEquals((int)2, (int)counter.get());
    }
}

