/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ErrorPageTest {
    private Server _server;
    private LocalConnector _connector;
    private StacklessLogging _stackless;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        ServletContextHandler context = new ServletContextHandler(0);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)context);
        context.setContextPath("/");
        context.addServlet(DefaultServlet.class, "/");
        context.addServlet(FailServlet.class, "/fail/*");
        context.addServlet(ErrorServlet.class, "/error/*");
        ErrorPageErrorHandler error = new ErrorPageErrorHandler();
        context.setErrorHandler((ErrorHandler)error);
        error.addErrorPage(599, "/error/599");
        error.addErrorPage(IllegalStateException.class.getCanonicalName(), "/error/TestException");
        error.addErrorPage("org.eclipse.jetty.server.error_page.global", "/error/GlobalErrorPage");
        this._server.start();
        this._stackless = new StacklessLogging(new Class[]{ServletHandler.class});
    }

    @After
    public void destroy() throws Exception {
        this._stackless.close();
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testErrorCode() throws Exception {
        String response = this._connector.getResponse("GET /fail/code?code=599 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/code"));
    }

    @Test
    public void testErrorException() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            String response = this._connector.getResponse("GET /fail/exception HTTP/1.0\r\n\r\n");
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /TestException"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 500"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: javax.servlet.ServletException: java.lang.IllegalStateException"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class javax.servlet.ServletException"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/exception"));
        }
    }

    @Test
    public void testGlobalErrorCode() throws Exception {
        String response = this._connector.getResponse("GET /fail/global?code=598 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 598 598"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 598"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/global"));
    }

    @Test
    public void testGlobalErrorException() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            String response = this._connector.getResponse("GET /fail/global?code=NAN HTTP/1.0\r\n\r\n");
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 500"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: java.lang.NumberFormatException: For input string: \"NAN\""));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class java.lang.NumberFormatException"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/global"));
        }
    }

    public static class ErrorServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getWriter().println("ERROR_PAGE: " + request.getPathInfo());
            response.getWriter().println("ERROR_MESSAGE: " + request.getAttribute("javax.servlet.error.message"));
            response.getWriter().println("ERROR_CODE: " + request.getAttribute("javax.servlet.error.status_code"));
            response.getWriter().println("ERROR_EXCEPTION: " + request.getAttribute("javax.servlet.error.exception"));
            response.getWriter().println("ERROR_EXCEPTION_TYPE: " + request.getAttribute("javax.servlet.error.exception_type"));
            response.getWriter().println("ERROR_SERVLET: " + request.getAttribute("javax.servlet.error.servlet_name"));
            response.getWriter().println("ERROR_REQUEST_URI: " + request.getAttribute("javax.servlet.error.request_uri"));
        }
    }

    public static class FailServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String code = request.getParameter("code");
            if (code == null) {
                throw new ServletException((Throwable)new IllegalStateException());
            }
            response.sendError(Integer.parseInt(code));
        }
    }
}

