/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RequestHeadersTest {
    private static Server server;
    private static ServerConnector connector;
    private static URI serverUri;

    @BeforeClass
    public static void startServer() throws Exception {
        server = new Server();
        connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new RequestHeaderServlet()), "/*");
        server.start();
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        serverUri = new URI(String.format("http://%s:%d/", host, port));
    }

    @AfterClass
    public static void stopServer() {
        try {
            server.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetLowercaseHeader() throws IOException {
        HttpURLConnection http = null;
        try {
            http = (HttpURLConnection)serverUri.toURL().openConnection();
            http.setRequestProperty("x-camel-type", "bactrian");
            try (InputStream in = http.getInputStream();){
                String resp = IO.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.is((Object)"X-Camel-Type = bactrian"));
            }
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
    }

    private static class RequestHeaderServlet
    extends HttpServlet {
        private RequestHeaderServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            PrintWriter out = resp.getWriter();
            out.printf("X-Camel-Type = %s", req.getHeader("X-Camel-Type"));
        }
    }
}

