/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Not handling Exceptions during Async very well")
public class AsyncListenerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorNoAsync() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                throw new FooRuntimeException();
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorAsyncStart_Exception() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                req.startAsync();
                throw new FooRuntimeException();
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorAsyncStart_AddEmptyListener_Exception() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                AsyncContext ctx = req.startAsync();
                ctx.addListener((AsyncListener)new AsyncListenerAdapter());
                throw new FooRuntimeException();
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorAsyncStart_AddListener_Exception() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                AsyncContext ctx = req.startAsync();
                ctx.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onError(AsyncEvent event) throws IOException {
                        System.err.println("### ONERROR");
                        event.getThrowable().printStackTrace(System.err);
                        event.getAsyncContext().complete();
                    }
                });
                throw new FooRuntimeException();
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorAsyncStart_AddListener_ExceptionDuringOnStart() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                AsyncContext ctx = req.startAsync();
                ctx.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onStartAsync(AsyncEvent event) throws IOException {
                        throw new FooRuntimeException();
                    }
                });
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorAsyncStart_AddListener_ExceptionDuringOnComplete() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                AsyncContext ctx = req.startAsync();
                ctx.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onComplete(AsyncEvent event) throws IOException {
                        throw new FooRuntimeException();
                    }
                });
                ctx.complete();
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorAsyncStart_AddListener_ExceptionDuringOnTimeout() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                AsyncContext ctx = req.startAsync();
                ctx.setTimeout(1000L);
                ctx.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onTimeout(AsyncEvent event) throws IOException {
                        throw new FooRuntimeException();
                    }
                });
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterErrorAsyncStart_NoListener_ExceptionDuringStart() throws Exception {
        Server server = new Server();
        LocalConnector conn = new LocalConnector(server);
        conn.setIdleTimeout(10000L);
        server.addConnector((Connector)conn);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                AsyncContext ctx = req.startAsync();
                ctx.setTimeout(1000L);
                ctx.start(new Runnable(){

                    @Override
                    public void run() {
                        throw new FooRuntimeException();
                    }
                });
            }
        };
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        context.addServlet(holder, "/err/*");
        LinkedList<ErrorContext> tracking = new LinkedList<ErrorContext>();
        ErrorFilter filter = new ErrorFilter(tracking);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
        server.setHandler((Handler)context);
        try {
            server.start();
            String resp = conn.getResponses("GET /err/ HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            Assert.assertThat((String)"Response status", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            Assert.assertThat((String)"Response", (Object)resp, (Matcher)Matchers.containsString((String)FooRuntimeException.class.getName()));
        }
        finally {
            server.stop();
        }
    }

    public static class ErrorFilter
    implements Filter {
        private final List<ErrorContext> tracking;

        public ErrorFilter(List<ErrorContext> tracking) {
            this.tracking = tracking;
        }

        public void destroy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ErrorContext err = new ErrorContext();
            this.tracking.add(err);
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable t) {
                err.report(t, request, response);
            }
            finally {
                if (request.isAsyncStarted()) {
                    request.getAsyncContext().addListener((AsyncListener)err);
                }
            }
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }
    }

    public static class ErrorContext
    implements AsyncListener {
        private static final Logger LOG = Log.getLogger(ErrorContext.class);

        public void report(Throwable t, ServletRequest req, ServletResponse resp) throws IOException {
            if (resp instanceof HttpServletResponse) {
                ((HttpServletResponse)resp).setStatus(500);
            }
            resp.setContentType("text/plain");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            PrintWriter out = resp.getWriter();
            t.printStackTrace(out);
        }

        private void reportThrowable(AsyncEvent event) throws IOException {
            Throwable t = event.getThrowable();
            if (t == null) {
                return;
            }
            ServletRequest req = event.getAsyncContext().getRequest();
            ServletResponse resp = event.getAsyncContext().getResponse();
            this.report(t, req, resp);
        }

        public void onComplete(AsyncEvent event) throws IOException {
            LOG.info("onComplete({})", new Object[]{event});
            this.reportThrowable(event);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            LOG.info("onTimeout({})", new Object[]{event});
            this.reportThrowable(event);
        }

        public void onError(AsyncEvent event) throws IOException {
            LOG.info("onError({})", new Object[]{event});
            this.reportThrowable(event);
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            LOG.info("onStartAsync({})", new Object[]{event});
            this.reportThrowable(event);
        }
    }

    public static class AsyncListenerAdapter
    implements AsyncListener {
        private static final Logger LOG = Log.getLogger(AsyncListenerAdapter.class);

        public void onComplete(AsyncEvent event) throws IOException {
            LOG.info("onComplete({})", new Object[]{event});
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            LOG.info("onTimeout({})", new Object[]{event});
        }

        public void onError(AsyncEvent event) throws IOException {
            LOG.info("onError({})", new Object[]{event});
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            LOG.info("onStartAsync({})", new Object[]{event});
        }
    }

    public static class FooError
    extends Error {
    }

    public static class FooThrowable
    extends Throwable {
    }

    public static class FooException
    extends Exception {
    }

    public static class FooRuntimeException
    extends RuntimeException {
    }
}

