/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncContextTest {
    private Server _server;
    private ServletContextHandler _contextHandler;
    private LocalConnector _connector;
    public static volatile AsyncContext __asyncContext;

    @Before
    public void setUp() throws Exception {
        this._server = new Server();
        this._contextHandler = new ServletContextHandler(0);
        this._connector = new LocalConnector(this._server);
        this._connector.setIdleTimeout(5000L);
        ((HttpConnectionFactory)this._connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setSendDateHeader(false);
        this._server.setConnectors(new Connector[]{this._connector});
        this._contextHandler.setContextPath("/ctx");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/servletPath");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/path with spaces/servletPath");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet2()), "/servletPath2");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestStartThrowServlet()), "/startthrow/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new ForwardingServlet()), "/forward");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new AsyncDispatchingServlet()), "/dispatchingServlet");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new ExpireServlet()), "/expire/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new BadExpireServlet()), "/badexpire/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new ErrorServlet()), "/error/*");
        ErrorPageErrorHandler error_handler = new ErrorPageErrorHandler();
        this._contextHandler.setErrorHandler((ErrorHandler)error_handler);
        error_handler.addErrorPage(500, "/error/500");
        error_handler.addErrorPage(IOException.class.getName(), "/error/IOE");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this._contextHandler, new DefaultHandler()});
        this._server.setHandler((Handler)handlers);
        this._server.start();
    }

    @After
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testSimpleAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertEquals((String)"servlet gets right path", (Object)"doGet:getServletPath:/servletPath", (Object)br.readLine());
        Assert.assertEquals((String)"async context gets right path in get", (Object)"doGet:async:getServletPath:/servletPath", (Object)br.readLine());
        Assert.assertEquals((String)"async context gets right path in async", (Object)"async:run:attr:servletPath:/servletPath", (Object)br.readLine());
    }

    @Test
    public void testStartThrow() throws Exception {
        String request = "GET /ctx/startthrow HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 500 Server Error", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        Assert.assertEquals((String)"error servlet", (Object)"ERROR: /error", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"PathInfo= /IOE", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"EXCEPTION: org.eclipse.jetty.server.QuietServletException: java.io.IOException: Test", (Object)br.readLine());
    }

    @Test
    public void testStartDispatchThrow() throws Exception {
        String request = "GET /ctx/startthrow?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 500 Server Error", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        Assert.assertEquals((String)"error servlet", (Object)"ERROR: /error", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"PathInfo= /IOE", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"EXCEPTION: org.eclipse.jetty.server.QuietServletException: java.io.IOException: Test", (Object)br.readLine());
    }

    @Test
    public void testStartCompleteThrow() throws Exception {
        String request = "GET /ctx/startthrow?complete=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 500 Server Error", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        Assert.assertEquals((String)"error servlet", (Object)"ERROR: /error", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"PathInfo= /IOE", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"EXCEPTION: org.eclipse.jetty.server.QuietServletException: java.io.IOException: Test", (Object)br.readLine());
    }

    @Test
    public void testStartFlushCompleteThrow() throws Exception {
        String request = "GET /ctx/startthrow?flush=true&complete=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        Assert.assertEquals((String)"error servlet", (Object)"completeBeforeThrow", (Object)br.readLine());
    }

    @Test
    public void testDispatchAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertEquals((String)"servlet gets right path", (Object)"doGet:getServletPath:/servletPath2", (Object)br.readLine());
        Assert.assertEquals((String)"async context gets right path in get", (Object)"doGet:async:getServletPath:/servletPath2", (Object)br.readLine());
        Assert.assertEquals((String)"servlet path attr is original", (Object)"async:run:attr:servletPath:/servletPath", (Object)br.readLine());
        Assert.assertEquals((String)"path info attr is correct", (Object)"async:run:attr:pathInfo:null", (Object)br.readLine());
        Assert.assertEquals((String)"query string attr is correct", (Object)"async:run:attr:queryString:dispatch=true", (Object)br.readLine());
        Assert.assertEquals((String)"context path attr is correct", (Object)"async:run:attr:contextPath:/ctx", (Object)br.readLine());
        Assert.assertEquals((String)"request uri attr is correct", (Object)"async:run:attr:requestURI:/ctx/servletPath", (Object)br.readLine());
        try {
            __asyncContext.getRequest();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDispatchAsyncContextEncodedPathAndQueryString() throws Exception {
        String request = "GET /ctx/path%20with%20spaces/servletPath?dispatch=true&queryStringWithEncoding=space%20space HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertThat((String)"servlet gets right path", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"doGet:getServletPath:/servletPath2"));
        Assert.assertThat((String)"async context gets right path in get", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"doGet:async:getServletPath:/servletPath2"));
        Assert.assertThat((String)"servlet path attr is original", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:servletPath:/path with spaces/servletPath"));
        Assert.assertThat((String)"path info attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:pathInfo:null"));
        Assert.assertThat((String)"query string attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:queryString:dispatch=true&queryStringWithEncoding=space%20space"));
        Assert.assertThat((String)"context path attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:contextPath:/ctx"));
        Assert.assertThat((String)"request uri attr is correct", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"async:run:attr:requestURI:/ctx/path%20with%20spaces/servletPath"));
    }

    @Test
    public void testSimpleWithContextAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertEquals((String)"servlet gets right path", (Object)"doGet:getServletPath:/servletPath", (Object)br.readLine());
        Assert.assertEquals((String)"async context gets right path in get", (Object)"doGet:async:getServletPath:/servletPath", (Object)br.readLine());
        Assert.assertEquals((String)"async context gets right path in async", (Object)"async:run:attr:servletPath:/servletPath", (Object)br.readLine());
    }

    @Test
    public void testDispatchWithContextAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertEquals((String)"servlet gets right path", (Object)"doGet:getServletPath:/servletPath2", (Object)br.readLine());
        Assert.assertEquals((String)"async context gets right path in get", (Object)"doGet:async:getServletPath:/servletPath2", (Object)br.readLine());
        Assert.assertEquals((String)"servlet path attr is original", (Object)"async:run:attr:servletPath:/servletPath", (Object)br.readLine());
        Assert.assertEquals((String)"path info attr is correct", (Object)"async:run:attr:pathInfo:null", (Object)br.readLine());
        Assert.assertEquals((String)"query string attr is correct", (Object)"async:run:attr:queryString:dispatch=true", (Object)br.readLine());
        Assert.assertEquals((String)"context path attr is correct", (Object)"async:run:attr:contextPath:/ctx", (Object)br.readLine());
        Assert.assertEquals((String)"request uri attr is correct", (Object)"async:run:attr:requestURI:/ctx/servletPath", (Object)br.readLine());
    }

    @Test
    public void testDispatch() throws Exception {
        String request = "GET /ctx/forward HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertThat((String)"!ForwardingServlet", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"Dispatched back to ForwardingServlet"));
    }

    @Test
    public void testDispatchRequestResponse() throws Exception {
        String request = "GET /ctx/forward?dispatchRequestResponse=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = this.parseHeader(responseString);
        Assert.assertThat((String)"!AsyncDispatchingServlet", (Object)br.readLine(), (Matcher)Matchers.equalTo((Object)"Dispatched back to AsyncDispatchingServlet"));
    }

    private BufferedReader parseHeader(String responseString) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        return br;
    }

    @Test
    public void testExpire() throws Exception {
        String request = "GET /ctx/expire HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 500 Async Timeout", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        Assert.assertEquals((String)"error servlet", (Object)"ERROR: /error", (Object)br.readLine());
    }

    @Test
    public void testBadExpire() throws Exception {
        String request = "GET /ctx/badexpire HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponses(request);
        BufferedReader br = new BufferedReader(new StringReader(responseString));
        Assert.assertEquals((Object)"HTTP/1.1 500 Server Error", (Object)br.readLine());
        br.readLine();
        br.readLine();
        br.readLine();
        Assert.assertEquals((String)"error servlet", (Object)"ERROR: /error", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"PathInfo= /500", (Object)br.readLine());
        Assert.assertEquals((String)"error servlet", (Object)"EXCEPTION: java.lang.RuntimeException: TEST", (Object)br.readLine());
    }

    @After
    public void tearDown() throws Exception {
        this._server.stop();
        this._server.join();
    }

    private class Wrapper
    extends HttpServletResponseWrapper {
        public Wrapper(HttpServletResponse response) {
            super(response);
        }
    }

    private class AsyncRunnable
    implements Runnable {
        private AsyncContext _context;

        public AsyncRunnable(AsyncContext context) {
            this._context = context;
        }

        @Override
        public void run() {
            HttpServletRequest req = (HttpServletRequest)this._context.getRequest();
            try {
                this._context.getResponse().getOutputStream().print("async:run:attr:servletPath:" + req.getAttribute("javax.servlet.async.servlet_path") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:pathInfo:" + req.getAttribute("javax.servlet.async.path_info") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:queryString:" + req.getAttribute("javax.servlet.async.query_string") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:contextPath:" + req.getAttribute("javax.servlet.async.context_path") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:requestURI:" + req.getAttribute("javax.servlet.async.request_uri") + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._context.complete();
        }
    }

    private class TestStartThrowServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestStartThrowServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.REQUEST) {
                request.startAsync((ServletRequest)request, (ServletResponse)response);
                if (Boolean.valueOf(request.getParameter("dispatch")).booleanValue()) {
                    request.getAsyncContext().dispatch();
                }
                if (Boolean.valueOf(request.getParameter("complete")).booleanValue()) {
                    response.getOutputStream().write("completeBeforeThrow".getBytes());
                    if (Boolean.valueOf(request.getParameter("flush")).booleanValue()) {
                        response.flushBuffer();
                    }
                    request.getAsyncContext().complete();
                }
                throw new QuietServletException((Throwable)new IOException("Test"));
            }
        }
    }

    private class TestServlet2
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestServlet2() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext asyncContext;
            response.getOutputStream().print("doGet:getServletPath:" + request.getServletPath() + "\n");
            __asyncContext = asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
            response.getOutputStream().print("doGet:async:getServletPath:" + ((HttpServletRequest)asyncContext.getRequest()).getServletPath() + "\n");
            asyncContext.start((Runnable)new AsyncRunnable(asyncContext));
        }
    }

    private class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getParameter("dispatch") != null) {
                AsyncContext asyncContext;
                __asyncContext = asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                asyncContext.dispatch("/servletPath2");
            } else {
                AsyncContext asyncContext;
                response.getOutputStream().print("doGet:getServletPath:" + request.getServletPath() + "\n");
                __asyncContext = asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.getOutputStream().print("doGet:async:getServletPath:" + ((HttpServletRequest)asyncContext.getRequest()).getServletPath() + "\n");
                asyncContext.start((Runnable)new AsyncRunnable(asyncContext));
            }
        }
    }

    private class BadExpireServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private BadExpireServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.REQUEST) {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.addListener(new AsyncListener(){

                    public void onTimeout(AsyncEvent event) throws IOException {
                        throw new RuntimeException("TEST");
                    }

                    public void onStartAsync(AsyncEvent event) throws IOException {
                    }

                    public void onError(AsyncEvent event) throws IOException {
                    }

                    public void onComplete(AsyncEvent event) throws IOException {
                    }
                });
                asyncContext.setTimeout(100L);
            }
        }
    }

    private class ExpireServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private ExpireServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.REQUEST) {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(100L);
            }
        }
    }

    private class ErrorServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private ErrorServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getOutputStream().print("ERROR: " + request.getServletPath() + "\n");
            response.getOutputStream().print("PathInfo= " + request.getPathInfo() + "\n");
            if (request.getAttribute("javax.servlet.error.exception") != null) {
                response.getOutputStream().print("EXCEPTION: " + request.getAttribute("javax.servlet.error.exception") + "\n");
            }
        }
    }

    private class DispatchingRunnable
    implements Runnable {
        private AsyncContext asyncContext;
        private boolean wrapped;

        public DispatchingRunnable(AsyncContext asyncContext, boolean wrapped) {
            this.asyncContext = asyncContext;
            this.wrapped = wrapped;
        }

        @Override
        public void run() {
            if (this.wrapped) {
                Assert.assertTrue((boolean)(this.asyncContext.getResponse() instanceof Wrapper));
            }
            this.asyncContext.dispatch();
        }
    }

    private class AsyncDispatchingServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private AsyncDispatchingServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            Request request = (Request)req;
            if (request.getDispatcherType() == DispatcherType.ASYNC) {
                response.getOutputStream().print("Dispatched back to AsyncDispatchingServlet");
            } else {
                AsyncContext asyncContext;
                boolean wrapped = false;
                if (request.getParameter("dispatchRequestResponse") != null) {
                    wrapped = true;
                    __asyncContext = asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)new Wrapper(response));
                } else {
                    __asyncContext = asyncContext = request.startAsync();
                }
                new Thread(new DispatchingRunnable(asyncContext, wrapped)).start();
            }
        }
    }

    private class ForwardingServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private ForwardingServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.ASYNC) {
                response.getOutputStream().print("Dispatched back to ForwardingServlet");
            } else {
                request.getRequestDispatcher("/dispatchingServlet").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }
}

