/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComplianceViolations2616Test {
    private static Server server;
    private static LocalConnector connector;

    @BeforeClass
    public static void startServer() throws Exception {
        server = new Server();
        HttpConfiguration config = new HttpConfiguration();
        config.setSendServerVersion(false);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(config, HttpCompliance.RFC2616);
        httpConnectionFactory.setRecordHttpComplianceViolations(true);
        connector = new LocalConnector(server, null, null, null, -1, new ConnectionFactory[]{httpConnectionFactory});
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.setWelcomeFiles(new String[]{"index.html", "index.jsp", "index.htm"});
        context.addServlet(DumpRequestHeadersServlet.class, "/dump/*");
        context.addFilter(ReportViolationsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        server.setHandler((Handler)context);
        server.addConnector((Connector)connector);
        server.start();
    }

    @AfterClass
    public static void stopServer() throws Exception {
        server.stop();
        server.join();
    }

    @Test
    public void testNoColonHeader_Middle() throws Exception {
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /dump/ HTTP/1.1\r\n");
        req1.append("Name\r\n");
        req1.append("Host: local\r\n");
        req1.append("Accept: */*\r\n");
        req1.append("Connection: close\r\n");
        req1.append("\r\n");
        String response = connector.getResponses(req1.toString());
        Assert.assertThat((String)"Response status", (Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((String)"Response headers", (Object)response, (Matcher)Matchers.containsString((String)"X-Http-Violation-0: RFC2616<RFC7230: name only header"));
        Assert.assertThat((String)"Response body", (Object)response, (Matcher)Matchers.containsString((String)"[Name] = []"));
    }

    @Test
    public void testNoColonHeader_End() throws Exception {
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /dump/ HTTP/1.1\r\n");
        req1.append("Host: local\r\n");
        req1.append("Connection: close\r\n");
        req1.append("Accept: */*\r\n");
        req1.append("Name\r\n");
        req1.append("\r\n");
        String response = connector.getResponses(req1.toString());
        Assert.assertThat((String)"Response status", (Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
        Assert.assertThat((String)"Response headers", (Object)response, (Matcher)Matchers.containsString((String)"X-Http-Violation-0: RFC2616<RFC7230: name only header"));
        Assert.assertThat((String)"Response body", (Object)response, (Matcher)Matchers.containsString((String)"[Name] = []"));
    }

    @Test
    public void testFoldedHeader() throws Exception {
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /dump/ HTTP/1.1\r\n");
        req1.append("Host: local\r\n");
        req1.append("Name: Some\r\n");
        req1.append(" Value\r\n");
        req1.append("Connection: close\r\n");
        req1.append("Accept: */*\r\n");
        req1.append("\r\n");
        String response = connector.getResponses(req1.toString());
        Assert.assertThat((String)"Response status", (Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
        Assert.assertThat((String)"Response headers", (Object)response, (Matcher)Matchers.containsString((String)"X-Http-Violation-0: RFC2616<RFC7230: header folding"));
        Assert.assertThat((String)"Response body", (Object)response, (Matcher)Matchers.containsString((String)"[Name] = [Some Value]"));
    }

    public static class DumpRequestHeadersServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            PrintWriter out = resp.getWriter();
            ArrayList headerNames = new ArrayList();
            headerNames.addAll(Collections.list(req.getHeaderNames()));
            Collections.sort(headerNames);
            for (String name : headerNames) {
                out.printf("[%s] = [%s]%n", name, req.getHeader(name));
            }
        }
    }

    public static class ReportViolationsFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            List violations;
            if (request instanceof HttpServletRequest && (violations = (List)request.getAttribute("org.eclipse.jetty.http.compliance.violations")) != null) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                int i = 0;
                for (String violation : violations) {
                    httpResponse.setHeader("X-Http-Violation-" + i++, violation);
                }
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

