/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AsyncListenerTest {
    private QueuedThreadPool threadPool;
    private Server server;
    private LocalConnector connector;
    private String servletPath;

    private void start(HttpServlet servlet) throws Exception {
        this.server = this.threadPool == null ? new Server() : new Server((ThreadPool)this.threadPool);
        this.connector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        this.servletPath = "/async_listener";
        context.addServlet(holder, this.servletPath + "/*");
        this.server.setHandler((Handler)context);
        this.server.start();
    }

    @After
    public void dispose() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testOnTimeoutCalledByPooledThread() throws Exception {
        final String threadNamePrefix = "async_listener";
        this.threadPool = new QueuedThreadPool();
        this.threadPool.setName(threadNamePrefix);
        this.start(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(1000L);
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onTimeout(AsyncEvent event) throws IOException {
                        if (Thread.currentThread().getName().startsWith(threadNamePrefix)) {
                            response.setStatus(200);
                        } else {
                            response.setStatus(500);
                        }
                        asyncContext.complete();
                    }
                });
            }
        });
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(this.newRequest("")));
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testOnErrorCalledForExceptionAfterStartAsync() throws Exception {
        final RuntimeException exception = new RuntimeException();
        this.start(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync();
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onError(AsyncEvent event) throws IOException {
                        if (exception == event.getThrowable()) {
                            response.setStatus(200);
                        } else {
                            response.setStatus(500);
                        }
                        asyncContext.complete();
                    }
                });
                throw exception;
            }
        });
        try (StacklessLogging suppressor = new StacklessLogging(new Class[]{HttpChannel.class});){
            HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(this.newRequest("")));
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
    }

    @Test
    public void testOnErrorCalledForExceptionThrownByOnTimeout() throws Exception {
        final RuntimeException exception = new RuntimeException();
        this.start(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(1000L);
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onTimeout(AsyncEvent event) throws IOException {
                        throw exception;
                    }

                    @Override
                    public void onError(AsyncEvent event) throws IOException {
                        if (exception == event.getThrowable()) {
                            response.setStatus(200);
                        } else {
                            response.setStatus(500);
                        }
                        asyncContext.complete();
                    }
                });
            }
        });
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(this.newRequest("")));
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testOnErrorNotCalledForExceptionThrownByOnComplete() throws Exception {
        final CountDownLatch errorLatch = new CountDownLatch(1);
        this.start(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onComplete(AsyncEvent event) throws IOException {
                        throw new Error();
                    }

                    @Override
                    public void onError(AsyncEvent event) throws IOException {
                        errorLatch.countDown();
                    }
                });
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        response.setStatus(200);
                        asyncContext.complete();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }).start();
            }
        });
        try (StacklessLogging suppressor = new StacklessLogging(new Class[]{HttpChannelState.class});){
            HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(this.newRequest("")));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertFalse((boolean)errorLatch.await(1L, TimeUnit.SECONDS));
        }
    }

    private String newRequest(String pathInfo) {
        return "GET " + this.servletPath + pathInfo + " HTTP/1.1\r\n" + "Host: localhost\r\n" + "\r\n";
    }

    private static class AsyncListenerAdapter
    implements AsyncListener {
        private AsyncListenerAdapter() {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }
}

