/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DispatcherForwardTest {
    private Server server;
    private LocalConnector connector;
    private HttpServlet servlet1;
    private HttpServlet servlet2;
    private List<Exception> failures = new ArrayList<Exception>();

    public void prepare() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/");
        context.addServlet(new ServletHolder((Servlet)this.servlet1), "/one");
        context.addServlet(new ServletHolder((Servlet)this.servlet2), "/two");
        this.server.start();
    }

    @After
    public void dispose() throws Exception {
        Iterator<Exception> i$ = this.failures.iterator();
        if (i$.hasNext()) {
            Exception failure = i$.next();
            throw failure;
        }
        this.server.stop();
    }

    private <S> void checkThat(S item, Matcher<S> matcher) {
        if (!matcher.matches(item)) {
            this.failures.add(new Exception());
        }
    }

    @Test
    public void testQueryRetainedByForwardWithoutQuery() throws Exception {
        String query1 = "a=1";
        this.servlet1 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
            }
        };
        this.prepare();
        String request = "GET /one?a=1 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryReplacedByForwardWithQuery() throws Exception {
        String query1 = "a=1&b=2";
        String query2 = "a=3";
        String query3 = "a=3&b=2";
        this.servlet1 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1&b=2", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two?a=3").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1&b=2", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=3&b=2", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("3", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
            }
        };
        this.prepare();
        String request = "GET /one?a=1&b=2 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryMergedByForwardWithQuery() throws Exception {
        String query1 = "a=1";
        String query2 = "b=2";
        String query3 = "b=2&a=1";
        this.servlet1 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two?b=2").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("b=2&a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
            }
        };
        this.prepare();
        String request = "GET /one?a=1 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormByForwardWithoutQuery() throws Exception {
        String query1 = "a=1";
        String form = "a=2";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(2, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"1", "2"}));
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(2, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"1", "2"}));
            }
        };
        this.prepare();
        String request = "POST /one?a=1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "a=2".length() + "\r\n" + "Connection: close\r\n" + "\r\n" + "a=2";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormReplacedByForwardWithQuery() throws Exception {
        String query1 = "a=1";
        String query2 = "a=3";
        String form = "a=2";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two?a=3").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(2, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"1", "2"}));
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=3", Matchers.equalTo((Object)req.getQueryString()));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(3, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"3", "2", "1"}));
            }
        };
        this.prepare();
        String request = "POST /one?a=1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "a=2".length() + "\r\n" + "Connection: close\r\n" + "\r\n" + "a=2";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormMergedByForwardWithQuery() throws Exception {
        String query1 = "a=1";
        String query2 = "c=3";
        String query3 = "c=3&a=1";
        String form = "b=2";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two?c=3").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("c=3&a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
                DispatcherForwardTest.this.checkThat("3", Matchers.equalTo((Object)req.getParameter("c")));
            }
        };
        this.prepare();
        String request = "POST /one?a=1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "b=2".length() + "\r\n" + "Connection: close\r\n" + "\r\n" + "b=2";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormBeforeAndAfterForward() throws Exception {
        String query1 = "a=1";
        String query2 = "c=3";
        String query3 = "c=3&a=1";
        String form = "b=2";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
                req.getRequestDispatcher("/two?c=3").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("c=3&a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat("1", Matchers.equalTo((Object)req.getParameter("a")));
                DispatcherForwardTest.this.checkThat("2", Matchers.equalTo((Object)req.getParameter("b")));
                DispatcherForwardTest.this.checkThat("3", Matchers.equalTo((Object)req.getParameter("c")));
            }
        };
        this.prepare();
        String request = "POST /one?a=1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "b=2".length() + "\r\n" + "Connection: close\r\n" + "\r\n" + "b=2";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testContentCanBeReadViaInputStreamAfterForwardWithoutQuery() throws Exception {
        String query1 = "a=1";
        String form = "c=3";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                ServletInputStream input = req.getInputStream();
                for (int i = 0; i < "c=3".length(); ++i) {
                    DispatcherForwardTest.this.checkThat("c=3".charAt(i) & 0xFFFF, Matchers.equalTo((Object)input.read()));
                }
            }
        };
        this.prepare();
        String request = "POST /one?a=1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "c=3".length() + "\r\n" + "Connection: close\r\n" + "\r\n" + "c=3";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testContentCanBeReadViaInputStreamAfterForwardWithQuery() throws Exception {
        String query1 = "a=1";
        String query2 = "b=2";
        String query3 = "b=2&a=1";
        String form = "c=3";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                req.getRequestDispatcher("/two?b=2").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat("a=1", Matchers.equalTo((Object)req.getQueryString()));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat("b=2&a=1", Matchers.equalTo((Object)req.getQueryString()));
                ServletInputStream input = req.getInputStream();
                for (int i = 0; i < "c=3".length(); ++i) {
                    DispatcherForwardTest.this.checkThat("c=3".charAt(i) & 0xFFFF, Matchers.equalTo((Object)input.read()));
                }
                DispatcherForwardTest.this.checkThat(-1, Matchers.equalTo((Object)input.read()));
            }
        };
        this.prepare();
        String request = "POST /one?a=1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "c=3".length() + "\r\n" + "Connection: close\r\n" + "\r\n" + "c=3";
        String response = this.connector.getResponses(request);
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }
}

