/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandlerContainer
extends AbstractHandler
implements HandlerContainer {
    @Override
    public Handler[] getChildHandlers() {
        Object list = this.expandChildren(null, null);
        return (Handler[])LazyList.toArray((Object)list, Handler.class);
    }

    @Override
    public Handler[] getChildHandlersByClass(Class<?> byclass) {
        Object list = this.expandChildren(null, byclass);
        return (Handler[])LazyList.toArray((Object)list, byclass);
    }

    @Override
    public <T extends Handler> T getChildHandlerByClass(Class<T> byclass) {
        Object list = this.expandChildren(null, byclass);
        if (list == null) {
            return null;
        }
        return (T)((Handler)LazyList.get((Object)list, (int)0));
    }

    protected Object expandChildren(Object list, Class<?> byClass) {
        return list;
    }

    protected Object expandHandler(Handler handler, Object list, Class<Handler> byClass) {
        if (handler == null) {
            return list;
        }
        if (byClass == null || byClass.isAssignableFrom(handler.getClass())) {
            list = LazyList.add((Object)list, (Object)handler);
        }
        if (handler instanceof AbstractHandlerContainer) {
            list = ((AbstractHandlerContainer)handler).expandChildren(list, byClass);
        } else if (handler instanceof HandlerContainer) {
            HandlerContainer container = (HandlerContainer)((Object)handler);
            Object[] handlers = byClass == null ? container.getChildHandlers() : container.getChildHandlersByClass(byClass);
            list = LazyList.addArray((Object)list, (Object[])handlers);
        }
        return list;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        AbstractHandlerContainer.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])this.getHandlers()), this.getBeans()});
    }
}

