/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class PropertyUserStore
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(PropertyUserStore.class);
    private String _config;
    private Resource _configResource;
    private Scanner _scanner;
    private int _refreshInterval = 0;
    private boolean _firstLoad = true;
    private final List<String> _knownUsers = new ArrayList<String>();
    private List<UserListener> _listeners;

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String config) {
        this._config = config;
    }

    public Resource getConfigResource() throws IOException {
        if (this._configResource == null) {
            this._configResource = Resource.newResource((String)this._config);
        }
        return this._configResource;
    }

    public void setRefreshInterval(int msec) {
        this._refreshInterval = msec;
    }

    public int getRefreshInterval() {
        return this._refreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers() throws IOException {
        if (this._config == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Load " + (Object)((Object)this) + " from " + this._config, new Object[0]);
        }
        Properties properties = new Properties();
        if (this.getConfigResource().exists()) {
            properties.load(this.getConfigResource().getInputStream());
        }
        HashSet<String> known = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String username = ((String)entry.getKey()).trim();
            String credentials = ((String)entry.getValue()).trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            String[] roleArray = IdentityService.NO_ROLES;
            if (roles != null && roles.length() > 0) {
                roleArray = roles.split(",");
            }
            known.add(username);
            this.notifyUpdate(username, Credential.getCredential((String)credentials), roleArray);
        }
        List<String> list = this._knownUsers;
        synchronized (list) {
            if (!this._firstLoad) {
                for (String user : this._knownUsers) {
                    if (known.contains(user)) continue;
                    this.notifyRemove(user);
                }
            }
            this._knownUsers.clear();
            this._knownUsers.addAll(known);
        }
        this._firstLoad = false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getRefreshInterval() > 0) {
            this._scanner = new Scanner();
            this._scanner.setScanInterval(this.getRefreshInterval());
            ArrayList<File> dirList = new ArrayList<File>(1);
            dirList.add(this.getConfigResource().getFile().getParentFile());
            this._scanner.setScanDirs(dirList);
            this._scanner.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    try {
                        if (f.compareTo(PropertyUserStore.this.getConfigResource().getFile()) == 0) {
                            return true;
                        }
                    }
                    catch (IOException e) {
                        return false;
                    }
                    return false;
                }
            });
            this._scanner.addListener((Scanner.Listener)new Scanner.BulkListener(){

                public void filesChanged(List filenames) throws Exception {
                    if (filenames == null) {
                        return;
                    }
                    if (filenames.isEmpty()) {
                        return;
                    }
                    if (filenames.size() == 1 && filenames.get(0).equals(PropertyUserStore.this.getConfigResource().getFile().getAbsolutePath())) {
                        PropertyUserStore.this.loadUsers();
                    }
                }

                public String toString() {
                    return "PropertyUserStore$Scanner";
                }
            });
            this._scanner.setReportExistingFilesOnStartup(true);
            this._scanner.setRecursive(false);
            this._scanner.start();
        } else {
            this.loadUsers();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._scanner != null) {
            this._scanner.stop();
        }
        this._scanner = null;
    }

    private void notifyUpdate(String username, Credential credential, String[] roleArray) {
        if (this._listeners != null) {
            Iterator<UserListener> i = this._listeners.iterator();
            while (i.hasNext()) {
                i.next().update(username, credential, roleArray);
            }
        }
    }

    private void notifyRemove(String username) {
        if (this._listeners != null) {
            Iterator<UserListener> i = this._listeners.iterator();
            while (i.hasNext()) {
                i.next().remove(username);
            }
        }
    }

    public void registerUserListener(UserListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<UserListener>();
        }
        this._listeners.add(listener);
    }

    public static interface UserListener {
        public void update(String var1, Credential var2, String[] var3);

        public void remove(String var1);
    }
}

