/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

abstract class MethodBasedCondition<A extends Annotation>
implements ExecutionCondition {
    private final Class<A> annotationType;
    private final Function<A, String> methodName;
    private final Function<A, String> customDisabledReason;

    MethodBasedCondition(Class<A> annotationType, Function<A, String> methodName, Function<A, String> customDisabledReason) {
        this.annotationType = annotationType;
        this.methodName = methodName;
        this.customDisabledReason = customDisabledReason;
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<A> annotation = AnnotationUtils.findAnnotation(context.getElement(), this.annotationType);
        return annotation.map(this.methodName).map(methodName -> this.getConditionMethod((String)methodName, context)).map(method -> this.invokeConditionMethod((Method)method, context)).map(methodResult -> this.buildConditionEvaluationResult((boolean)methodResult, (A)((Annotation)annotation.get()))).orElseGet(this::enabledByDefault);
    }

    private Method getConditionMethod(String fullyQualifiedMethodName, ExtensionContext context) {
        if (!fullyQualifiedMethodName.contains("#")) {
            return this.findMethod(context.getRequiredTestClass(), fullyQualifiedMethodName);
        }
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        Class<?> clazz = ReflectionUtils.tryToLoadClass(className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
        return this.findMethod(clazz, methodName);
    }

    private Method findMethod(Class<?> clazz, String methodName) {
        return ReflectionUtils.findMethod(clazz, methodName, new Class[0]).orElseGet(() -> ReflectionUtils.getRequiredMethod(clazz, methodName, ExtensionContext.class));
    }

    private boolean invokeConditionMethod(Method method, ExtensionContext context) {
        Preconditions.condition(method.getReturnType() == Boolean.TYPE, () -> String.format("Method [%s] should return a boolean", method.getName()));
        Preconditions.condition(this.acceptsExtensionContextArgument(method), () -> String.format("Method [%s] should accept either an ExtensionContext or no arguments", method.getName()));
        Object testInstance = context.getTestInstance().orElse(null);
        if (method.getParameterCount() == 0) {
            return (Boolean)ReflectionUtils.invokeMethod(method, testInstance, new Object[0]);
        }
        return (Boolean)ReflectionUtils.invokeMethod(method, testInstance, context);
    }

    private boolean acceptsExtensionContextArgument(Method method) {
        switch (method.getParameterCount()) {
            case 0: {
                return true;
            }
            case 1: {
                return method.getParameterTypes()[0] == ExtensionContext.class;
            }
        }
        return false;
    }

    private ConditionEvaluationResult buildConditionEvaluationResult(boolean methodResult, A annotation) {
        String defaultReason = String.format("Condition provided in @%s evaluates to %s", this.annotationType.getSimpleName(), methodResult);
        if (this.isEnabled(methodResult)) {
            return ConditionEvaluationResult.enabled(defaultReason);
        }
        String customReason = this.customDisabledReason.apply(annotation);
        if (customReason.isEmpty()) {
            return ConditionEvaluationResult.disabled(defaultReason);
        }
        return ConditionEvaluationResult.disabled(customReason);
    }

    protected abstract boolean isEnabled(boolean var1);

    private ConditionEvaluationResult enabledByDefault() {
        return ConditionEvaluationResult.enabled(String.format("@%s is not present", this.annotationType.getSimpleName()));
    }
}

