/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.CookieStore;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class ProxyServlet
extends HttpServlet {
    protected static final String ASYNC_CONTEXT = ProxyServlet.class.getName() + ".asyncContext";
    private static final Set<String> HOP_HEADERS = new HashSet<String>();
    private final Set<String> _whiteList = new HashSet<String>();
    private final Set<String> _blackList = new HashSet<String>();
    protected Logger _log;
    private String _hostHeader;
    private String _viaHost;
    private HttpClient _client;
    private long _timeout;

    public void init() throws ServletException {
        this._log = this.createLogger();
        ServletConfig config = this.getServletConfig();
        this._hostHeader = config.getInitParameter("hostHeader");
        this._viaHost = config.getInitParameter("viaHost");
        if (this._viaHost == null) {
            this._viaHost = ProxyServlet.viaHost();
        }
        try {
            String blackList;
            this._client = this.createHttpClient();
            this.getServletContext().setAttribute(config.getServletName() + ".HttpClient", (Object)this._client);
            String whiteList = config.getInitParameter("whiteList");
            if (whiteList != null) {
                this.getWhiteListHosts().addAll(this.parseList(whiteList));
            }
            if ((blackList = config.getInitParameter("blackList")) != null) {
                this.getBlackListHosts().addAll(this.parseList(blackList));
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public Set<String> getWhiteListHosts() {
        return this._whiteList;
    }

    public Set<String> getBlackListHosts() {
        return this._blackList;
    }

    protected static String viaHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            return "localhost";
        }
    }

    protected Logger createLogger() {
        String name = this.getServletConfig().getServletName();
        name = name.replace('-', '.');
        return Log.getLogger((String)name);
    }

    public void destroy() {
        try {
            this._client.stop();
        }
        catch (Exception x) {
            this._log.debug((Throwable)x);
        }
    }

    protected HttpClient createHttpClient() throws ServletException {
        ServletConfig config = this.getServletConfig();
        HttpClient client = this.newHttpClient();
        client.setFollowRedirects(false);
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        String value = config.getInitParameter("maxThreads");
        if (value == null) {
            value = "256";
        }
        QueuedThreadPool executor = new QueuedThreadPool(Integer.parseInt(value));
        String servletName = config.getServletName();
        int dot = servletName.lastIndexOf(46);
        if (dot >= 0) {
            servletName = servletName.substring(dot + 1);
        }
        executor.setName(servletName);
        client.setExecutor((Executor)executor);
        value = config.getInitParameter("maxConnections");
        if (value == null) {
            value = "32768";
        }
        client.setMaxConnectionsPerDestination(Integer.parseInt(value));
        value = config.getInitParameter("idleTimeout");
        if (value == null) {
            value = "30000";
        }
        client.setIdleTimeout(Long.parseLong(value));
        value = config.getInitParameter("timeout");
        if (value == null) {
            value = "60000";
        }
        this._timeout = Long.parseLong(value);
        value = config.getInitParameter("requestBufferSize");
        if (value != null) {
            client.setRequestBufferSize(Integer.parseInt(value));
        }
        if ((value = config.getInitParameter("responseBufferSize")) != null) {
            client.setResponseBufferSize(Integer.parseInt(value));
        }
        try {
            client.start();
            client.getContentDecoderFactories().clear();
            return client;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected HttpClient newHttpClient() {
        return new HttpClient();
    }

    private Set<String> parseList(String list) {
        String[] hosts;
        HashSet<String> result = new HashSet<String>();
        for (String host : hosts = list.split(",")) {
            if ((host = host.trim()).length() == 0) continue;
            result.add(host);
        }
        return result;
    }

    public boolean validateDestination(String host, int port) {
        String hostPort = host + ":" + port;
        if (!this._whiteList.isEmpty() && !this._whiteList.contains(hostPort)) {
            this._log.debug("Host {}:{} not whitelisted", new Object[]{host, port});
            return false;
        }
        if (!this._blackList.isEmpty() && this._blackList.contains(hostPort)) {
            this._log.debug("Host {}:{} blacklisted", new Object[]{host, port});
            return false;
        }
        return true;
    }

    protected void service(final HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final int requestId = this.getRequestId(request);
        URI rewrittenURI = this.rewriteURI(request);
        if (this._log.isDebugEnabled()) {
            StringBuffer uri = request.getRequestURL();
            if (request.getQueryString() != null) {
                uri.append("?").append(request.getQueryString());
            }
            this._log.debug("{} rewriting: {} -> {}", new Object[]{requestId, uri, rewrittenURI});
        }
        if (rewrittenURI == null) {
            response.sendError(403);
            return;
        }
        Request proxyRequest = this._client.newRequest(rewrittenURI).method(HttpMethod.fromString((String)request.getMethod())).version(HttpVersion.fromString((String)request.getProtocol()));
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
            if (HOP_HEADERS.contains(lowerHeaderName) || this._hostHeader != null && lowerHeaderName.equals("host")) continue;
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                if (headerValue == null) continue;
                proxyRequest.header(headerName, headerValue);
            }
        }
        if (this._hostHeader != null) {
            proxyRequest.header(HttpHeader.HOST, this._hostHeader);
        }
        proxyRequest.header(HttpHeader.VIA, "http/1.1 " + this._viaHost);
        proxyRequest.header(HttpHeader.X_FORWARDED_FOR, request.getRemoteAddr());
        proxyRequest.header(HttpHeader.X_FORWARDED_PROTO, request.getScheme());
        proxyRequest.header(HttpHeader.X_FORWARDED_HOST, request.getHeader(HttpHeader.HOST.asString()));
        proxyRequest.header(HttpHeader.X_FORWARDED_SERVER, request.getLocalName());
        proxyRequest.content((ContentProvider)new InputStreamContentProvider((InputStream)request.getInputStream()){

            public long getLength() {
                return request.getContentLength();
            }

            protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
                ProxyServlet.this._log.debug("{} proxying content to upstream: {} bytes", new Object[]{requestId, length});
                return super.onRead(buffer, offset, length);
            }
        });
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        request.setAttribute(ASYNC_CONTEXT, (Object)asyncContext);
        this.customizeProxyRequest(proxyRequest, request);
        if (this._log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(request.getMethod());
            builder.append(" ").append(request.getRequestURI());
            String query = request.getQueryString();
            if (query != null) {
                builder.append("?").append(query);
            }
            builder.append(" ").append(request.getProtocol()).append("\r\n");
            Enumeration headerNames2 = request.getHeaderNames();
            while (headerNames2.hasMoreElements()) {
                String headerName = (String)headerNames2.nextElement();
                builder.append(headerName).append(": ");
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    if (headerValue != null) {
                        builder.append(headerValue);
                    }
                    if (!headerValues.hasMoreElements()) continue;
                    builder.append(",");
                }
                builder.append("\r\n");
            }
            builder.append("\r\n");
            this._log.debug("{} proxying to upstream:{}{}{}{}", new Object[]{requestId, System.lineSeparator(), builder, proxyRequest, System.lineSeparator(), proxyRequest.getHeaders().toString().trim()});
        }
        proxyRequest.timeout(this.getTimeout(), TimeUnit.MILLISECONDS);
        proxyRequest.send((Response.CompleteListener)new ProxyResponseListener(request, response));
    }

    protected void onResponseHeaders(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        for (HttpField field : proxyResponse.getHeaders()) {
            String newHeaderValue;
            String headerName = field.getName();
            String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
            if (HOP_HEADERS.contains(lowerHeaderName) || (newHeaderValue = this.filterResponseHeader(request, headerName, field.getValue())) == null || newHeaderValue.trim().length() == 0) continue;
            response.addHeader(headerName, newHeaderValue);
        }
    }

    protected void onResponseContent(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length) throws IOException {
        response.getOutputStream().write(buffer, offset, length);
        this._log.debug("{} proxying content to downstream: {} bytes", new Object[]{this.getRequestId(request), length});
    }

    protected void onResponseSuccess(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        AsyncContext asyncContext = (AsyncContext)request.getAttribute(ASYNC_CONTEXT);
        asyncContext.complete();
        this._log.debug("{} proxying successful", new Object[]{this.getRequestId(request)});
    }

    protected void onResponseFailure(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, Throwable failure) {
        this._log.debug(this.getRequestId(request) + " proxying failed", failure);
        if (!response.isCommitted()) {
            if (failure instanceof TimeoutException) {
                response.setStatus(504);
            } else {
                response.setStatus(502);
            }
        }
        AsyncContext asyncContext = (AsyncContext)request.getAttribute(ASYNC_CONTEXT);
        asyncContext.complete();
    }

    protected int getRequestId(HttpServletRequest request) {
        return System.identityHashCode(request);
    }

    protected URI rewriteURI(HttpServletRequest request) {
        if (!this.validateDestination(request.getServerName(), request.getServerPort())) {
            return null;
        }
        StringBuffer uri = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null) {
            uri.append("?").append(query);
        }
        return URI.create(uri.toString());
    }

    protected void customizeProxyRequest(Request proxyRequest, HttpServletRequest request) {
    }

    protected String filterResponseHeader(HttpServletRequest request, String headerName, String headerValue) {
        return headerValue;
    }

    static {
        HOP_HEADERS.add("proxy-connection");
        HOP_HEADERS.add("connection");
        HOP_HEADERS.add("keep-alive");
        HOP_HEADERS.add("transfer-encoding");
        HOP_HEADERS.add("te");
        HOP_HEADERS.add("trailer");
        HOP_HEADERS.add("proxy-authorization");
        HOP_HEADERS.add("proxy-authenticate");
        HOP_HEADERS.add("upgrade");
    }

    private class ProxyResponseListener
    extends Response.Listener.Empty {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        public ProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public void onBegin(Response proxyResponse) {
            this.response.setStatus(proxyResponse.getStatus());
        }

        public void onHeaders(Response proxyResponse) {
            ProxyServlet.this.onResponseHeaders(this.request, this.response, proxyResponse);
            if (ProxyServlet.this._log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder("\r\n");
                builder.append(this.request.getProtocol()).append(" ").append(this.response.getStatus()).append(" ").append(proxyResponse.getReason()).append("\r\n");
                for (String headerName : this.response.getHeaderNames()) {
                    builder.append(headerName).append(": ");
                    Iterator headerValues = this.response.getHeaders(headerName).iterator();
                    while (headerValues.hasNext()) {
                        String headerValue = (String)headerValues.next();
                        if (headerValue != null) {
                            builder.append(headerValue);
                        }
                        if (!headerValues.hasNext()) continue;
                        builder.append(",");
                    }
                    builder.append("\r\n");
                }
                ProxyServlet.this._log.debug("{} proxying to downstream:{}{}{}{}{}", new Object[]{ProxyServlet.this.getRequestId(this.request), System.lineSeparator(), proxyResponse, System.lineSeparator(), proxyResponse.getHeaders().toString().trim(), System.lineSeparator(), builder});
            }
        }

        public void onContent(Response proxyResponse, ByteBuffer content) {
            int offset;
            byte[] buffer;
            int length = content.remaining();
            if (content.hasArray()) {
                buffer = content.array();
                offset = content.arrayOffset();
            } else {
                buffer = new byte[length];
                content.get(buffer);
                offset = 0;
            }
            try {
                ProxyServlet.this.onResponseContent(this.request, this.response, proxyResponse, buffer, offset, length);
            }
            catch (IOException x) {
                proxyResponse.abort((Throwable)x);
            }
        }

        public void onSuccess(Response proxyResponse) {
            ProxyServlet.this.onResponseSuccess(this.request, this.response, proxyResponse);
        }

        public void onFailure(Response proxyResponse, Throwable failure) {
            ProxyServlet.this.onResponseFailure(this.request, this.response, proxyResponse, failure);
        }

        public void onComplete(Result result) {
            ProxyServlet.this._log.debug("{} proxying complete", new Object[]{ProxyServlet.this.getRequestId(this.request)});
        }
    }

    public static class Transparent
    extends ProxyServlet {
        private String _proxyTo;
        private String _prefix;

        public Transparent() {
        }

        public Transparent(String proxyTo, String prefix) {
            this._proxyTo = URI.create(proxyTo).normalize().toString();
            this._prefix = URI.create(prefix).normalize().toString();
        }

        @Override
        public void init() throws ServletException {
            super.init();
            ServletConfig config = this.getServletConfig();
            String prefix = config.getInitParameter("prefix");
            this._prefix = prefix == null ? this._prefix : prefix;
            String contextPath = this.getServletContext().getContextPath();
            this._prefix = this._prefix == null ? contextPath : contextPath + this._prefix;
            String proxyTo = config.getInitParameter("proxyTo");
            String string = this._proxyTo = proxyTo == null ? this._proxyTo : proxyTo;
            if (this._proxyTo == null) {
                throw new UnavailableException("Init parameter 'proxyTo' is required.");
            }
            if (!this._prefix.startsWith("/")) {
                throw new UnavailableException("Init parameter 'prefix' parameter must start with a '/'.");
            }
            this._log.debug(config.getServletName() + " @ " + this._prefix + " to " + this._proxyTo, new Object[0]);
        }

        @Override
        protected URI rewriteURI(HttpServletRequest request) {
            String path = request.getRequestURI();
            if (!path.startsWith(this._prefix)) {
                return null;
            }
            URI rewrittenURI = URI.create(this._proxyTo + path.substring(this._prefix.length())).normalize();
            if (!this.validateDestination(rewrittenURI.getHost(), rewrittenURI.getPort())) {
                return null;
            }
            return rewrittenURI;
        }
    }
}

