/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;

public class MavenWebInfConfiguration
extends WebInfConfiguration {
    private static final Logger LOG = Log.getLogger(MavenWebInfConfiguration.class);

    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up classpath ...", new Object[0]);
            }
            Iterator<File> itor = jwac.getClassPathFiles().iterator();
            while (itor.hasNext()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(itor.next().getCanonicalPath());
            }
        }
        super.configure(context);
        String[] existingServerClasses = context.getServerClasses();
        String[] newServerClasses = new String[4 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "org.apache.maven.";
        newServerClasses[1] = "org.codehaus.plexus.";
        newServerClasses[2] = "javax.enterprise.";
        newServerClasses[3] = "javax.decorator.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 4, existingServerClasses.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server classes:", new Object[0]);
            for (int i = 0; i < newServerClasses.length; ++i) {
                LOG.debug(newServerClasses[i], new Object[0]);
            }
        }
        context.setServerClasses(newServerClasses);
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List superList;
        ArrayList<Resource> list = new ArrayList<Resource>();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        List<File> files = jwac.getWebInfLib();
        if (files != null) {
            files.forEach(file -> {
                if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || file.isDirectory()) {
                    try {
                        LOG.debug(" add  resource to resources to examine {}", new Object[]{file});
                        list.add(Resource.newResource((URI)file.toURI()));
                    }
                    catch (Exception e) {
                        LOG.warn("Bad url ", (Throwable)e);
                    }
                }
            });
        }
        if ((superList = super.findJars(context)) != null) {
            list.addAll(superList);
        }
        return list;
    }

    protected List<Resource> findClassDirs(WebAppContext context) throws Exception {
        List classesDirs;
        ArrayList<Resource> list = new ArrayList<Resource>();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        List<File> files = jwac.getWebInfClasses();
        if (files != null) {
            files.forEach(file -> {
                if (file.exists() && file.isDirectory()) {
                    try {
                        list.add(Resource.newResource((URI)file.toURI()));
                    }
                    catch (Exception e) {
                        LOG.warn("Bad url ", (Throwable)e);
                    }
                }
            });
        }
        if ((classesDirs = super.findClassDirs(context)) != null) {
            list.addAll(classesDirs);
        }
        return list;
    }
}

