/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.QuotedQualityCSV;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class QuotedQualityCSVTest {
    private static final String[] preferBrotli = new String[]{"br", "gzip"};
    private static final String[] preferGzip = new String[]{"gzip", "br"};
    private static final String[] noFormats = new String[0];

    @Test
    public void test7231_5_3_2_example1() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue(" audio/*; q=0.2, audio/basic");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"audio/basic", "audio/*"}));
    }

    @Test
    public void test7231_5_3_2_example2() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("text/plain; q=0.5, text/html,");
        values.addValue("text/x-dvi; q=0.8, text/x-c");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/html", "text/x-c", "text/x-dvi", "text/plain"}));
    }

    @Test
    public void test7231_5_3_2_example3() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("text/*, text/plain, text/plain;format=flowed, */*");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/*", "text/plain", "text/plain;format=flowed", "*/*"}));
    }

    @Test
    public void test7231_5_3_2_example3_most_specific() {
        QuotedQualityCSV values = new QuotedQualityCSV(QuotedQualityCSV.MOST_SPECIFIC);
        values.addValue("text/*, text/plain, text/plain;format=flowed, */*");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/plain;format=flowed", "text/plain", "text/*", "*/*"}));
    }

    @Test
    public void test7231_5_3_2_example4() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("text/*;q=0.3, text/html;q=0.7, text/html;level=1,");
        values.addValue("text/html;level=2;q=0.4, */*;q=0.5");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/html;level=1", "text/html", "*/*", "text/html;level=2", "text/*"}));
    }

    @Test
    public void test7231_5_3_4_example1() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("compress, gzip");
        values.addValue("");
        values.addValue("*");
        values.addValue("compress;q=0.5, gzip;q=1.0");
        values.addValue("gzip;q=1.0, identity; q=0.5, *;q=0");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"compress", "gzip", "*", "gzip", "gzip", "compress", "identity"}));
    }

    @Test
    public void testOWS() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("  value 0.5  ;  p = v  ;  q =0.5  ,  value 1.0 ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 1.0", "value 0.5;p=v"}));
    }

    @Test
    public void testEmpty() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue(",aaaa,  , bbbb ,,cccc,");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"aaaa", "bbbb", "cccc"}));
    }

    @Test
    public void testQuoted() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("  value 0.5  ;  p = \"v  ;  q = \\\"0.5\\\"  ,  value 1.0 \"  ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 0.5;p=\"v  ;  q = \\\"0.5\\\"  ,  value 1.0 \""}));
    }

    @Test
    public void testOpenQuote() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("value;p=\"v");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value;p=\"v"}));
    }

    @Test
    public void testQuotedQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("  value 0.5  ;  p = v  ;  q = \"0.5\"  ,  value 1.0 ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 1.0", "value 0.5;p=v"}));
    }

    @Test
    public void testBadQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("value0.5;p=v;q=0.5,value1.0,valueBad;q=X");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value1.0", "value0.5;p=v"}));
    }

    @Test
    public void testFirefoxContentEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip, deflate, br");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"br", "gzip", "deflate"}));
    }

    @Test
    public void testFirefoxContentEncodingWithGzipPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferGzip);
        values.addValue("gzip, deflate, br");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"gzip", "br", "deflate"}));
    }

    @Test
    public void testFirefoxContentEncodingWithNoPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(noFormats);
        values.addValue("gzip, deflate, br");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"gzip", "deflate", "br"}));
    }

    @Test
    public void testChromeContentEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip, deflate, sdch, br");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"br", "gzip", "deflate", "sdch"}));
    }

    @Test
    public void testComplexEncodingWithGzipPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferGzip);
        values.addValue("gzip;q=0.9, identity;q=0.1, *;q=0.01, deflate;q=0.9, sdch;q=0.7, br;q=0.9");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"gzip", "br", "deflate", "sdch", "identity", "*"}));
    }

    @Test
    public void testComplexEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip;q=0.9, identity;q=0.1, *;q=0, deflate;q=0.9, sdch;q=0.7, br;q=0.99");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"br", "gzip", "deflate", "sdch", "identity"}));
    }

    @Test
    public void testStarEncodingWithGzipPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferGzip);
        values.addValue("br, *");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"*", "br"}));
    }

    @Test
    public void testStarEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip, *");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"*", "gzip"}));
    }

    @Test
    public void testSameQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("one;q=0.5,two;q=0.5,three;q=0.5");
        Assert.assertThat((Object)values.getValues(), (Matcher)Matchers.contains((Object[])new String[]{"one", "two", "three"}));
    }

    @Test
    public void testNoQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("one,two;,three;x=y");
        Assert.assertThat((Object)values.getValues(), (Matcher)Matchers.contains((Object[])new String[]{"one", "two", "three;x=y"}));
    }
}

