/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.QuotedCSV;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class QuotedCSVTest {
    @Test
    public void testOWS() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue("  value 0.5  ;  pqy = vwz  ;  q =0.5  ,  value 1.0 ,  other ; param ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 0.5;pqy=vwz;q=0.5", "value 1.0", "other;param"}));
    }

    @Test
    public void testEmpty() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue(",aaaa,  , bbbb ,,cccc,");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"aaaa", "bbbb", "cccc"}));
    }

    @Test
    public void testQuoted() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue("A;p=\"v\",B,\"C, D\"");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"A;p=\"v\"", "B", "\"C, D\""}));
    }

    @Test
    public void testOpenQuote() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue("value;p=\"v");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value;p=\"v"}));
    }

    @Test
    public void testQuotedNoQuotes() {
        QuotedCSV values = new QuotedCSV(false, new String[0]);
        values.addValue("A;p=\"v\",B,\"C, D\"");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"A;p=v", "B", "C, D"}));
    }

    @Test
    public void testOpenQuoteNoQuotes() {
        QuotedCSV values = new QuotedCSV(false, new String[0]);
        values.addValue("value;p=\"v");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value;p=v"}));
    }

    @Test
    public void testParamsOnly() {
        QuotedCSV values = new QuotedCSV(false, new String[0]);
        values.addValue("for=192.0.2.43, for=\"[2001:db8:cafe::17]\", for=unknown");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"for=192.0.2.43", "for=[2001:db8:cafe::17]", "for=unknown"}));
    }

    @Test
    public void testMutation() {
        QuotedCSV values = new QuotedCSV(false, new String[0]){

            protected void parsedValue(StringBuffer buffer) {
                String s;
                if (buffer.toString().contains("DELETE")) {
                    s = buffer.toString().replace("DELETE", "");
                    buffer.setLength(0);
                    buffer.append(s);
                }
                if (buffer.toString().contains("APPEND")) {
                    s = buffer.toString().replace("APPEND", "Append") + "!";
                    buffer.setLength(0);
                    buffer.append(s);
                }
            }

            protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
                String name;
                String string = name = paramValue > 0 ? buffer.substring(paramName, paramValue - 1) : buffer.substring(paramName);
                if ("IGNORE".equals(name)) {
                    buffer.setLength(paramName - 1);
                }
            }
        };
        values.addValue("normal;param=val, testAPPENDandDELETEvalue ; n=v; IGNORE = this; x=y ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"normal;param=val", "testAppendandvalue!;n=v;x=y"}));
    }

    @Test
    public void testUnQuote() {
        Assert.assertThat((Object)QuotedCSV.unquote((String)""), (Matcher)Matchers.is((Object)""));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\"\""), (Matcher)Matchers.is((Object)""));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"foo"), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\"foo\""), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"f\"o\"o"), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\"\\\"foo\""), (Matcher)Matchers.is((Object)"\"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\\foo"), (Matcher)Matchers.is((Object)"\\foo"));
    }
}

