/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecAssert;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class PathMappingsTest {
    private void assertMatch(PathMappings<String> pathmap, String path, String expectedValue) {
        String msg = String.format(".getMatch(\"%s\")", path);
        MappedResource match = pathmap.getMatch(path);
        MatcherAssert.assertThat((String)msg, (Object)match, (Matcher)Matchers.notNullValue());
        String actualMatch = (String)match.getResource();
        Assertions.assertEquals((Object)expectedValue, (Object)actualMatch, (String)msg);
    }

    public void dumpMappings(PathMappings<String> p) {
        for (MappedResource res : p) {
            System.out.printf("  %s%n", res);
        }
    }

    @Test
    public void testMixedMatchOrder() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        p.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        p.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        p.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        p.put((PathSpec)new RegexPathSpec("^/animal/.*/chat$"), (Object)"animalChat");
        p.put((PathSpec)new RegexPathSpec("^/animal/.*/cam$"), (Object)"animalCam");
        p.put((PathSpec)new RegexPathSpec("^/entrance/cam$"), (Object)"entranceCam");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle", "birds");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/bass/sea", "fishes");
        this.assertMatch((PathMappings<String>)p, "/animal/peccary/javalina/evolution", "animals");
        this.assertMatch((PathMappings<String>)p, "/", "default");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/penguin/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/trout/cam", "animalCam");
        this.assertMatch((PathMappings<String>)p, "/entrance/cam", "entranceCam");
    }

    @Test
    public void testServletMatchDefault() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        p.put((PathSpec)new ServletPathSpec("/*"), (Object)"any");
        this.assertMatch((PathMappings<String>)p, "/abs/path", "any");
        this.assertMatch((PathMappings<String>)p, "/abs/path/xxx", "any");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle/bald", "any");
        this.assertMatch((PathMappings<String>)p, "/", "any");
    }

    @Test
    public void testMixedMatchUriOrder() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        p.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        p.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        p.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        p.put((PathSpec)new UriTemplatePathSpec("/animal/{type}/{name}/chat"), (Object)"animalChat");
        p.put((PathSpec)new UriTemplatePathSpec("/animal/{type}/{name}/cam"), (Object)"animalCam");
        p.put((PathSpec)new UriTemplatePathSpec("/entrance/cam"), (Object)"entranceCam");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle", "birds");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/bass/sea", "fishes");
        this.assertMatch((PathMappings<String>)p, "/animal/peccary/javalina/evolution", "animals");
        this.assertMatch((PathMappings<String>)p, "/", "default");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/penguin/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/trout/cam", "animalCam");
        this.assertMatch((PathMappings<String>)p, "/entrance/cam", "entranceCam");
    }

    @Test
    public void testUriTemplateMatchOrder() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new UriTemplatePathSpec("/a/{var}/c"), (Object)"endpointA");
        p.put((PathSpec)new UriTemplatePathSpec("/a/b/c"), (Object)"endpointB");
        p.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/{var2}"), (Object)"endpointC");
        p.put((PathSpec)new UriTemplatePathSpec("/{var1}/d"), (Object)"endpointD");
        p.put((PathSpec)new UriTemplatePathSpec("/b/{var2}"), (Object)"endpointE");
        this.assertMatch((PathMappings<String>)p, "/a/b/c", "endpointB");
        this.assertMatch((PathMappings<String>)p, "/a/d/c", "endpointA");
        this.assertMatch((PathMappings<String>)p, "/a/x/y", "endpointC");
        this.assertMatch((PathMappings<String>)p, "/b/d", "endpointE");
    }

    @Test
    public void testPathMap() throws Exception {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/abs/path"), (Object)"1");
        p.put((PathSpec)new ServletPathSpec("/abs/path/longer"), (Object)"2");
        p.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"3");
        p.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"4");
        p.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"5");
        p.put((PathSpec)new ServletPathSpec("*.tar.gz"), (Object)"6");
        p.put((PathSpec)new ServletPathSpec("*.gz"), (Object)"7");
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"8");
        p.put((PathSpec)new ServletPathSpec(""), (Object)"10");
        p.put((PathSpec)new ServletPathSpec("/\u20acuro/*"), (Object)"11");
        Assertions.assertEquals((Object)"/Foo/bar", (Object)new ServletPathSpec("/Foo/bar").getPathMatch("/Foo/bar"), (String)"pathMatch exact");
        Assertions.assertEquals((Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo/bar"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo/"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo/bar.ext", (Object)new ServletPathSpec("*.ext").getPathMatch("/Foo/bar.ext"), (String)"pathMatch suffix");
        Assertions.assertEquals((Object)"/Foo/bar.ext", (Object)new ServletPathSpec("/").getPathMatch("/Foo/bar.ext"), (String)"pathMatch default");
        Assertions.assertEquals(null, (Object)new ServletPathSpec("/Foo/bar").getPathInfo("/Foo/bar"), (String)"pathInfo exact");
        Assertions.assertEquals((Object)"/bar", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/bar"), (String)"pathInfo prefix");
        Assertions.assertEquals((Object)"/*", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/*"), (String)"pathInfo prefix");
        Assertions.assertEquals((Object)"/", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/"), (String)"pathInfo prefix");
        Assertions.assertEquals(null, (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo"), (String)"pathInfo prefix");
        Assertions.assertEquals(null, (Object)new ServletPathSpec("*.ext").getPathInfo("/Foo/bar.ext"), (String)"pathInfo suffix");
        Assertions.assertEquals(null, (Object)new ServletPathSpec("/").getPathInfo("/Foo/bar.ext"), (String)"pathInfo default");
        p.put((PathSpec)new ServletPathSpec("/*"), (Object)"0");
        Assertions.assertEquals((Object)"/abs/path", (Object)p.getMatch((String)"/abs/path").getPathSpec().pathSpec, (String)"Match absolute path");
        Assertions.assertEquals((Object)"1", (Object)p.getMatch("/abs/path").getResource(), (String)"Match absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/path/xxx").getResource(), (String)"Mismatch absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/pith").getResource(), (String)"Mismatch absolute path");
        Assertions.assertEquals((Object)"2", (Object)p.getMatch("/abs/path/longer").getResource(), (String)"Match longer absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/path/").getResource(), (String)"Not exact absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/path/xxx").getResource(), (String)"Not exact absolute path");
        Assertions.assertEquals((Object)"3", (Object)p.getMatch("/animal/bird/eagle/bald").getResource(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"4", (Object)p.getMatch("/animal/fish/shark/grey").getResource(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal/insect/bug").getResource(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal").getResource(), (String)"mismatch exact prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal/").getResource(), (String)"mismatch exact prefix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/suffix/path.tar.gz").getResource(), (String)"Match longest suffix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/suffix/path.gz").getResource(), (String)"Match longest suffix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal/path.gz").getResource(), (String)"prefix rather than suffix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/Other/path").getResource(), (String)"default");
        Assertions.assertEquals((Object)"", (Object)new ServletPathSpec("/*").getPathMatch("/xxx/zzz"), (String)"pathMatch /*");
        Assertions.assertEquals((Object)"/xxx/zzz", (Object)new ServletPathSpec("/*").getPathInfo("/xxx/zzz"), (String)"pathInfo /*");
        Assertions.assertTrue((boolean)new ServletPathSpec("/").matches("/anything"), (String)"match /");
        Assertions.assertTrue((boolean)new ServletPathSpec("/*").matches("/anything"), (String)"match /*");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo").matches("/foo"), (String)"match /foo");
        Assertions.assertTrue((!new ServletPathSpec("/foo").matches("/bar") ? 1 : 0) != 0, (String)"!match /foo");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo/*").matches("/foo"), (String)"match /foo/*");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo/*").matches("/foo/"), (String)"match /foo/*");
        Assertions.assertTrue((boolean)new ServletPathSpec("/foo/*").matches("/foo/anything"), (String)"match /foo/*");
        Assertions.assertTrue((!new ServletPathSpec("/foo/*").matches("/bar") ? 1 : 0) != 0, (String)"!match /foo/*");
        Assertions.assertTrue((!new ServletPathSpec("/foo/*").matches("/bar/") ? 1 : 0) != 0, (String)"!match /foo/*");
        Assertions.assertTrue((!new ServletPathSpec("/foo/*").matches("/bar/anything") ? 1 : 0) != 0, (String)"!match /foo/*");
        Assertions.assertTrue((boolean)new ServletPathSpec("*.foo").matches("anything.foo"), (String)"match *.foo");
        Assertions.assertTrue((!new ServletPathSpec("*.foo").matches("anything.bar") ? 1 : 0) != 0, (String)"!match *.foo");
        Assertions.assertEquals((Object)"10", (Object)p.getMatch("/").getResource(), (String)"match / with ''");
        Assertions.assertTrue((boolean)new ServletPathSpec("").matches("/"), (String)"match \"\"");
    }

    @Test
    public void testPathMappingsOnlyMatchOnDirectoryNames() throws Exception {
        ServletPathSpec spec = new ServletPathSpec("/xyz/*");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/123");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/123/");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/123.txt");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123;jessionid=99");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123/");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123/456");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz.123");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz;123");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz?123");
    }

    @Test
    public void testPrecidenceVsOrdering() throws Exception {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/dump/gzip/*"), (Object)"prefix");
        p.put((PathSpec)new ServletPathSpec("*.txt"), (Object)"suffix");
        Assertions.assertEquals(null, (Object)p.getMatch("/foo/bar"));
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something").getResource());
        Assertions.assertEquals((Object)"suffix", (Object)p.getMatch("/foo/something.txt").getResource());
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something.txt").getResource());
        p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("*.txt"), (Object)"suffix");
        p.put((PathSpec)new ServletPathSpec("/dump/gzip/*"), (Object)"prefix");
        Assertions.assertEquals(null, (Object)p.getMatch("/foo/bar"));
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something").getResource());
        Assertions.assertEquals((Object)"suffix", (Object)p.getMatch("/foo/something.txt").getResource());
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something.txt").getResource());
    }

    @ParameterizedTest
    @ValueSource(strings={"*", "/foo/*/bar", "/foo*", "*/foo", "*.foo/*"})
    public void testBadPathSpecs(String str) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ServletPathSpec(str));
    }
}

