/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.toolchain.test.Hex;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={WorkDirExtension.class})
public class MultiPartCaptureTest {
    public static final int MAX_FILE_SIZE = 0x200000;
    public static final int MAX_REQUEST_SIZE = 0x20F000;
    public static final int FILE_SIZE_THRESHOLD = 50;
    public WorkDir testingDir;

    public static Stream<Arguments> data() {
        return Stream.of("multipart-uppercase", "browser-capture-company-urlencoded-apache-httpcomp", "browser-capture-complex-apache-httpcomp", "browser-capture-duplicate-names-apache-httpcomp", "browser-capture-encoding-mess-apache-httpcomp", "browser-capture-nested-apache-httpcomp", "browser-capture-nested-binary-apache-httpcomp", "browser-capture-number-only2-apache-httpcomp", "browser-capture-number-only-apache-httpcomp", "browser-capture-sjis-apache-httpcomp", "browser-capture-strange-quoting-apache-httpcomp", "browser-capture-text-files-apache-httpcomp", "browser-capture-unicode-names-apache-httpcomp", "browser-capture-zalgo-text-plain-apache-httpcomp", "browser-capture-complex-jetty-client", "browser-capture-duplicate-names-jetty-client", "browser-capture-encoding-mess-jetty-client", "browser-capture-nested-jetty-client", "browser-capture-number-only-jetty-client", "browser-capture-sjis-jetty-client", "browser-capture-text-files-jetty-client", "browser-capture-unicode-names-jetty-client", "browser-capture-whitespace-only-jetty-client", "browser-capture-form1-android-chrome", "browser-capture-form1-android-firefox", "browser-capture-form1-chrome", "browser-capture-form1-edge", "browser-capture-form1-firefox", "browser-capture-form1-ios-safari", "browser-capture-form1-msie", "browser-capture-form1-osx-safari", "browser-capture-sjis-form-edge", "browser-capture-sjis-form-msie", "browser-capture-sjis-charset-form-android-chrome", "browser-capture-sjis-charset-form-android-firefox", "browser-capture-sjis-charset-form-chrome", "browser-capture-sjis-charset-form-edge", "browser-capture-sjis-charset-form-firefox", "browser-capture-sjis-charset-form-ios-safari", "browser-capture-sjis-charset-form-msie", "browser-capture-sjis-charset-form-safari", "browser-capture-form-fileupload-android-chrome", "browser-capture-form-fileupload-android-firefox", "browser-capture-form-fileupload-chrome", "browser-capture-form-fileupload-edge", "browser-capture-form-fileupload-firefox", "browser-capture-form-fileupload-ios-safari", "browser-capture-form-fileupload-msie", "browser-capture-form-fileupload-safari", "browser-capture-form-fileupload-alt-chrome", "browser-capture-form-fileupload-alt-edge", "browser-capture-form-fileupload-alt-firefox", "browser-capture-form-fileupload-alt-msie", "browser-capture-form-fileupload-alt-safari").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testUtilParse(String rawPrefix) throws Exception {
        Path multipartRawFile = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + rawPrefix + ".raw"));
        Path expectationPath = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + rawPrefix + ".expected.txt"));
        MultipartExpectations multipartExpectations = new MultipartExpectations(expectationPath);
        Path outputDir = this.testingDir.getEmptyPathDir();
        MultipartConfigElement config = this.newMultipartConfigElement(outputDir);
        try (InputStream in = Files.newInputStream(multipartRawFile, new OpenOption[0]);){
            MultiPartInputStreamParser parser = new MultiPartInputStreamParser(in, multipartExpectations.contentType, config, outputDir.toFile());
            multipartExpectations.checkParts(parser.getParts(), s -> {
                try {
                    return parser.getPart(s);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testHttpParse(String rawPrefix) throws Exception {
        Path multipartRawFile = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + rawPrefix + ".raw"));
        Path expectationPath = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + rawPrefix + ".expected.txt"));
        MultipartExpectations multipartExpectations = new MultipartExpectations(expectationPath);
        Path outputDir = this.testingDir.getEmptyPathDir();
        MultipartConfigElement config = this.newMultipartConfigElement(outputDir);
        try (InputStream in = Files.newInputStream(multipartRawFile, new OpenOption[0]);){
            MultiPartFormInputStream parser = new MultiPartFormInputStream(in, multipartExpectations.contentType, config, outputDir.toFile());
            multipartExpectations.checkParts(parser.getParts(), s -> {
                try {
                    return parser.getPart(s);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private MultipartConfigElement newMultipartConfigElement(Path path) {
        return new MultipartConfigElement(path.toString(), 0x200000L, 0x20F000L, 50);
    }

    static class NoOpOutputStream
    extends OutputStream {
        NoOpOutputStream() {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    public static class MultipartExpectations {
        public final String contentType;
        public final int partCount;
        public final List<NameValue> partFilenames = new ArrayList<NameValue>();
        public final List<NameValue> partSha1sums = new ArrayList<NameValue>();
        public final List<NameValue> partContainsContents = new ArrayList<NameValue>();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public MultipartExpectations(Path expectationsPath) throws IOException {
            String parsedContentType = null;
            String parsedPartCount = "-1";
            try (BufferedReader reader = Files.newBufferedReader(expectationsPath);){
                String line;
                block21: while ((line = reader.readLine()) != null) {
                    if (StringUtil.isBlank((String)(line = line.trim())) || line.startsWith("#")) continue;
                    String[] split = line.split("\\|");
                    switch (split[0]) {
                        case "Request-Header": {
                            if (!split[1].equalsIgnoreCase("Content-Type")) continue block21;
                            parsedContentType = split[2];
                            continue block21;
                        }
                        case "Content-Type": {
                            parsedContentType = split[1];
                            continue block21;
                        }
                        case "Parts-Count": {
                            parsedPartCount = split[1];
                            continue block21;
                        }
                        case "Part-ContainsContents": {
                            NameValue pair = new NameValue();
                            pair.name = split[1];
                            pair.value = split[2];
                            this.partContainsContents.add(pair);
                            continue block21;
                        }
                        case "Part-Filename": {
                            NameValue pair = new NameValue();
                            pair.name = split[1];
                            pair.value = split[2];
                            this.partFilenames.add(pair);
                            continue block21;
                        }
                        case "Part-Sha1sum": {
                            NameValue pair = new NameValue();
                            pair.name = split[1];
                            pair.value = split[2];
                            this.partSha1sums.add(pair);
                            continue block21;
                        }
                    }
                    throw new IOException("Bad Line in " + expectationsPath + ": " + line);
                }
            }
            Objects.requireNonNull(parsedContentType, "Missing required 'Content-Type' declaration: " + expectationsPath);
            this.contentType = parsedContentType;
            this.partCount = Integer.parseInt(parsedPartCount);
        }

        private void checkParts(Collection<Part> parts, Function<String, Part> getPart) throws Exception {
            Part part;
            if (this.partCount >= 0) {
                MatcherAssert.assertThat((String)"Mulitpart.parts.size", (Object)parts.size(), (Matcher)Matchers.is((Object)this.partCount));
            }
            String defaultCharset = StandardCharsets.UTF_8.toString();
            Part charSetPart = getPart.apply("_charset_");
            if (charSetPart != null) {
                defaultCharset = IO.toString((InputStream)charSetPart.getInputStream());
            }
            for (NameValue expected : this.partContainsContents) {
                part = getPart.apply(expected.name);
                MatcherAssert.assertThat((String)("Part[" + expected.name + "]"), (Object)part, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                InputStream partInputStream = part.getInputStream();
                try {
                    String charset = this.getCharsetFromContentType(part.getContentType(), defaultCharset);
                    String contents = IO.toString((InputStream)partInputStream, (String)charset);
                    MatcherAssert.assertThat((String)("Part[" + expected.name + "].contents"), (Object)contents, (Matcher)Matchers.containsString((String)expected.value));
                }
                finally {
                    if (partInputStream == null) continue;
                    partInputStream.close();
                }
            }
            for (NameValue expected : this.partFilenames) {
                part = getPart.apply(expected.name);
                MatcherAssert.assertThat((String)("Part[" + expected.name + "]"), (Object)part, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                MatcherAssert.assertThat((String)("Part[" + expected.name + "]"), (Object)part.getSubmittedFileName(), (Matcher)Matchers.is((Object)expected.value));
            }
            for (NameValue expected : this.partSha1sums) {
                part = getPart.apply(expected.name);
                MatcherAssert.assertThat((String)("Part[" + expected.name + "]"), (Object)part, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                InputStream partInputStream = part.getInputStream();
                try (NoOpOutputStream noop = new NoOpOutputStream();
                     DigestOutputStream digester = new DigestOutputStream(noop, digest);){
                    IO.copy((InputStream)partInputStream, (OutputStream)digester);
                    String actualSha1sum = Hex.asHex((byte[])digest.digest()).toLowerCase(Locale.US);
                    MatcherAssert.assertThat((String)("Part[" + expected.name + "].sha1sum"), (Object)actualSha1sum, (Matcher)Matchers.equalToIgnoringCase((String)expected.value));
                }
                finally {
                    if (partInputStream == null) continue;
                    partInputStream.close();
                }
            }
        }

        private String getCharsetFromContentType(String contentType, String defaultCharset) {
            if (StringUtil.isBlank((String)contentType)) {
                return defaultCharset;
            }
            QuotedStringTokenizer tok = new QuotedStringTokenizer(contentType, ";", false, false);
            while (tok.hasMoreTokens()) {
                String str = tok.nextToken().trim();
                if (!str.startsWith("charset=")) continue;
                return str.substring("charset=".length());
            }
            return defaultCharset;
        }
    }

    public static class NameValue {
        public String name;
        public String value;
    }
}

