/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.http.HttpURI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpURIParseTest {
    @Parameterized.Parameter(value=0)
    public String input;
    @Parameterized.Parameter(value=1)
    public String scheme;
    @Parameterized.Parameter(value=2)
    public String host;
    @Parameterized.Parameter(value=3)
    public String port;
    @Parameterized.Parameter(value=4)
    public String path;
    @Parameterized.Parameter(value=5)
    public String param;
    @Parameterized.Parameter(value=6)
    public String query;
    @Parameterized.Parameter(value=7)
    public String fragment;

    @Parameterized.Parameters(name="{0}")
    public static List<String[]> data() {
        String[][] tests = new String[][]{{"path", null, null, "-1", "path", null, null, null}, {"path/path", null, null, "-1", "path/path", null, null, null}, {"%65ncoded/path", null, null, "-1", "%65ncoded/path", null, null, null}, {"/path/to/context", null, null, "-1", "/path/to/context", null, null, null}, {"http://example.com/path/to/context;param?query=%22value%22#fragment", "http", "example.com", "-1", "/path/to/context;param", "param", "query=%22value%22", "fragment"}, {"http://[::1]/path/to/context;param?query=%22value%22#fragment", "http", "[::1]", "-1", "/path/to/context;param", "param", "query=%22value%22", "fragment"}, {"http://example.com:8080/path/to/context;param?query=%22value%22#fragment", "http", "example.com", "8080", "/path/to/context;param", "param", "query=%22value%22", "fragment"}, {"http://[::1]:8080/path/to/context;param?query=%22value%22#fragment", "http", "[::1]", "8080", "/path/to/context;param", "param", "query=%22value%22", "fragment"}, {"/path/info", null, null, null, "/path/info", null, null, null}, {"/path/info#fragment", null, null, null, "/path/info", null, null, "fragment"}, {"/path/info?query", null, null, null, "/path/info", null, "query", null}, {"/path/info?query#fragment", null, null, null, "/path/info", null, "query", "fragment"}, {"/path/info;param", null, null, null, "/path/info;param", "param", null, null}, {"/path/info;param#fragment", null, null, null, "/path/info;param", "param", null, "fragment"}, {"/path/info;param?query", null, null, null, "/path/info;param", "param", "query", null}, {"/path/info;param?query#fragment", null, null, null, "/path/info;param", "param", "query", "fragment"}, {"/path/info;a=b/foo;c=d", null, null, null, "/path/info;a=b/foo;c=d", "c=d", null, null}, {"//host/path/info", null, "host", null, "/path/info", null, null, null}, {"//user@host/path/info", null, "host", null, "/path/info", null, null, null}, {"//user@host:8080/path/info", null, "host", "8080", "/path/info", null, null, null}, {"//host:8080/path/info", null, "host", "8080", "/path/info", null, null, null}, {"http:/path/info", "http", null, null, "/path/info", null, null, null}, {"http:/path/info#fragment", "http", null, null, "/path/info", null, null, "fragment"}, {"http:/path/info?query", "http", null, null, "/path/info", null, "query", null}, {"http:/path/info?query#fragment", "http", null, null, "/path/info", null, "query", "fragment"}, {"http:/path/info;param", "http", null, null, "/path/info;param", "param", null, null}, {"http:/path/info;param#fragment", "http", null, null, "/path/info;param", "param", null, "fragment"}, {"http:/path/info;param?query", "http", null, null, "/path/info;param", "param", "query", null}, {"http:/path/info;param?query#fragment", "http", null, null, "/path/info;param", "param", "query", "fragment"}, {"http://user@host:8080/path/info;param?query#fragment", "http", "host", "8080", "/path/info;param", "param", "query", "fragment"}, {"xxxxx://user@host:8080/path/info;param?query#fragment", "xxxxx", "host", "8080", "/path/info;param", "param", "query", "fragment"}, {"http:///;?#", "http", null, null, "/;", "", "", ""}, {"/path/info?a=?query", null, null, null, "/path/info", null, "a=?query", null}, {"/path/info?a=;query", null, null, null, "/path/info", null, "a=;query", null}, {"/@path/info", null, null, null, "/@path/info", null, null, null}, {"/user@path/info", null, null, null, "/user@path/info", null, null, null}, {"//user@host/info", null, "host", null, "/info", null, null, null}, {"//@host/info", null, "host", null, "/info", null, null, null}, {"@host/info", null, null, null, "@host/info", null, null, null}, {"//host:8080//", null, "host", "8080", "//", null, null, null}, {"file:///path/info", "file", null, null, "/path/info", null, null, null}, {"file:/path/info", "file", null, null, "/path/info", null, null, null}, {"//", null, null, null, null, null, null, null}, {"http://localhost/", "http", "localhost", null, "/", null, null, null}, {"http://localhost:8080/", "http", "localhost", "8080", "/", null, null, null}, {"http://localhost/?x=y", "http", "localhost", null, "/", null, "x=y", null}, {"/;param", null, null, null, "/;param", "param", null, null}, {";param", null, null, null, ";param", "param", null, null}, {"/?x=y", null, null, null, "/", null, "x=y", null}, {"/?abc=test", null, null, null, "/", null, "abc=test", null}, {"/#fragment", null, null, null, "/", null, null, "fragment"}, {"http://192.0.0.1:8080/", "http", "192.0.0.1", "8080", "/", null, null, null}, {"http://[2001:db8::1]:8080/", "http", "[2001:db8::1]", "8080", "/", null, null, null}, {"http://user@[2001:db8::1]:8080/", "http", "[2001:db8::1]", "8080", "/", null, null, null}, {"http://[2001:db8::1]/", "http", "[2001:db8::1]", null, "/", null, null, null}, {"//[2001:db8::1]:8080/", null, "[2001:db8::1]", "8080", "/", null, null, null}, {"*", null, null, null, "*", null, null, null}, {"http://host:8080/path/info?q1=v1&q2=v2", "http", "host", "8080", "/path/info", null, "q1=v1&q2=v2", null}, {"/path/info?q1=v1&q2=v2", null, null, null, "/path/info", null, "q1=v1&q2=v2", null}, {"/info?q1=v1&q2=v2", null, null, null, "/info", null, "q1=v1&q2=v2", null}, {"info?q1=v1&q2=v2", null, null, null, "info", null, "q1=v1&q2=v2", null}, {"info;q1=v1?q2=v2", null, null, null, "info;q1=v1", "q1=v1", "q2=v2", null}, {"?q1=v1&q2=v2", null, null, null, "", null, "q1=v1&q2=v2", null}};
        return Arrays.asList(tests);
    }

    @Test
    public void testParseString() throws Exception {
        HttpURI httpUri = new HttpURI(this.input);
        try {
            new URI(this.input);
            Assert.assertThat((String)("[" + this.input + "] expected path (test case) cannot be null"), (Object)this.path, (Matcher)Matchers.notNullValue());
            Assert.assertThat((String)("[" + this.input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Object)this.scheme));
            Assert.assertThat((String)("[" + this.input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Object)this.host));
            Assert.assertThat((String)("[" + this.input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)(this.port == null ? -1 : Integer.parseInt(this.port))));
            Assert.assertThat((String)("[" + this.input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Object)this.path));
            Assert.assertThat((String)("[" + this.input + "] .param"), (Object)httpUri.getParam(), (Matcher)Matchers.is((Object)this.param));
            Assert.assertThat((String)("[" + this.input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Object)this.query));
            Assert.assertThat((String)("[" + this.input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Object)this.fragment));
            Assert.assertThat((String)("[" + this.input + "] .toString"), (Object)httpUri.toString(), (Matcher)Matchers.is((Object)this.input));
        }
        catch (URISyntaxException e) {
            Assert.assertThat((String)("[" + this.input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assert.assertThat((String)("[" + this.input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assert.assertThat((String)("[" + this.input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)-1));
            Assert.assertThat((String)("[" + this.input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assert.assertThat((String)("[" + this.input + "] .param"), (Object)httpUri.getParam(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assert.assertThat((String)("[" + this.input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            Assert.assertThat((String)("[" + this.input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void testParseURI() throws Exception {
        URI javaUri = null;
        try {
            javaUri = new URI(this.input);
            Assume.assumeNotNull((Object[])new Object[]{javaUri});
        }
        catch (URISyntaxException e) {
            Assume.assumeNoException((Throwable)e);
        }
        HttpURI httpUri = new HttpURI(javaUri);
        Assert.assertThat((String)("[" + this.input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Object)this.scheme));
        Assert.assertThat((String)("[" + this.input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Object)this.host));
        Assert.assertThat((String)("[" + this.input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)(this.port == null ? -1 : Integer.parseInt(this.port))));
        Assert.assertThat((String)("[" + this.input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Object)this.path));
        Assert.assertThat((String)("[" + this.input + "] .param"), (Object)httpUri.getParam(), (Matcher)Matchers.is((Object)this.param));
        Assert.assertThat((String)("[" + this.input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Object)this.query));
        Assert.assertThat((String)("[" + this.input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Object)this.fragment));
        Assert.assertThat((String)("[" + this.input + "] .toString"), (Object)httpUri.toString(), (Matcher)Matchers.is((Object)this.input));
    }

    @Test
    public void testCompareToJavaNetURI() throws Exception {
        URI javaUri = null;
        try {
            javaUri = new URI(this.input);
            Assume.assumeNotNull((Object[])new Object[]{javaUri});
        }
        catch (URISyntaxException e) {
            Assume.assumeNoException((Throwable)e);
        }
        HttpURI httpUri = new HttpURI(javaUri);
        Assert.assertThat((String)("[" + this.input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Object)javaUri.getScheme()));
        Assert.assertThat((String)("[" + this.input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Object)javaUri.getHost()));
        Assert.assertThat((String)("[" + this.input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)javaUri.getPort()));
        Assert.assertThat((String)("[" + this.input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Object)javaUri.getRawPath()));
        Assert.assertThat((String)("[" + this.input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Object)javaUri.getRawQuery()));
        Assert.assertThat((String)("[" + this.input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Object)javaUri.getFragment()));
        Assert.assertThat((String)("[" + this.input + "] .toString"), (Object)httpUri.toString(), (Matcher)Matchers.is((Object)javaUri.toASCIIString()));
    }
}

