/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class HttpTesterTest {
    @Test
    @Ignore
    public void testExampleUsage() throws Exception {
        try (Socket socket = new Socket("www.google.com", 80);){
            HttpTester.Request request = HttpTester.newRequest();
            request.setMethod("POST");
            request.setURI("/search");
            request.setVersion(HttpVersion.HTTP_1_0);
            request.put(HttpHeader.HOST, "www.google.com");
            request.put("Content-Type", "application/x-www-form-urlencoded");
            request.setContent("q=jetty%20server");
            ByteBuffer output = request.generate();
            socket.getOutputStream().write(output.array(), output.arrayOffset() + output.position(), output.remaining());
            HttpTester.Input input = HttpTester.from(socket.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse(input);
            System.err.printf("%s %s %s%n", response.getVersion(), response.getStatus(), response.getReason());
            Iterator iterator = response.iterator();
            while (iterator.hasNext()) {
                HttpField field = (HttpField)iterator.next();
                System.err.printf("%s: %s%n", field.getName(), field.getValue());
            }
            System.err.printf("%n%s%n", response.getContent());
        }
    }

    @Test
    public void testGetRequestBuffer10() {
        HttpTester.Request request = HttpTester.parseRequest("GET /uri HTTP/1.0\r\nHost: localhost\r\nConnection: keep-alive\r\n\r\nGET /some/other/request /HTTP/1.0\r\nHost: localhost\r\n\r\n");
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"GET"));
        Assert.assertThat((Object)request.getUri(), (Matcher)Matchers.is((Object)"/uri"));
        Assert.assertThat((Object)request.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_0));
        Assert.assertThat((Object)request.get(HttpHeader.HOST), (Matcher)Matchers.is((Object)"localhost"));
        Assert.assertThat((Object)request.getContent(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testGetRequestBuffer11() {
        HttpTester.Request request = HttpTester.parseRequest("GET /uri HTTP/1.1\r\nHost: localhost\r\n\r\nGET /some/other/request /HTTP/1.1\r\nHost: localhost\r\n\r\n");
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"GET"));
        Assert.assertThat((Object)request.getUri(), (Matcher)Matchers.is((Object)"/uri"));
        Assert.assertThat((Object)request.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)request.get(HttpHeader.HOST), (Matcher)Matchers.is((Object)"localhost"));
        Assert.assertThat((Object)request.getContent(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testPostRequestBuffer10() {
        HttpTester.Request request = HttpTester.parseRequest("POST /uri HTTP/1.0\r\nHost: localhost\r\nConnection: keep-alive\r\nContent-Length: 16\r\n\r\n0123456789ABCDEF\r\nGET /some/other/request /HTTP/1.0\r\nHost: localhost\r\n\r\n");
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"POST"));
        Assert.assertThat((Object)request.getUri(), (Matcher)Matchers.is((Object)"/uri"));
        Assert.assertThat((Object)request.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_0));
        Assert.assertThat((Object)request.get(HttpHeader.HOST), (Matcher)Matchers.is((Object)"localhost"));
        Assert.assertThat((Object)request.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
    }

    @Test
    public void testPostRequestBuffer11() {
        HttpTester.Request request = HttpTester.parseRequest("POST /uri HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\nA\r\n0123456789\r\n6\r\nABCDEF\r\n0\r\n\r\nGET /some/other/request /HTTP/1.1\r\nHost: localhost\r\n\r\n");
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"POST"));
        Assert.assertThat((Object)request.getUri(), (Matcher)Matchers.is((Object)"/uri"));
        Assert.assertThat((Object)request.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)request.get(HttpHeader.HOST), (Matcher)Matchers.is((Object)"localhost"));
        Assert.assertThat((Object)request.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
    }

    @Test
    public void testResponseEOFBuffer() {
        HttpTester.Response response = HttpTester.parseResponse("HTTP/1.1 200 OK\r\nHeader: value\r\nConnection: close\r\n\r\n0123456789ABCDEF");
        Assert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getReason(), (Matcher)Matchers.is((Object)"OK"));
        Assert.assertThat((Object)response.get("Header"), (Matcher)Matchers.is((Object)"value"));
        Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
    }

    @Test
    public void testResponseLengthBuffer() {
        HttpTester.Response response = HttpTester.parseResponse("HTTP/1.1 200 OK\r\nHeader: value\r\nContent-Length: 16\r\n\r\n0123456789ABCDEFHTTP/1.1 200 OK\r\n\r\n");
        Assert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getReason(), (Matcher)Matchers.is((Object)"OK"));
        Assert.assertThat((Object)response.get("Header"), (Matcher)Matchers.is((Object)"value"));
        Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
    }

    @Test
    public void testResponseChunkedBuffer() {
        HttpTester.Response response = HttpTester.parseResponse("HTTP/1.1 200 OK\r\nHeader: value\r\nTransfer-Encoding: chunked\r\n\r\nA\r\n0123456789\r\n6\r\nABCDEF\r\n0\r\n\r\nHTTP/1.1 200 OK\r\n\r\n");
        Assert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getReason(), (Matcher)Matchers.is((Object)"OK"));
        Assert.assertThat((Object)response.get("Header"), (Matcher)Matchers.is((Object)"value"));
        Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
    }

    @Test
    public void testResponsesInput() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nHeader: value\r\nTransfer-Encoding: chunked\r\n\r\nA\r\n0123456789\r\n6\r\nABCDEF\r\n0\r\n\r\nHTTP/1.1 400 OK\r\nNext: response\r\nContent-Length: 16\r\n\r\n0123456789ABCDEF".getBytes(StandardCharsets.ISO_8859_1));
        HttpTester.Input in = HttpTester.from(stream);
        HttpTester.Response response = HttpTester.parseResponse(in);
        Assert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getReason(), (Matcher)Matchers.is((Object)"OK"));
        Assert.assertThat((Object)response.get("Header"), (Matcher)Matchers.is((Object)"value"));
        Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
        response = HttpTester.parseResponse(in);
        Assert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
        Assert.assertThat((Object)response.getReason(), (Matcher)Matchers.is((Object)"OK"));
        Assert.assertThat((Object)response.get("Next"), (Matcher)Matchers.is((Object)"response"));
        Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
    }

    @Test
    public void testResponsesSplitInput() throws Exception {
        PipedOutputStream src = new PipedOutputStream();
        PipedInputStream stream = new PipedInputStream(src){

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                if (this.available() == 0) {
                    return 0;
                }
                return super.read(b, off, len);
            }
        };
        HttpTester.Input in = HttpTester.from(stream);
        src.write("HTTP/1.1 200 OK\r\nHeader: value\r\nTransfer-Encoding: chunked\r\n\r\nA\r\n0123456789\r\n6\r\nABC".getBytes(StandardCharsets.ISO_8859_1));
        HttpTester.Response response = HttpTester.parseResponse(in);
        Assert.assertThat((Object)((Object)response), (Matcher)Matchers.nullValue());
        src.write("DEF\r\n0\r\n\r\nHTTP/1.1 400 OK\r\nNext: response\r\nContent-Length: 16\r\n\r\n0123456789".getBytes(StandardCharsets.ISO_8859_1));
        response = HttpTester.parseResponse(in);
        Assert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getReason(), (Matcher)Matchers.is((Object)"OK"));
        Assert.assertThat((Object)response.get("Header"), (Matcher)Matchers.is((Object)"value"));
        Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
        response = HttpTester.parseResponse(in);
        Assert.assertThat((Object)((Object)response), (Matcher)Matchers.nullValue());
        src.write("ABCDEF".getBytes(StandardCharsets.ISO_8859_1));
        response = HttpTester.parseResponse(in);
        Assert.assertThat((Object)response.getVersion(), (Matcher)Matchers.is((Object)HttpVersion.HTTP_1_1));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
        Assert.assertThat((Object)response.getReason(), (Matcher)Matchers.is((Object)"OK"));
        Assert.assertThat((Object)response.get("Next"), (Matcher)Matchers.is((Object)"response"));
        Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"0123456789ABCDEF"));
    }
}

