/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.Enumeration;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HttpFieldsTest {
    @Test
    public void testPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value:0");
        header.put("name1", "value1");
        Assert.assertEquals((Object)"value:0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertNull((Object)header.getStringField("name2"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if (!"name1".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)2L, (long)matches);
        e = header.getValues("name0");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value:0");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testPutTo() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value:A");
        header.add("name1", "value:B");
        header.add("name2", "");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String result = BufferUtil.toString((ByteBuffer)buffer);
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name0: value0"));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name1: value:A"));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name1: value:B"));
    }

    @Test
    public void testGet() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value1");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("Name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("Name1"));
    }

    @Test
    public void testCRLF() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value\r\n0");
        header.put("name\r\n1", "value1");
        header.put("name:2", "value:\r\n2");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String out = BufferUtil.toString((ByteBuffer)buffer);
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name0: value  0"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name??1: value1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name?2: value:  2"));
    }

    @Test
    public void testCachedPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("Connection", "Keep-Alive");
        header.put("tRansfer-EncOding", "CHUNKED");
        header.put("CONTENT-ENCODING", "gZIP");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String out = BufferUtil.toString((ByteBuffer)buffer).toLowerCase();
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.CONNECTION + ": " + HttpHeaderValue.KEEP_ALIVE).toLowerCase()));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.TRANSFER_ENCODING + ": " + HttpHeaderValue.CHUNKED).toLowerCase()));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.CONTENT_ENCODING + ": " + HttpHeaderValue.GZIP).toLowerCase()));
    }

    @Test
    public void testRePut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "xxxxxx");
        header.put("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"xxxxxx", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        header.put("name1", "value1");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        Assert.assertNull((Object)header.getStringField("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            String o = (String)e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)3L, (long)matches);
        e = header.getValues("name1");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testRemovePut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value1");
        header.put("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        header.remove("name1");
        Assert.assertEquals((Object)"value0", (Object)header.getStringField("name0"));
        Assert.assertNull((Object)header.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.getStringField("name2"));
        Assert.assertNull((Object)header.getStringField("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)2L, (long)matches);
        e = header.getValues("name1");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testAdd() throws Exception {
        HttpFields fields = new HttpFields();
        fields.add("name0", "value0");
        fields.add("name1", "valueA");
        fields.add("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)fields.getStringField("name0"));
        Assert.assertEquals((Object)"valueA", (Object)fields.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)fields.getStringField("name2"));
        fields.add("name1", "valueB");
        Assert.assertEquals((Object)"value0", (Object)fields.getStringField("name0"));
        Assert.assertEquals((Object)"valueA", (Object)fields.getStringField("name1"));
        Assert.assertEquals((Object)"value2", (Object)fields.getStringField("name2"));
        Assert.assertNull((Object)fields.getStringField("name3"));
        int matches = 0;
        Enumeration e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)3L, (long)matches);
        e = fields.getValues("name1");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"valueA");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"valueB");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testGetValues() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("name0", "value0A,value0B");
        fields.add("name0", "value0C,value0D");
        fields.put("name1", "value1A, \"value\t, 1B\" ");
        fields.add("name1", "\"value1C\",\tvalue1D");
        Enumeration e = fields.getValues("name0");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0A,value0B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0C,value0D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = fields.getValues("name0", ",");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0A");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0C");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = fields.getValues("name1", ",");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1A");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value\t, 1B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1C");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("D0", "Wed, 31 Dec 1969 23:59:59 GMT");
        fields.put("D1", "Fri, 31 Dec 1999 23:59:59 GMT");
        fields.put("D2", "Friday, 31-Dec-99 23:59:59 GMT");
        fields.put("D3", "Fri Dec 31 23:59:59 1999");
        fields.put("D4", "Mon Jan 1 2000 00:00:01");
        fields.put("D5", "Tue Feb 29 2000 12:00:00");
        long d1 = fields.getDateField("D1");
        long d0 = fields.getDateField("D0");
        long d2 = fields.getDateField("D2");
        long d3 = fields.getDateField("D3");
        long d4 = fields.getDateField("D4");
        long d5 = fields.getDateField("D5");
        Assert.assertTrue((d0 != -1L ? 1 : 0) != 0);
        Assert.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)d1, (long)d2);
        Assert.assertEquals((long)d2, (long)d3);
        Assert.assertEquals((long)(d3 + 2000L), (long)d4);
        Assert.assertEquals((long)951825600000L, (long)d5);
        d1 = fields.getDateField("D1");
        d2 = fields.getDateField("D2");
        d3 = fields.getDateField("D3");
        d4 = fields.getDateField("D4");
        d5 = fields.getDateField("D5");
        Assert.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)d1, (long)d2);
        Assert.assertEquals((long)d2, (long)d3);
        Assert.assertEquals((long)(d3 + 2000L), (long)d4);
        Assert.assertEquals((long)951825600000L, (long)d5);
        fields.putDateField("D2", d1);
        Assert.assertEquals((Object)"Fri, 31 Dec 1999 23:59:59 GMT", (Object)fields.getStringField("D2"));
    }

    @Test
    public void testNegDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.putDateField("Dzero", 0L);
        Assert.assertEquals((Object)"Thu, 01 Jan 1970 00:00:00 GMT", (Object)fields.getStringField("Dzero"));
        fields.putDateField("Dminus", -1L);
        Assert.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.getStringField("Dminus"));
        fields.putDateField("Dminus", -1000L);
        Assert.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.getStringField("Dminus"));
        fields.putDateField("Dancient", Long.MIN_VALUE);
        Assert.assertEquals((Object)"Sun, 02 Dec 55 16:47:04 GMT", (Object)fields.getStringField("Dancient"));
    }

    @Test
    public void testLongFields() throws Exception {
        HttpFields header = new HttpFields();
        header.put("I1", "42");
        header.put("I2", " 43 99");
        header.put("I3", "-44;");
        header.put("I4", " - 45abc");
        header.put("N1", " - ");
        header.put("N2", "xx");
        long i1 = header.getLongField("I1");
        long i2 = header.getLongField("I2");
        long i3 = header.getLongField("I3");
        long i4 = header.getLongField("I4");
        try {
            header.getLongField("N1");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            header.getLongField("N2");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertEquals((long)42L, (long)i1);
        Assert.assertEquals((long)43L, (long)i2);
        Assert.assertEquals((long)-44L, (long)i3);
        Assert.assertEquals((long)-45L, (long)i4);
        header.putLongField("I5", 46L);
        header.putLongField("I6", -47L);
        Assert.assertEquals((Object)"46", (Object)header.getStringField("I5"));
        Assert.assertEquals((Object)"-47", (Object)header.getStringField("I6"));
    }

    @Test
    public void testContains() throws Exception {
        HttpFields header = new HttpFields();
        header.add("0", "");
        header.add("1", ",");
        header.add("2", ",,");
        header.add("3", "abc");
        header.add("4", "def");
        header.add("5", "abc,def,hig");
        header.add("6", "abc");
        header.add("6", "def");
        header.add("6", "hig");
        for (int i = 0; i < 7; ++i) {
            Assert.assertFalse((String)("" + i), (boolean)header.contains("" + i, "xyz"));
            Assert.assertEquals((String)("" + i), (Object)(i >= 4 ? 1 : 0), (Object)header.contains("" + i, "def"));
        }
    }
}

