/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;

public interface HttpURI {
    public static Mutable build() {
        return new Mutable();
    }

    public static Mutable build(HttpURI uri) {
        return new Mutable(uri);
    }

    public static Mutable build(HttpURI uri, String pathQuery) {
        return new Mutable(uri, pathQuery);
    }

    public static Mutable build(HttpURI uri, String path, String param, String query) {
        return new Mutable(uri, path, param, query);
    }

    public static Mutable build(URI uri) {
        return new Mutable(uri);
    }

    public static Mutable build(String uri) {
        return new Mutable(uri);
    }

    public static Mutable build(String method, String uri) {
        if (HttpMethod.CONNECT.is(method)) {
            HostPort hostPort = new HostPort(uri);
            return new Mutable(null, hostPort.getHost(), hostPort.getPort(), null);
        }
        if (uri.startsWith("/")) {
            return HttpURI.build().pathQuery(uri);
        }
        return HttpURI.build(uri);
    }

    public static Immutable from(URI uri) {
        return new Mutable(uri).asImmutable();
    }

    public static Immutable from(String uri) {
        return new Mutable(uri).asImmutable();
    }

    public static Immutable from(String method, String uri) {
        if (HttpMethod.CONNECT.is(method)) {
            return HttpURI.build().uri(method, uri).asImmutable();
        }
        if (uri.startsWith("/")) {
            return HttpURI.build().pathQuery(uri).asImmutable();
        }
        return HttpURI.from(uri);
    }

    public static Immutable from(String scheme, HostPort hostPort, String pathQuery) {
        return new Mutable(scheme, hostPort.getHost(), hostPort.getPort(), pathQuery).asImmutable();
    }

    public static Immutable from(String scheme, String host, int port, String pathQuery) {
        return new Mutable(scheme, host, port, pathQuery).asImmutable();
    }

    public static Immutable from(String scheme, String host, int port, String path, String query, String fragment) {
        return new Immutable(scheme, host, port, path, query, fragment);
    }

    public Immutable asImmutable();

    public String asString();

    public String getAuthority();

    public String getDecodedPath();

    public String getCanonicalPath();

    public String getFragment();

    public String getHost();

    public String getParam();

    public String getPath();

    public String getPathQuery();

    public int getPort();

    public String getQuery();

    public String getScheme();

    public String getUser();

    public boolean hasAuthority();

    public boolean isAbsolute();

    public boolean isAmbiguous();

    public boolean hasViolations();

    public boolean hasViolation(UriCompliance.Violation var1);

    public Collection<UriCompliance.Violation> getViolations();

    default public boolean hasAmbiguousSegment() {
        return this.hasViolation(UriCompliance.Violation.AMBIGUOUS_PATH_SEGMENT);
    }

    default public boolean hasAmbiguousEmptySegment() {
        return this.hasViolation(UriCompliance.Violation.AMBIGUOUS_EMPTY_SEGMENT);
    }

    default public boolean hasAmbiguousSeparator() {
        return this.hasViolation(UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR);
    }

    default public boolean hasAmbiguousParameter() {
        return this.hasViolation(UriCompliance.Violation.AMBIGUOUS_PATH_PARAMETER);
    }

    default public boolean hasAmbiguousEncoding() {
        return this.hasViolation(UriCompliance.Violation.AMBIGUOUS_PATH_ENCODING);
    }

    default public boolean hasUtf16Encoding() {
        return this.hasViolation(UriCompliance.Violation.UTF16_ENCODINGS);
    }

    default public URI toURI() {
        return URI.create(this.toString());
    }

    public static class Mutable
    implements HttpURI {
        private static final Index<Boolean> __ambiguousSegments;
        private static final boolean[] __suspiciousPathCharacters;
        private static final boolean[] __unreservedPctEncodedSubDelims;
        private static final boolean[] __pathCharacters;
        private String _scheme;
        private String _user;
        private String _host;
        private int _port = -1;
        private String _path;
        private String _param;
        private String _query;
        private String _fragment;
        private String _uri;
        private String _canonicalPath;
        private Set<UriCompliance.Violation> _violations;
        private boolean _emptySegment;

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        private static boolean isHexDigit(char c) {
            return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
        }

        private static boolean isUnreserved(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
        }

        private static boolean isSubDelim(char c) {
            return c == '!' || c == '$' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ';' || c == '=';
        }

        static boolean isUnreservedPctEncodedOrSubDelim(char c) {
            return c < __unreservedPctEncodedSubDelims.length && __unreservedPctEncodedSubDelims[c];
        }

        private Mutable() {
        }

        private Mutable(HttpURI uri) {
            this.uri(uri);
        }

        private Mutable(HttpURI baseURI, String pathQuery) {
            this._uri = null;
            this._scheme = baseURI.getScheme();
            this._user = baseURI.getUser();
            if (this._user != null) {
                this._violations = EnumSet.of(UriCompliance.Violation.USER_INFO);
            }
            this._host = baseURI.getHost();
            this._port = baseURI.getPort();
            if (pathQuery != null) {
                this.parse(State.PATH, pathQuery);
            }
        }

        private Mutable(HttpURI baseURI, String path, String param, String query) {
            this._uri = null;
            this._scheme = baseURI.getScheme();
            this._user = baseURI.getUser();
            if (this._user != null) {
                this._violations = EnumSet.of(UriCompliance.Violation.USER_INFO);
            }
            this._host = baseURI.getHost();
            this._port = baseURI.getPort();
            if (path != null) {
                this.parse(State.PATH, path);
            }
            if (param != null) {
                this._param = param;
            }
            if (query != null) {
                this._query = query;
            }
        }

        private Mutable(String uri) {
            this.parse(State.START, uri);
        }

        private Mutable(URI uri) {
            String path;
            this._uri = null;
            this._scheme = URIUtil.normalizeScheme((String)uri.getScheme());
            this._host = uri.getHost();
            if (this._host == null && uri.getRawSchemeSpecificPart().startsWith("//")) {
                this._host = "";
            }
            this._port = uri.getPort();
            this._user = uri.getUserInfo();
            if (this._user != null) {
                this._violations = EnumSet.of(UriCompliance.Violation.USER_INFO);
            }
            if ((path = uri.getRawPath()) != null) {
                this.parse(State.PATH, path);
            }
            this._query = uri.getRawQuery();
            this._fragment = uri.getRawFragment();
        }

        private Mutable(String scheme, String host, int port, String pathQuery) {
            this._uri = null;
            this._scheme = URIUtil.normalizeScheme((String)scheme);
            this._host = host;
            int n = this._port = port > 0 ? port : -1;
            if (pathQuery != null) {
                this.parse(State.PATH, pathQuery);
            }
        }

        @Override
        public Immutable asImmutable() {
            return new Immutable(this);
        }

        @Override
        public String asString() {
            return this.asImmutable().toString();
        }

        public Mutable authority(String host, int port) {
            if (host != null && !this.isPathValidForAuthority(this._path)) {
                throw new IllegalArgumentException("Relative path with authority");
            }
            this._user = null;
            this._host = host;
            this._port = port > 0 ? port : -1;
            this._uri = null;
            return this;
        }

        public Mutable authority(String hostPort) {
            if (hostPort != null && !this.isPathValidForAuthority(this._path)) {
                throw new IllegalArgumentException("Relative path with authority");
            }
            HostPort hp = new HostPort(hostPort);
            this._user = null;
            this._host = hp.getHost();
            this._port = hp.getPort();
            this._uri = null;
            return this;
        }

        private boolean isPathValidForAuthority(String path) {
            if (path == null) {
                return true;
            }
            if (path.isEmpty() || "*".equals(path)) {
                return true;
            }
            return path.startsWith("/");
        }

        public Mutable clear() {
            this._scheme = null;
            this._user = null;
            this._host = null;
            this._port = -1;
            this._path = null;
            this._param = null;
            this._query = null;
            this._fragment = null;
            this._uri = null;
            this._canonicalPath = null;
            this._emptySegment = false;
            if (this._violations != null) {
                this._violations.clear();
            }
            return this;
        }

        public Mutable decodedPath(String path) {
            this._uri = null;
            this._path = URIUtil.encodePath((String)path);
            this._canonicalPath = URIUtil.canonicalPath((String)this._path);
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpURI)) {
                return false;
            }
            return this.asString().equals(((HttpURI)o).asString());
        }

        public Mutable fragment(String fragment) {
            this._fragment = fragment;
            return this;
        }

        @Override
        public String getAuthority() {
            if (this._port > 0) {
                return this._host + ":" + this._port;
            }
            return this._host;
        }

        @Override
        public String getDecodedPath() {
            return URIUtil.decodePath((String)this.getCanonicalPath());
        }

        @Override
        public String getCanonicalPath() {
            if (this._canonicalPath == null && this._path != null) {
                this._canonicalPath = URIUtil.canonicalPath((String)this._path);
            }
            return this._canonicalPath;
        }

        @Override
        public String getFragment() {
            return this._fragment;
        }

        @Override
        public String getHost() {
            return this._host;
        }

        @Override
        public String getParam() {
            return this._param;
        }

        @Override
        public String getPath() {
            return this._path;
        }

        @Override
        public String getPathQuery() {
            if (this._query == null) {
                return this._path;
            }
            return this._path + "?" + this._query;
        }

        @Override
        public int getPort() {
            return this._port;
        }

        @Override
        public String getQuery() {
            return this._query;
        }

        @Override
        public String getScheme() {
            return this._scheme;
        }

        @Override
        public String getUser() {
            return this._user;
        }

        @Override
        public boolean hasAuthority() {
            return this._host != null;
        }

        public int hashCode() {
            return this.asString().hashCode();
        }

        public Mutable host(String host) {
            if (host != null && !this.isPathValidForAuthority(this._path)) {
                throw new IllegalArgumentException("Relative path with authority");
            }
            this._host = host;
            this._uri = null;
            return this;
        }

        @Override
        public boolean isAbsolute() {
            return StringUtil.isNotBlank((String)this._scheme);
        }

        @Override
        public boolean isAmbiguous() {
            return this._violations != null && UriCompliance.isAmbiguous(this._violations);
        }

        @Override
        public boolean hasViolations() {
            return this._violations != null && !this._violations.isEmpty();
        }

        @Override
        public boolean hasViolation(UriCompliance.Violation violation) {
            return this._violations != null && this._violations.contains(violation);
        }

        @Override
        public Collection<UriCompliance.Violation> getViolations() {
            return this._violations == null ? Collections.emptySet() : Collections.unmodifiableCollection(this._violations);
        }

        public Mutable normalize() {
            HttpScheme scheme;
            HttpScheme httpScheme = scheme = this._scheme == null ? null : (HttpScheme)((Object)HttpScheme.CACHE.get(this._scheme));
            if (scheme != null && this._port == scheme.getDefaultPort()) {
                this._port = 0;
                this._uri = null;
            }
            return this;
        }

        public Mutable param(String param) {
            this._param = param;
            if (this._path != null && this._param != null) {
                int trailingParam;
                int lastSlash = this._path.lastIndexOf(47);
                if (lastSlash >= 0 && (trailingParam = this._path.indexOf(59, lastSlash + 1)) >= 0) {
                    this._path = this._path.substring(0, trailingParam);
                }
                this._path = this._path + ";" + this._param;
            }
            this._uri = null;
            return this;
        }

        public Mutable path(String path) {
            if (this.hasAuthority() && !this.isPathValidForAuthority(path)) {
                throw new IllegalArgumentException("Relative path with authority");
            }
            if (!URIUtil.isPathValid((String)path)) {
                throw new IllegalArgumentException("Path not correctly encoded: " + path);
            }
            if (this._violations != null) {
                this._violations.removeIf(UriCompliance::isPathViolation);
            }
            this._uri = null;
            this._path = null;
            this._canonicalPath = null;
            String param = this._param;
            this._param = null;
            this.parse(State.PATH, path);
            if (param != null && path.indexOf(59) < 0) {
                this._param = param;
                this._path = this._path + ";" + this._param;
            }
            return this;
        }

        public Mutable pathQuery(String pathQuery) {
            if (this.hasAuthority() && !this.isPathValidForAuthority(pathQuery)) {
                throw new IllegalArgumentException("Relative path with authority");
            }
            if (this._violations != null) {
                this._violations.removeIf(UriCompliance::isPathViolation);
            }
            this._uri = null;
            this._path = null;
            this._canonicalPath = null;
            this._param = null;
            this._query = null;
            if (pathQuery != null) {
                this.parse(State.PATH, pathQuery);
            }
            return this;
        }

        public Mutable port(int port) {
            this._port = port > 0 ? port : -1;
            this._uri = null;
            return this;
        }

        public Mutable query(String query) {
            this._query = query;
            this._uri = null;
            return this;
        }

        public Mutable scheme(HttpScheme scheme) {
            return this.scheme(scheme.asString());
        }

        public Mutable scheme(String scheme) {
            this._scheme = URIUtil.normalizeScheme((String)scheme);
            this._uri = null;
            return this;
        }

        public String toString() {
            return this.asString();
        }

        public Mutable uri(HttpURI uri) {
            this._scheme = uri.getScheme();
            this._user = uri.getUser();
            this._host = uri.getHost();
            this._port = uri.getPort();
            this._path = uri.getPath();
            this._param = uri.getParam();
            this._query = uri.getQuery();
            this._uri = null;
            this._canonicalPath = uri.getCanonicalPath();
            Collection<UriCompliance.Violation> violations = uri.getViolations();
            if (!violations.isEmpty()) {
                this._violations = EnumSet.copyOf(violations);
            }
            return this;
        }

        public Mutable uri(String uri) {
            this.clear();
            this._uri = uri;
            this.parse(State.START, uri);
            return this;
        }

        public Mutable uri(String method, String uri) {
            if (HttpMethod.CONNECT.is(method)) {
                this.clear();
                this.parse(State.HOST_OR_USER, uri);
                this._path = null;
                this._query = null;
                this._param = null;
            } else if (uri.startsWith("/")) {
                this.clear();
                this.pathQuery(uri);
            } else {
                this.uri(uri);
            }
            return this;
        }

        public Mutable uri(String uri, int offset, int length) {
            this.clear();
            int end = offset + length;
            this._uri = uri.substring(offset, end);
            this.parse(State.START, uri);
            return this;
        }

        public Mutable user(String user) {
            this._user = user;
            if (user == null) {
                this.removeViolation(UriCompliance.Violation.USER_INFO);
            } else {
                this.addViolation(UriCompliance.Violation.USER_INFO);
            }
            this._uri = null;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        private void parse(State state, String uri) {
            mark = 0;
            pathMark = 0;
            segment = 0;
            encoded = false;
            encodedUtf16 = false;
            encodedCharacters = 0;
            encodedValue = 0;
            dot = false;
            end = uri.length();
            this._emptySegment = false;
            block96: for (i = 0; i < end; ++i) {
                c = uri.charAt(i);
                switch (state.ordinal()) {
                    case 0: {
                        switch (c) {
                            case '/': {
                                mark = i;
                                state = State.HOST_OR_PATH;
                                continue block96;
                            }
                            case ';': {
                                this.checkSegment(uri, false, segment, i, true);
                                mark = i + 1;
                                state = State.PARAM;
                                continue block96;
                            }
                            case '?': {
                                this.checkSegment(uri, false, segment, i, false);
                                this._path = "";
                                mark = i + 1;
                                state = State.QUERY;
                                continue block96;
                            }
                            case '#': {
                                this.checkSegment(uri, false, segment, i, false);
                                this._path = "";
                                mark = i + 1;
                                state = State.FRAGMENT;
                                continue block96;
                            }
                            case '*': {
                                this._path = "*";
                                state = State.ASTERISK;
                                continue block96;
                            }
                            case '%': {
                                encoded = true;
                                encodedCharacters = 2;
                                encodedValue = 0;
                                pathMark = segment = i;
                                mark = segment;
                                state = State.PATH;
                                continue block96;
                            }
                            case '.': {
                                dot = true;
                                pathMark = segment = i;
                                state = State.PATH;
                                continue block96;
                            }
                        }
                        mark = i;
                        if (this._scheme == null) {
                            state = State.SCHEME_OR_PATH;
                            continue block96;
                        }
                        pathMark = segment = i;
                        state = State.PATH;
                        continue block96;
                    }
                    case 2: {
                        switch (c) {
                            case ':': {
                                this._scheme = URIUtil.normalizeScheme((String)uri.substring(mark, i));
                                state = State.START;
                                continue block96;
                            }
                            case '/': {
                                segment = i + 1;
                                state = State.PATH;
                                continue block96;
                            }
                            case ';': {
                                mark = i + 1;
                                state = State.PARAM;
                                continue block96;
                            }
                            case '?': {
                                this.checkSegment(uri, false, segment, i, false);
                                this._path = uri.substring(mark, i);
                                mark = i + 1;
                                state = State.QUERY;
                                continue block96;
                            }
                            case '%': {
                                encoded = true;
                                encodedCharacters = 2;
                                encodedValue = 0;
                                state = State.PATH;
                                continue block96;
                            }
                            case '#': {
                                this._path = uri.substring(mark, i);
                                this.addViolation(UriCompliance.Violation.FRAGMENT);
                                state = State.FRAGMENT;
                                continue block96;
                            }
                        }
                        continue block96;
                    }
                    case 1: {
                        switch (c) {
                            case '/': {
                                this._host = "";
                                mark = i + 1;
                                state = State.HOST_OR_USER;
                                continue block96;
                            }
                            case '#': 
                            case '%': 
                            case '.': 
                            case ';': 
                            case '?': 
                            case '@': {
                                --i;
                                pathMark = mark;
                                segment = mark + 1;
                                state = State.PATH;
                                continue block96;
                            }
                        }
                        pathMark = mark;
                        segment = mark + 1;
                        state = State.PATH;
                        continue block96;
                    }
                    case 3: {
                        switch (c) {
                            case '#': 
                            case '/': 
                            case '?': {
                                if (encodedCharacters > 0) {
                                    throw new IllegalArgumentException("Bad authority");
                                }
                                this._host = uri.substring(mark, i);
                                encoded = false;
                                if (c == '/') {
                                    pathMark = mark = i;
                                    segment = mark + 1;
                                    state = State.PATH;
                                    continue block96;
                                }
                                mark = i + 1;
                                this._path = "";
                                switch (c) {
                                    case '?': {
                                        v0 = State.QUERY;
                                        break;
                                    }
                                    case '#': {
                                        this.addViolation(UriCompliance.Violation.FRAGMENT);
                                        v0 = State.FRAGMENT;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Bad authority");
                                    }
                                }
                                state = v0;
                                continue block96;
                            }
                            case ';': {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            case ':': {
                                if (encodedCharacters > 0) {
                                    throw new IllegalArgumentException("Bad authority");
                                }
                                if (i > mark) {
                                    this._host = uri.substring(mark, i);
                                }
                                mark = i + 1;
                                state = State.PORT_OR_PASSWORD;
                                continue block96;
                            }
                            case '@': {
                                if (encodedCharacters > 0) {
                                    throw new IllegalArgumentException("Bad authority");
                                }
                                this._user = uri.substring(mark, i);
                                this.addViolation(UriCompliance.Violation.USER_INFO);
                                encoded = false;
                                mark = i + 1;
                                continue block96;
                            }
                            case '[': {
                                if (i != mark) {
                                    throw new IllegalArgumentException("Bad authority");
                                }
                                state = State.IPV6;
                                continue block96;
                            }
                            case '%': {
                                if (encodedCharacters > 0) {
                                    throw new IllegalArgumentException("Bad authority");
                                }
                                encoded = true;
                                encodedCharacters = 2;
                                continue block96;
                            }
                        }
                        if (encodedCharacters > 0) {
                            --encodedCharacters;
                            if (Mutable.isHexDigit(c)) continue block96;
                            throw new IllegalArgumentException("Bad authority");
                        }
                        if (Mutable.isUnreservedPctEncodedOrSubDelim(c)) continue block96;
                        throw new IllegalArgumentException("Bad authority");
                    }
                    case 4: {
                        switch (c) {
                            case '/': {
                                throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                            }
                            case ']': {
                                c = uri.charAt(++i);
                                this._host = uri.substring(mark, i);
                                if (c == ':') {
                                    mark = i + 1;
                                    state = State.PORT_OR_PASSWORD;
                                    continue block96;
                                }
                                pathMark = mark = i;
                                state = State.PATH;
                                continue block96;
                            }
                            case ':': {
                                continue block96;
                            }
                        }
                        if (Mutable.isHexDigit(c)) continue block96;
                        throw new IllegalArgumentException("Bad authority");
                    }
                    case 5: {
                        try {
                            switch (c) {
                                case '@': {
                                    if (this._user != null) {
                                        throw new IllegalArgumentException("Bad authority");
                                    }
                                    this._user = this._host + ":" + uri.substring(mark, i);
                                    this._host = null;
                                    this.addViolation(UriCompliance.Violation.USER_INFO);
                                    mark = i + 1;
                                    state = State.HOST_OR_USER;
                                    ** break;
                                }
                                case '/': {
                                    this._port = TypeUtil.parseInt((String)uri, (int)mark, (int)(i - mark), (int)10);
                                    pathMark = mark = i;
                                    segment = mark + 1;
                                    state = State.PATH;
                                    ** break;
                                }
                                case '#': 
                                case '?': {
                                    this._port = TypeUtil.parseInt((String)uri, (int)mark, (int)(i - mark), (int)10);
                                    mark = i + 1;
                                    this._path = "";
                                    switch (c) {
                                        case '?': {
                                            v1 = State.QUERY;
                                            break;
                                        }
                                        case '#': {
                                            this.addViolation(UriCompliance.Violation.FRAGMENT);
                                            v1 = State.FRAGMENT;
                                            break;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                    state = v1;
                                    ** break;
                                }
                                case ';': {
                                    throw new IllegalArgumentException("Bad authority");
                                }
                            }
                            if (Mutable.isDigit(c) || Mutable.isUnreservedPctEncodedOrSubDelim(c)) continue block96;
                            throw new IllegalArgumentException("Bad authority");
lbl227:
                            // 3 sources

                            continue block96;
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("Bad authority", nfe);
                        }
                    }
                    case 6: {
                        if (encodedCharacters > 0) {
                            if (encodedCharacters == 2 && c == 'u' && !encodedUtf16) {
                                this.addViolation(UriCompliance.Violation.UTF16_ENCODINGS);
                                encodedUtf16 = true;
                                encodedCharacters = 4;
                                continue block96;
                            }
                            encodedValue = (encodedValue << 4) + TypeUtil.convertHexDigit((char)c);
                            if (--encodedCharacters != 0) continue block96;
                            switch (encodedValue) {
                                case 0: {
                                    throw new IllegalArgumentException("Illegal character in path");
                                }
                                case 47: {
                                    this.addViolation(UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR);
                                    continue block96;
                                }
                                case 37: {
                                    this.addViolation(UriCompliance.Violation.AMBIGUOUS_PATH_ENCODING);
                                    continue block96;
                                }
                            }
                            if (encodedValue >= Mutable.__suspiciousPathCharacters.length || !Mutable.__suspiciousPathCharacters[encodedValue]) continue block96;
                            this.addViolation(UriCompliance.Violation.SUSPICIOUS_PATH_CHARACTERS);
                            continue block96;
                        }
                        switch (c) {
                            case ';': {
                                this.checkSegment(uri, dot != false || encoded != false, segment, i, true);
                                mark = i + 1;
                                state = State.PARAM;
                                continue block96;
                            }
                            case '?': {
                                this.checkSegment(uri, dot != false || encoded != false, segment, i, false);
                                this._path = uri.substring(pathMark, i);
                                mark = i + 1;
                                state = State.QUERY;
                                continue block96;
                            }
                            case '#': {
                                this.checkSegment(uri, dot != false || encoded != false, segment, i, false);
                                this._path = uri.substring(pathMark, i);
                                mark = i + 1;
                                this.addViolation(UriCompliance.Violation.FRAGMENT);
                                state = State.FRAGMENT;
                                continue block96;
                            }
                            case '/': {
                                if (i != 0) {
                                    this.checkSegment(uri, dot != false || encoded != false, segment, i, false);
                                }
                                segment = i + 1;
                                continue block96;
                            }
                            case '.': {
                                dot |= segment == i;
                                continue block96;
                            }
                            case '%': {
                                encoded = true;
                                encodedUtf16 = false;
                                encodedCharacters = 2;
                                encodedValue = 0;
                                continue block96;
                            }
                        }
                        if (c > Mutable.__pathCharacters.length || !Mutable.__pathCharacters[c]) {
                            this.addViolation(UriCompliance.Violation.ILLEGAL_PATH_CHARACTERS);
                        }
                        if (c >= Mutable.__suspiciousPathCharacters.length || !Mutable.__suspiciousPathCharacters[c]) continue block96;
                        this.addViolation(UriCompliance.Violation.SUSPICIOUS_PATH_CHARACTERS);
                        continue block96;
                    }
                    case 7: {
                        switch (c) {
                            case '?': {
                                this._path = uri.substring(pathMark, i);
                                this._param = uri.substring(mark, i);
                                mark = i + 1;
                                state = State.QUERY;
                                continue block96;
                            }
                            case '#': {
                                this._path = uri.substring(pathMark, i);
                                this._param = uri.substring(mark, i);
                                mark = i + 1;
                                this.addViolation(UriCompliance.Violation.FRAGMENT);
                                state = State.FRAGMENT;
                                continue block96;
                            }
                            case '/': {
                                encoded = true;
                                segment = i + 1;
                                state = State.PATH;
                                continue block96;
                            }
                            case ';': {
                                continue block96;
                            }
                        }
                        continue block96;
                    }
                    case 8: {
                        if (c != '#') continue block96;
                        this._query = uri.substring(mark, i);
                        mark = i + 1;
                        this.addViolation(UriCompliance.Violation.FRAGMENT);
                        state = State.FRAGMENT;
                        continue block96;
                    }
                    case 10: {
                        throw new IllegalArgumentException("Bad character '*'");
                    }
                    case 9: {
                        this._fragment = uri.substring(mark, end);
                        i = end;
                        continue block96;
                    }
                    default: {
                        throw new IllegalStateException(state.toString());
                    }
                }
            }
            switch (state.ordinal()) {
                case 0: {
                    this._path = "";
                    this.checkSegment(uri, false, segment, end, false);
                    break;
                }
                case 10: {
                    break;
                }
                case 1: 
                case 2: {
                    this._path = uri.substring(mark, end);
                    break;
                }
                case 3: {
                    if (end <= mark) break;
                    this._host = uri.substring(mark, end);
                    this._path = "";
                    break;
                }
                case 4: {
                    throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                }
                case 5: {
                    try {
                        this._port = TypeUtil.parseInt((String)uri, (int)mark, (int)(end - mark), (int)10);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Bad Authority", nfe);
                    }
                    this._path = "";
                    break;
                }
                case 7: {
                    this._path = uri.substring(pathMark, end);
                    this._param = uri.substring(mark, end);
                    break;
                }
                case 6: {
                    this.checkSegment(uri, dot != false || encoded != false, segment, end, false);
                    this._path = uri.substring(pathMark, end);
                    break;
                }
                case 8: {
                    this._query = uri.substring(mark, end);
                    break;
                }
                case 9: {
                    this._fragment = uri.substring(mark, end);
                    break;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
            if (!encoded && !dot) {
                this._canonicalPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
            } else if (this._path != null) {
                this._canonicalPath = URIUtil.canonicalPath((String)this._path, (Supplier<RuntimeException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, onBadUtf8(), ()Ljava/lang/RuntimeException;)((Mutable)this));
                if (this._canonicalPath == null) {
                    throw new IllegalArgumentException("Bad URI");
                }
            }
        }

        private RuntimeException onBadUtf8() {
            this.addViolation(UriCompliance.Violation.BAD_UTF8_ENCODING);
            return null;
        }

        private void checkSegment(String uri, boolean dotOrEncoded, int segment, int end, boolean param) {
            Boolean ambiguous;
            if (this._emptySegment) {
                this.addViolation(UriCompliance.Violation.AMBIGUOUS_EMPTY_SEGMENT);
            }
            if (end == segment) {
                if (end >= uri.length() || "#?".indexOf(uri.charAt(end)) >= 0) {
                    return;
                }
                if (segment == 0) {
                    this.addViolation(UriCompliance.Violation.AMBIGUOUS_EMPTY_SEGMENT);
                    return;
                }
                if (!this._emptySegment) {
                    this._emptySegment = true;
                    return;
                }
            }
            Boolean bl = ambiguous = dotOrEncoded ? (Boolean)__ambiguousSegments.get(uri, segment, end - segment) : null;
            if (ambiguous != null) {
                if (Boolean.TRUE.equals(ambiguous)) {
                    this.addViolation(UriCompliance.Violation.AMBIGUOUS_PATH_SEGMENT);
                }
                if (param) {
                    this.addViolation(UriCompliance.Violation.AMBIGUOUS_PATH_PARAMETER);
                }
            }
        }

        private void addViolation(UriCompliance.Violation violation) {
            if (this._violations == null) {
                this._violations = EnumSet.of(violation);
            } else {
                this._violations.add(violation);
            }
        }

        private void removeViolation(UriCompliance.Violation violation) {
            if (this._violations == null) {
                return;
            }
            this._violations.remove(violation);
        }

        static {
            int i;
            __ambiguousSegments = new Index.Builder().caseSensitive(false).with(".", (Object)Boolean.FALSE).with("%2e", (Object)Boolean.TRUE).with("%u002e", (Object)Boolean.TRUE).with("..", (Object)Boolean.FALSE).with(".%2e", (Object)Boolean.TRUE).with(".%u002e", (Object)Boolean.TRUE).with("%2e.", (Object)Boolean.TRUE).with("%2e%2e", (Object)Boolean.TRUE).with("%2e%u002e", (Object)Boolean.TRUE).with("%u002e.", (Object)Boolean.TRUE).with("%u002e%2e", (Object)Boolean.TRUE).with("%u002e%u002e", (Object)Boolean.TRUE).build();
            __unreservedPctEncodedSubDelims = new boolean[128];
            __pathCharacters = new boolean[128];
            for (i = 0; i < __pathCharacters.length; ++i) {
                char c = (char)i;
                Mutable.__unreservedPctEncodedSubDelims[i] = Mutable.isUnreserved(c) || c == '%' || Mutable.isSubDelim(c);
                Mutable.__pathCharacters[i] = __unreservedPctEncodedSubDelims[i] || c == ':' || c == '@';
            }
            __suspiciousPathCharacters = new boolean[128];
            Mutable.__suspiciousPathCharacters[92] = true;
            Mutable.__suspiciousPathCharacters[127] = true;
            for (i = 0; i <= 31; ++i) {
                Mutable.__suspiciousPathCharacters[i] = true;
            }
        }

        private static enum State {
            START,
            HOST_OR_PATH,
            SCHEME_OR_PATH,
            HOST_OR_USER,
            IPV6,
            PORT_OR_PASSWORD,
            PATH,
            PARAM,
            QUERY,
            FRAGMENT,
            ASTERISK;

        }
    }

    public static class Immutable
    implements HttpURI,
    Serializable {
        private static final long serialVersionUID = 2245620284548399386L;
        private final String _scheme;
        private final String _user;
        private final String _host;
        private final int _port;
        private final String _path;
        private final String _param;
        private final String _query;
        private final String _fragment;
        private String _uri;
        private String _canonicalPath;
        private Set<UriCompliance.Violation> _violations;

        private Immutable(Mutable builder) {
            this._scheme = builder._scheme;
            this._user = builder._user;
            this._host = builder._host;
            this._port = builder._port;
            this._path = builder._path;
            this._param = builder._param;
            this._query = builder._query;
            this._fragment = builder._fragment;
            this._uri = builder._uri;
            this._canonicalPath = builder._canonicalPath;
            if (builder._violations != null) {
                this._violations = Collections.unmodifiableSet(EnumSet.copyOf(builder._violations));
            }
        }

        private Immutable(String scheme, String host, int port, String path, String query, String fragment) {
            this._uri = null;
            this._scheme = URIUtil.normalizeScheme((String)scheme);
            this._user = null;
            this._host = host;
            this._port = port > 0 ? port : -1;
            this._path = path;
            this._canonicalPath = this._path == null ? null : URIUtil.canonicalPath((String)this._path);
            this._param = null;
            this._query = query;
            this._fragment = fragment;
        }

        @Override
        public Immutable asImmutable() {
            return this;
        }

        @Override
        public String asString() {
            if (this._uri == null) {
                boolean hasFragment;
                int normalizedPort;
                StringBuilder out = new StringBuilder();
                if (this._scheme != null) {
                    out.append(this._scheme).append(':');
                }
                if (this._host != null) {
                    out.append("//");
                    if (this._user != null) {
                        out.append(this._user).append('@');
                    }
                    out.append(this._host);
                }
                if ((normalizedPort = URIUtil.normalizePortForScheme((String)this._scheme, (int)this._port)) > 0) {
                    out.append(':').append(normalizedPort);
                }
                boolean hasQuery = this._query != null;
                boolean bl = hasFragment = this._fragment != null;
                if (this._path != null) {
                    out.append(this._path);
                } else if (hasQuery || hasFragment) {
                    out.append('/');
                }
                if (hasQuery) {
                    out.append('?').append(this._query);
                }
                if (hasFragment) {
                    out.append('#').append(this._fragment);
                }
                this._uri = !out.isEmpty() ? out.toString() : "";
            }
            return this._uri;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpURI)) {
                return false;
            }
            return this.asString().equals(((HttpURI)o).asString());
        }

        @Override
        public String getAuthority() {
            if (this._port > 0) {
                return this._host + ":" + this._port;
            }
            return this._host;
        }

        @Override
        public String getDecodedPath() {
            return URIUtil.decodePath((String)this.getCanonicalPath());
        }

        @Override
        public String getCanonicalPath() {
            if (this._canonicalPath == null && this._path != null) {
                this._canonicalPath = URIUtil.canonicalPath((String)this._path);
            }
            return this._canonicalPath;
        }

        @Override
        public String getFragment() {
            return this._fragment;
        }

        @Override
        public String getHost() {
            if (this._host != null && this._host.isEmpty()) {
                return null;
            }
            return this._host;
        }

        @Override
        public String getParam() {
            return this._param;
        }

        @Override
        public String getPath() {
            return this._path;
        }

        @Override
        public String getPathQuery() {
            if (this._query == null) {
                return this._path;
            }
            return this._path + "?" + this._query;
        }

        @Override
        public int getPort() {
            return this._port;
        }

        @Override
        public String getQuery() {
            return this._query;
        }

        @Override
        public String getScheme() {
            return this._scheme;
        }

        @Override
        public String getUser() {
            return this._user;
        }

        @Override
        public boolean hasAuthority() {
            return this._host != null;
        }

        public int hashCode() {
            return this.asString().hashCode();
        }

        @Override
        public boolean isAbsolute() {
            return !StringUtil.isEmpty((String)this._scheme);
        }

        @Override
        public boolean isAmbiguous() {
            return this._violations != null && UriCompliance.isAmbiguous(this._violations);
        }

        @Override
        public boolean hasViolations() {
            return this._violations != null && !this._violations.isEmpty();
        }

        @Override
        public boolean hasViolation(UriCompliance.Violation violation) {
            return this._violations != null && this._violations.contains(violation);
        }

        @Override
        public Collection<UriCompliance.Violation> getViolations() {
            return this._violations == null ? Collections.emptySet() : this._violations;
        }

        public String toString() {
            return this.asString();
        }
    }
}

