/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.StartLog;

public class Classpath
implements Iterable<Path> {
    private final List<Path> elements = new ArrayList<Path>();

    public Classpath() {
    }

    public Classpath(String initial) {
        this.addClasspath(initial);
    }

    public boolean addClasspath(String s) {
        boolean added = false;
        if (s != null) {
            StringTokenizer t = new StringTokenizer(s, FS.pathSeparator());
            while (t.hasMoreTokens()) {
                added |= this.addComponent(t.nextToken());
            }
        }
        return added;
    }

    public boolean addComponent(Path file) {
        StartLog.debug("Adding classpath component: %s", file);
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            return false;
        }
        try {
            Path key = file.toRealPath(new LinkOption[0]);
            if (!this.elements.contains(key)) {
                this.elements.add(key);
                return true;
            }
        }
        catch (IOException e) {
            StartLog.debug(e);
        }
        return false;
    }

    public boolean addComponent(String component) {
        if (component == null || component.length() <= 0) {
            return false;
        }
        return this.addComponent(Paths.get(component, new String[0]));
    }

    public int count() {
        return this.elements.size();
    }

    public void dump(PrintStream out) {
        int i = 0;
        for (Path element : this.elements) {
            out.printf("%2d: %s%n", i++, element);
        }
    }

    public ClassLoader getClassLoader() {
        int cnt = this.elements.size();
        URL[] urls = new URL[cnt];
        for (int i = 0; i < cnt; ++i) {
            try {
                urls[i] = this.elements.get(i).toUri().toURL();
                StartLog.debug("URLClassLoader.url[%d] = %s", i, urls[i]);
                continue;
            }
            catch (MalformedURLException e) {
                StartLog.warn(e);
            }
        }
        StartLog.debug("Loaded %d URLs into URLClassLoader", urls.length);
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = Classpath.class.getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return new Loader(urls, parent);
    }

    public List<Path> getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    @Override
    public Iterator<Path> iterator() {
        return this.elements.iterator();
    }

    public void overlay(Classpath other) {
        for (Path otherElement : other.elements) {
            if (this.elements.contains(otherElement)) continue;
            this.elements.add(otherElement);
        }
    }

    public String toString() {
        return this.elements.stream().map(Path::toString).collect(Collectors.joining(FS.pathSeparator()));
    }

    private static class Loader
    extends URLClassLoader {
        Loader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public String toString() {
            return "startJarLoader@" + Long.toHexString(this.hashCode());
        }

        static {
            Loader.registerAsParallelCapable();
        }
    }
}

