/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.NaturalSort;
import org.eclipse.jetty.start.PathFinder;
import org.eclipse.jetty.start.PathMatchers;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.config.CommandLineConfigSource;
import org.eclipse.jetty.start.config.ConfigSource;
import org.eclipse.jetty.start.config.ConfigSources;
import org.eclipse.jetty.start.config.DirConfigSource;
import org.eclipse.jetty.start.config.JettyBaseConfigSource;
import org.eclipse.jetty.start.config.JettyHomeConfigSource;

public class BaseHome {
    public static final String JETTY_BASE = "jetty.base";
    public static final String JETTY_HOME = "jetty.home";
    private static final EnumSet<FileVisitOption> SEARCH_VISIT_OPTIONS = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
    private static final int MAX_SEARCH_DEPTH = Integer.getInteger("org.eclipse.jetty.start.searchDepth", 10);
    private final ConfigSources sources;
    private final Path homeDir;
    private final Path baseDir;

    public BaseHome() throws IOException {
        this(new String[0]);
    }

    public BaseHome(String[] cmdLine) throws IOException {
        this(new CommandLineConfigSource(cmdLine));
    }

    public BaseHome(CommandLineConfigSource cmdLineSource) throws IOException {
        this.sources = new ConfigSources();
        this.sources.add(cmdLineSource);
        this.homeDir = cmdLineSource.getHomePath();
        this.baseDir = cmdLineSource.getBasePath();
        StartLog.getInstance().initialize(this, cmdLineSource);
        this.sources.add(new JettyBaseConfigSource(cmdLineSource.getBasePath()));
        this.sources.add(new JettyHomeConfigSource(cmdLineSource.getHomePath()));
        System.setProperty(JETTY_HOME, this.homeDir.toAbsolutePath().toString());
        System.setProperty(JETTY_BASE, this.baseDir.toAbsolutePath().toString());
    }

    public BaseHome(ConfigSources sources) {
        this.sources = sources;
        Path home = null;
        Path base = null;
        for (ConfigSource source : sources) {
            if (source instanceof CommandLineConfigSource) {
                CommandLineConfigSource cmdline = (CommandLineConfigSource)source;
                home = cmdline.getHomePath();
                base = cmdline.getBasePath();
                continue;
            }
            if (source instanceof JettyBaseConfigSource) {
                base = ((JettyBaseConfigSource)source).getDir();
                continue;
            }
            if (!(source instanceof JettyHomeConfigSource)) continue;
            home = ((JettyHomeConfigSource)source).getDir();
        }
        Objects.requireNonNull(home, "jetty.home cannot be null");
        this.homeDir = home;
        this.baseDir = base != null ? base : home;
        System.setProperty(JETTY_HOME, this.homeDir.toAbsolutePath().toString());
        System.setProperty(JETTY_BASE, this.baseDir.toAbsolutePath().toString());
    }

    public String getBase() {
        if (this.baseDir == null) {
            return null;
        }
        return this.baseDir.toString();
    }

    public Path getBasePath() {
        return this.baseDir;
    }

    public Path getBasePath(String path) {
        return this.baseDir.resolve(path).normalize().toAbsolutePath();
    }

    public ConfigSources getConfigSources() {
        return this.sources;
    }

    public String getHome() {
        return this.homeDir.toString();
    }

    public Path getHomePath() {
        return this.homeDir;
    }

    public Path getPath(String path) {
        Path apath = FS.toPath(path);
        if (apath.isAbsolute() && FS.exists(apath)) {
            return apath;
        }
        for (ConfigSource source : this.sources) {
            DirConfigSource dirsource;
            Path file;
            if (!(source instanceof DirConfigSource) || !FS.exists(file = (dirsource = (DirConfigSource)source).getDir().resolve(apath))) continue;
            return file;
        }
        return FS.toPath(path);
    }

    public List<Path> getPaths(Path dir, int searchDepth, String pattern) throws IOException {
        if (PathMatchers.isAbsolute(pattern)) {
            throw new RuntimeException("Pattern cannot be absolute: " + pattern);
        }
        ArrayList<Path> hits = new ArrayList<Path>();
        if (FS.isValidDirectory(dir)) {
            PathMatcher matcher = PathMatchers.getMatcher(pattern);
            PathFinder finder = new PathFinder();
            finder.setFileMatcher(matcher);
            finder.setBase(dir);
            finder.setIncludeDirsInResults(true);
            Files.walkFileTree(dir, SEARCH_VISIT_OPTIONS, searchDepth, finder);
            hits.addAll(finder.getHits());
            Collections.sort(hits, new NaturalSort.Paths());
        }
        return hits;
    }

    public List<Path> getPaths(String pattern) throws IOException {
        StartLog.debug("getPaths('%s')", pattern);
        ArrayList<Path> hits = new ArrayList<Path>();
        if (PathMatchers.isAbsolute(pattern)) {
            Path root = PathMatchers.getSearchRoot(pattern);
            PathMatcher matcher = PathMatchers.getMatcher(pattern);
            if (FS.isValidDirectory(root)) {
                PathFinder finder = new PathFinder();
                finder.setIncludeDirsInResults(true);
                finder.setFileMatcher(matcher);
                finder.setBase(root);
                Files.walkFileTree(root, SEARCH_VISIT_OPTIONS, MAX_SEARCH_DEPTH, finder);
                hits.addAll(finder.getHits());
            }
        } else {
            Path relativePath = PathMatchers.getSearchRoot(pattern);
            PathMatcher matcher = PathMatchers.getMatcher(pattern);
            PathFinder finder = new PathFinder();
            finder.setIncludeDirsInResults(true);
            finder.setFileMatcher(matcher);
            ListIterator<ConfigSource> iter = this.sources.reverseListIterator();
            while (iter.hasPrevious()) {
                DirConfigSource dirsource;
                Path dir;
                Path deepDir;
                ConfigSource source = iter.previous();
                if (!(source instanceof DirConfigSource) || !FS.isValidDirectory(deepDir = (dir = (dirsource = (DirConfigSource)source).getDir()).resolve(relativePath))) continue;
                finder.setBase(dir);
                Files.walkFileTree(deepDir, SEARCH_VISIT_OPTIONS, MAX_SEARCH_DEPTH, finder);
            }
            hits.addAll(finder.getHits());
        }
        Collections.sort(hits, new NaturalSort.Paths());
        return hits;
    }

    public boolean isBaseDifferent() {
        return this.homeDir.compareTo(this.baseDir) != 0;
    }

    public String toShortForm(Path path) {
        Path apath = path.toAbsolutePath();
        for (ConfigSource source : this.sources) {
            DirConfigSource dirsource;
            Path dir;
            if (!(source instanceof DirConfigSource) || !apath.startsWith(dir = (dirsource = (DirConfigSource)source).getDir())) continue;
            if (dirsource.isPropertyBased()) {
                Path relative = dir.relativize(apath);
                return String.format("%s%s%s", dirsource.getId(), FS.separator(), relative.toString());
            }
            return apath.toString();
        }
        return apath.toString();
    }

    public String toShortForm(String path) {
        if (path == null || path.charAt(0) == '<') {
            return path;
        }
        return this.toShortForm(FS.toPath(path));
    }

    public static class SearchDir {
        private Path dir;
        private String name;

        public SearchDir(String name) {
            this.name = name;
        }

        public Path getDir() {
            return this.dir;
        }

        public Path resolve(Path subpath) {
            return this.dir.resolve(subpath);
        }

        public Path resolve(String subpath) {
            return this.dir.resolve(FS.separators(subpath));
        }

        public SearchDir setDir(Path path) {
            if (path != null) {
                this.dir = path.toAbsolutePath();
            }
            return this;
        }

        public SearchDir setDir(String path) {
            if (path != null) {
                return this.setDir(FS.toPath(path));
            }
            return this;
        }

        public String toShortForm(Path path) {
            Path relative = this.dir.relativize(path);
            return String.format("${%s}%s%s", this.name, FS.separator(), relative);
        }
    }
}

