/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api.frames;

import org.eclipse.jetty.util.TypeUtil;

public class Frame {
    public static final int DEFAULT_MAX_SIZE = 16384;
    private final long frameType;

    public Frame(long frameType) {
        this.frameType = frameType;
    }

    public long getFrameType() {
        return this.frameType;
    }

    public String toString() {
        return "%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode());
    }

    public static class WithStreamId
    extends Frame {
        private final long streamId;

        public WithStreamId(long frameType, long streamId) {
            super(frameType);
            this.streamId = streamId;
        }

        public long getStreamId() {
            return this.streamId;
        }

        @Override
        public String toString() {
            return "%s#%d".formatted(super.toString(), this.getStreamId());
        }
    }
}

