/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api.frames;

import org.eclipse.jetty.quic.api.frames.Frame;

public class ConnectionCloseFrame
extends Frame {
    private final long errorCode;
    private final String reason;
    private final long causeFrameType;

    public ConnectionCloseFrame(long appErrorCode, String reason) {
        this(29L, appErrorCode, reason, 0L);
    }

    public ConnectionCloseFrame(long quicErrorCode, String reason, long causeFrameType) {
        this(28L, quicErrorCode, reason, causeFrameType);
    }

    private ConnectionCloseFrame(long frameType, long errorCode, String reason, long causeFrameType) {
        super(frameType);
        this.errorCode = errorCode;
        this.reason = reason;
        this.causeFrameType = causeFrameType;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String getReason() {
        return this.reason;
    }

    public long getCauseFrameType() {
        return this.causeFrameType;
    }

    @Override
    public String toString() {
        boolean appError;
        boolean bl = appError = this.getFrameType() == 29L;
        if (appError) {
            return "%s[appError=0x%x,reason=%s]".formatted(super.toString(), this.getErrorCode(), this.getReason());
        }
        return "%s[quicError0x=%x,reason=%s,frame=%d]".formatted(super.toString(), this.getErrorCode(), this.getReason(), this.getCauseFrameType());
    }
}

