/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demo;

import org.eclipse.jetty.util.StringUtil;

public class ExampleUtil {
    public static int getPort(String[] args, String propertyName, int defValue) {
        for (String arg : args) {
            String value;
            int port;
            if (!arg.startsWith(propertyName + "=") || !ExampleUtil.isValidPort(port = ExampleUtil.toInt(value = arg.substring(propertyName.length() + 2)))) continue;
            return port;
        }
        String value = System.getProperty(propertyName);
        int port = ExampleUtil.toInt(value);
        if (ExampleUtil.isValidPort(port)) {
            return port;
        }
        return defValue;
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    private static int toInt(String value) {
        if (StringUtil.isBlank((String)value)) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }
}

