/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.Frame;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Promise;

public abstract class ProtocolStreamListener
implements Stream.Listener {
    protected abstract StreamEndPoint getStreamEndPoint();

    public void onDataAvailable(Stream stream) {
        this.getStreamEndPoint().fillable();
    }

    public void onIdleTimeout(Stream stream, TimeoutException failure, Promise.Invocable<Boolean> promise) {
        this.getStreamEndPoint().onIdleTimeout(failure, promise);
    }

    public void onFailure(Stream stream, Throwable failure) {
        this.getStreamEndPoint().onFailure(failure);
    }

    public static class Server
    extends ProtocolStreamListener {
        private final ProtocolSession protocolSession;
        private StreamEndPoint endPoint;

        public Server(ProtocolSession protocolSession) {
            this.protocolSession = protocolSession;
        }

        @Override
        protected StreamEndPoint getStreamEndPoint() {
            return this.endPoint;
        }

        public void onNewStream(Stream stream, Frame.WithStreamId frame) {
            this.endPoint = this.protocolSession.createStreamEndPoint(stream, this.protocolSession::openStreamEndPoint);
            super.onNewStream(stream, frame);
        }
    }

    public static class Client
    extends ProtocolStreamListener {
        private final Supplier<StreamEndPoint> endPoint;

        public Client(Supplier<StreamEndPoint> endPoint) {
            this.endPoint = endPoint;
        }

        @Override
        protected StreamEndPoint getStreamEndPoint() {
            return this.endPoint.get();
        }
    }
}

