/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.UnaryOperator;
import org.eclipse.jetty.http3.Grease;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.parser.BodyParser;
import org.eclipse.jetty.http3.parser.DataBodyParser;
import org.eclipse.jetty.http3.parser.HeaderParser;
import org.eclipse.jetty.http3.parser.HeadersBodyParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.http3.parser.PushPromiseBodyParser;
import org.eclipse.jetty.http3.parser.UnknownBodyParser;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.NanoTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(MessageParser.class);
    private final HeaderParser headerParser = new HeaderParser();
    private final BodyParser[] bodyParsers = new BodyParser[FrameType.maxType() + 1];
    private final ParserListener listener;
    private final QpackDecoder decoder;
    private final long streamId;
    private BodyParser unknownBodyParser;
    private State state = State.HEADER;
    private long beginNanoTime;
    private boolean beginNanoTimeStored;

    public MessageParser(ParserListener listener, QpackDecoder decoder, long streamId) {
        this.listener = listener;
        this.decoder = decoder;
        decoder.setBeginNanoTimeSupplier(this::getBeginNanoTime);
        this.streamId = streamId;
    }

    public void init(UnaryOperator<ParserListener> wrapper) {
        ParserListener listener = (ParserListener)wrapper.apply(this.listener);
        this.bodyParsers[FrameType.DATA.type()] = new DataBodyParser(this.headerParser, listener, this.streamId);
        this.bodyParsers[FrameType.HEADERS.type()] = new HeadersBodyParser(this.headerParser, listener, this.decoder, this.streamId);
        this.bodyParsers[FrameType.PUSH_PROMISE.type()] = new PushPromiseBodyParser(this.headerParser, listener);
        this.unknownBodyParser = new UnknownBodyParser(this.headerParser, listener);
    }

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
        this.beginNanoTimeStored = false;
    }

    private void storeBeginNanoTime() {
        if (!this.beginNanoTimeStored) {
            this.beginNanoTimeStored = true;
            this.beginNanoTime = NanoTime.now();
        }
    }

    private long getBeginNanoTime() {
        return this.beginNanoTime;
    }

    public ParserListener getListener() {
        return this.listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result parse(ByteBuffer buffer, boolean last) {
        try {
            block6: while (true) {
                switch (this.state.ordinal()) {
                    case 0: {
                        if (buffer.hasRemaining()) {
                            this.storeBeginNanoTime();
                        }
                        if (!this.headerParser.parse(buffer)) {
                            return Result.NO_FRAME;
                        }
                        this.state = State.BODY;
                        continue block6;
                    }
                    case 1: {
                        BodyParser.Result result;
                        BodyParser bodyParser = null;
                        long frameType = this.headerParser.getFrameType();
                        if (frameType >= 0L && frameType < (long)this.bodyParsers.length) {
                            bodyParser = this.bodyParsers[(int)frameType];
                        }
                        if (bodyParser == null) {
                            if (FrameType.isControl(frameType)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("invalid control frame type {} on message stream", (Object)Long.toHexString(frameType));
                                }
                                this.sessionFailure(buffer, HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_type", new IOException("invalid control frame in message stream"));
                                return Result.NO_FRAME;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("ignoring {} frame type {}", (Object)(Grease.isGreaseValue(frameType) ? "grease" : "unknown"), (Object)Long.toHexString(frameType));
                            }
                            if ((result = this.unknownBodyParser.parse(buffer, last)) == BodyParser.Result.NO_FRAME) {
                                return Result.NO_FRAME;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("parsed unknown frame body for type {}", (Object)Long.toHexString(frameType));
                            }
                            if (result != BodyParser.Result.WHOLE_FRAME) continue block6;
                            this.reset();
                            continue block6;
                        }
                        if (this.headerParser.getFrameLength() == 0L) {
                            bodyParser.emptyBody(buffer, last);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("parsed {} empty frame body from {}", (Object)FrameType.from(frameType), (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
                            }
                            this.reset();
                            return Result.FRAME;
                        }
                        result = bodyParser.parse(buffer, last);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("parsed {} {} body from {}", new Object[]{result, FrameType.from(frameType), BufferUtil.toDetailString((ByteBuffer)buffer)});
                        }
                        if (result == BodyParser.Result.NO_FRAME) {
                            return Result.NO_FRAME;
                        }
                        if (result == BodyParser.Result.FRAGMENT_FRAME) {
                            return Result.FRAME;
                        }
                        this.reset();
                        if (result == BodyParser.Result.BLOCKED_FRAME) {
                            return Result.BLOCKED_FRAME;
                        }
                        if (result == BodyParser.Result.WHOLE_FRAME) {
                            return Result.FRAME;
                        }
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse failed", x);
            }
            this.sessionFailure(buffer, HTTP3ErrorCode.INTERNAL_ERROR.code(), "parser_error", x);
            return Result.NO_FRAME;
        }
    }

    private void sessionFailure(ByteBuffer buffer, long error, String reason, Throwable failure) {
        this.unknownBodyParser.sessionFailure(buffer, error, reason, failure);
    }

    private static enum State {
        HEADER,
        BODY;

    }

    public static enum Result {
        NO_FRAME,
        FRAME,
        BLOCKED_FRAME;

    }
}

