/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http3.DecoderStreamConnection;
import org.eclipse.jetty.http3.EncoderStreamConnection;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.StreamType;
import org.eclipse.jetty.http3.internal.ControlStreamConnection;
import org.eclipse.jetty.http3.parser.ControlParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.quic.util.VarLenInt;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnidirectionalStreamConnection
extends AbstractConnection.NonBlocking
implements Connection.UpgradeFrom {
    private static final Logger LOG = LoggerFactory.getLogger(UnidirectionalStreamConnection.class);
    private final ByteBufferPool bufferPool;
    private final QpackEncoder encoder;
    private final QpackDecoder decoder;
    private final ParserListener listener;
    private final VarLenInt parser = new VarLenInt();
    private boolean useInputDirectByteBuffers = true;
    private RetainableByteBuffer buffer;

    public UnidirectionalStreamConnection(StreamEndPoint endPoint, Executor executor, ByteBufferPool bufferPool, QpackEncoder encoder, QpackDecoder decoder, ParserListener listener) {
        super((EndPoint)endPoint, executor);
        this.bufferPool = bufferPool;
        this.encoder = encoder;
        this.decoder = decoder;
        this.listener = listener;
    }

    public StreamEndPoint getEndPoint() {
        return (StreamEndPoint)super.getEndPoint();
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public ByteBuffer onUpgradeFrom() {
        int remaining = this.buffer.remaining();
        ByteBuffer copy = this.buffer.isDirect() ? ByteBuffer.allocateDirect(remaining) : ByteBuffer.allocate(remaining);
        copy.put(this.buffer.getByteBuffer());
        this.releaseBuffer();
        copy.flip();
        return copy;
    }

    public void onFillable() {
        block9: {
            try {
                int filled;
                block8: {
                    boolean parsed;
                    if (this.buffer == null) {
                        this.buffer = this.bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
                    }
                    ByteBuffer byteBuffer = this.buffer.getByteBuffer();
                    do {
                        filled = this.getEndPoint().fill(byteBuffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("filled {} on {}: {}", new Object[]{filled, this, this.buffer});
                        }
                        if (filled <= 0) break block8;
                    } while (!(parsed = this.parser.tryDecode(byteBuffer, value -> {
                        if (!this.detectAndUpgrade(value)) {
                            this.releaseBuffer();
                        }
                    })));
                    break block9;
                }
                if (filled == 0) {
                    this.releaseBuffer();
                    this.fillInterested();
                } else {
                    this.releaseBuffer();
                    this.getEndPoint().close();
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("could not process stream {}", (Object)this.getEndPoint(), (Object)x);
                }
                this.releaseBuffer();
                this.getEndPoint().close(x);
            }
        }
    }

    private void releaseBuffer() {
        this.buffer.release();
        this.buffer = null;
    }

    private boolean detectAndUpgrade(long type) {
        StreamType streamType = StreamType.from(type);
        if (streamType != null) {
            return switch (streamType) {
                case StreamType.CONTROL_STREAM -> {
                    ControlParser parser = new ControlParser(this.listener);
                    ControlStreamConnection newConnection = new ControlStreamConnection(this.getEndPoint(), this.getExecutor(), this.bufferPool, parser);
                    newConnection.setInputBufferSize(this.getInputBufferSize());
                    newConnection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("upgrading to {}", (Object)newConnection);
                    }
                    this.getEndPoint().upgrade((Connection)newConnection);
                    yield true;
                }
                case StreamType.ENCODER_STREAM -> {
                    EncoderStreamConnection newConnection = new EncoderStreamConnection((EndPoint)this.getEndPoint(), this.getExecutor(), this.bufferPool, this.decoder, this.listener);
                    newConnection.setInputBufferSize(this.getInputBufferSize());
                    newConnection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("upgrading to {}", (Object)newConnection);
                    }
                    this.getEndPoint().upgrade((Connection)newConnection);
                    yield true;
                }
                case StreamType.DECODER_STREAM -> {
                    DecoderStreamConnection newConnection = new DecoderStreamConnection((EndPoint)this.getEndPoint(), this.getExecutor(), this.bufferPool, this.encoder, this.listener);
                    newConnection.setInputBufferSize(this.getInputBufferSize());
                    newConnection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("upgrading to {}", (Object)newConnection);
                    }
                    this.getEndPoint().upgrade((Connection)newConnection);
                    yield true;
                }
                default -> {
                    IllegalArgumentException failure = new IllegalArgumentException("unsupported stream type: " + String.valueOf((Object)streamType));
                    this.getEndPoint().disconnect(HTTP3ErrorCode.STREAM_CREATION_ERROR.code(), (Throwable)failure, true, Promise.Invocable.noop());
                    yield false;
                }
            };
        }
        if (StreamType.isReserved(type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("reserved stream type {}, closing {}", (Object)Long.toHexString(type), (Object)this);
            }
            this.getEndPoint().disconnect(HTTP3ErrorCode.randomReservedCode(), null, true, Promise.Invocable.noop());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("invalid stream type {}, closing {}", (Object)Long.toHexString(type), (Object)this);
            }
            this.getEndPoint().disconnect(HTTP3ErrorCode.STREAM_CREATION_ERROR.code(), null, true, Promise.Invocable.noop());
        }
        return false;
    }
}

