/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheBinding;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.foreign.ForeignQuicheConnection;
import org.eclipse.jetty.quic.quiche.foreign.quiche_h;
import org.eclipse.jetty.util.TypeUtil;

public class ForeignQuicheBinding
implements QuicheBinding {
    private Throwable failure;

    public Throwable initialize() {
        try {
            quiche_h.initialize();
            this.failure = null;
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause();
            this.failure = cause != null ? cause : e;
        }
        catch (Throwable x) {
            this.failure = x;
        }
        return this.failure;
    }

    public int priority() {
        return 100;
    }

    public byte[] fromPacket(ByteBuffer packet) {
        return ForeignQuicheConnection.fromPacket(packet);
    }

    public Quiche connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        return ForeignQuicheConnection.connect(quicheConfig, local, peer, connectionIdLength);
    }

    public boolean negotiate(Quiche.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        return ForeignQuicheConnection.negotiate(tokenMinter, packetRead, packetToSend);
    }

    public Quiche tryAccept(QuicheConfig quicheConfig, Quiche.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        return ForeignQuicheConnection.tryAccept(quicheConfig, tokenValidator, packetRead, local, peer);
    }

    public String toString() {
        return TypeUtil.toShortName(this.getClass()) + "{p=" + this.priority() + " f=" + String.valueOf(this.failure) + "}";
    }
}

