/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.server.internal.HTTP3SessionServer;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3StreamServer
extends HTTP3Stream
implements Stream.Server,
Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3StreamServer.class);
    private static final Stream.Server.Listener DEFAULT_LISTENER = new Stream.Server.Listener(){};
    private Stream.Server.Listener listener;

    public HTTP3StreamServer(HTTP3Session session, StreamEndPoint endPoint, boolean local) {
        super(session, endPoint, local);
    }

    public HTTP3SessionServer getSession() {
        return (HTTP3SessionServer)super.getSession();
    }

    private Stream.Server.Listener getListener() {
        return this.listener;
    }

    public void onRequest(HeadersFrame frame) {
        this.validateAndUpdate(EnumSet.of(HTTP3Stream.FrameState.INITIAL), HTTP3Stream.FrameState.HEADER);
        this.onHeaders(frame);
        this.updateClose(frame.isLast(), false);
        this.listener = this.getSession().notifyRequest(frame);
        this.notifyRequest(frame);
    }

    private void notifyRequest(HeadersFrame frame) {
        Stream.Server.Listener listener = Objects.requireNonNullElse(this.getListener(), DEFAULT_LISTENER);
        try {
            listener.onRequest((Stream.Server)this, frame);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void respond(HeadersFrame frame, Promise.Invocable<Stream> promise) {
        this.write((Frame)frame, promise);
    }

    protected void notifyDataAvailable() {
        Stream.Server.Listener listener = Objects.requireNonNullElse(this.getListener(), DEFAULT_LISTENER);
        try {
            listener.onDataAvailable((Stream.Server)this);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected void notifyTrailer(HeadersFrame frame) {
        Stream.Server.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onTrailer((Stream.Server)this, frame);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected void notifyIdleTimeout(TimeoutException timeout, Promise<Boolean> promise) {
        Stream.Server.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onIdleTimeout((Stream.Server)this, timeout, promise);
            } else {
                promise.succeeded((Object)true);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            promise.failed(x);
        }
    }

    public void notifyFailure(long error, Throwable failure) {
        Stream.Server.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onFailure((Stream.Server)this, error, failure);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.getInvocationType((Object)this.getListener());
    }
}

