/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.common.decoders;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.decoders.AbstractDecoder;

public class FloatDecoder
extends AbstractDecoder
implements Decoder.Text<Float> {
    public static final FloatDecoder INSTANCE = new FloatDecoder();

    public Float decode(String s) throws DecodeException {
        try {
            Float val = Float.valueOf(Float.parseFloat(s));
            if (val.isNaN()) {
                throw new DecodeException(s, "NaN");
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse float", (Throwable)e);
        }
    }

    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Float val = Float.valueOf(Float.parseFloat(s));
            return !val.isNaN();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

